/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.gui.look.ui.ExtensionButtonUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.tools.I18N;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class ExtensionButton
extends JButton {
    private static final long serialVersionUID = -3435398786000739458L;
    private final int subprocessIndex;
    private final boolean add;

    public ExtensionButton(final OperatorChain chain, final int subprocessIndex, final boolean add) {
        super(new ResourceAction(add ? "add_subprocess" : "delete_subprocess", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (add) {
                    chain.addSubprocess(subprocessIndex + 1);
                } else {
                    chain.removeSubprocess(subprocessIndex);
                }
            }
        });
        this.setUI(new ExtensionButtonUI());
        this.subprocessIndex = subprocessIndex;
        this.add = add;
        this.setText(null);
        if (add) {
            if (subprocessIndex >= 0 && subprocessIndex < chain.getSubprocesses().size()) {
                this.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.action.add_subprocess.tip.after", chain.getSubprocess(subprocessIndex).getName()));
            }
            if (subprocessIndex == -1) {
                this.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.action.add_subprocess.tip.before", chain.getSubprocess(0).getName()));
            }
        } else if (subprocessIndex >= 0 && subprocessIndex < chain.getSubprocesses().size()) {
            this.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), "gui.action.delete_subprocess.tip.after", chain.getSubprocess(subprocessIndex).getName()));
        }
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public int getSubprocessIndex() {
        return this.subprocessIndex;
    }

    public boolean isAdd() {
        return this.add;
    }
}

