/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.tools.Ontology;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ExampleSetMetaDataTableModel
implements TableModel {
    private final List<AttributeMetaData> attributes;
    private static final String[] COLUMN_NAMES = new String[]{"Role", "Name", "Type", "Range", "Missings", "Comment"};
    private static final int ROLE_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int TYPE_COLUMN = 2;
    private static final int RANGE_COLUMN = 3;
    private static final int MISSINGS_COLUMN = 4;
    private static final int COMMENT_COLUMN = 5;

    public ExampleSetMetaDataTableModel(ExampleSetMetaData emd) {
        this.attributes = new LinkedList<AttributeMetaData>(emd.getAllAttributes());
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.attributes.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttributeMetaData amd = this.attributes.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return amd.getRole();
            }
            case 1: {
                String unit = amd.getAnnotations().getAnnotation("Unit");
                String name = amd.getName();
                if (unit != null) {
                    name = name + " [" + unit + "]";
                }
                return name;
            }
            case 2: {
                return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(amd.getValueType());
            }
            case 3: {
                return amd.getRangeString();
            }
            case 4: {
                return amd.getNumberOfMissingValues();
            }
            case 5: {
                return amd.getAnnotations().getAnnotation("Comment");
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Table is read only.");
    }

    public static Component makeTableForToolTip(ExampleSetMetaData emd) {
        ExtendedJTable table = new ExtendedJTable(new ExampleSetMetaDataTableModel(emd), true, true, true, false, false);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        return scrollPane;
    }
}

