/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.flow.QuickFixDialog;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.quickfix.QuickFix;
import com.rapidminer.tools.I18N;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class ErrorTable
extends JPanel
implements Dockable,
ProcessEditor {
    private static final long serialVersionUID = -954934789614113138L;
    private static final ImageIcon IMAGE_WARNING = SwingTools.createIcon("16/sign_warning.png");
    private static final ImageIcon IMAGE_ERROR = SwingTools.createIcon("16/error.png");
    private static final ImageIcon IMAGE_NO_QUICKFIX = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.no_quickfix_available.icon", new Object[0]));
    private static final ImageIcon IMAGE_QUICKFIX = SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.choose_quickfix.icon", new Object[0]));
    private static final String[] COLUMN_NAMES = new String[]{I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.header.message.label", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.header.fixes.label", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.header.location.label", new Object[0])};
    private static final String[] COLUMN_TOOLTIPS = new String[]{I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.header.message.tip", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.header.fixes.tip", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.header.location.tip", new Object[0])};
    private final MainFrame mainFrame;
    private final TableCellRenderer iconRenderer = new DefaultTableCellRenderer(){
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ProcessSetupError) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, ((ProcessSetupError)value).getMessage(), isSelected, hasFocus, row, column);
                switch (((ProcessSetupError)value).getSeverity()) {
                    case WARNING: {
                        label.setIcon(IMAGE_WARNING);
                        break;
                    }
                    case ERROR: {
                        label.setIcon(IMAGE_ERROR);
                        break;
                    }
                    default: {
                        label.setIcon(null);
                    }
                }
                return label;
            }
            if (value instanceof Port) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, ((Port)value).getSpec(), isSelected, hasFocus, row, column);
                label.setIcon(((Port)value).getPorts().getOwner().getOperator().getOperatorDescription().getSmallIcon());
                return label;
            }
            if (value instanceof Operator) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, ((Operator)value).getName(), isSelected, hasFocus, row, column);
                label.setIcon(((Operator)value).getOperatorDescription().getSmallIcon());
                return label;
            }
            if (column == 1) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    label.setIcon(IMAGE_NO_QUICKFIX);
                    label.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.no_quickfix_available.label", new Object[0]));
                }
                if (value instanceof List) {
                    label.setIcon(IMAGE_QUICKFIX);
                    label.setText(I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.choose_quickfix.label", ((List)value).size()));
                }
                if (value instanceof QuickFix) {
                    QuickFix quickFix = (QuickFix)value;
                    label.setIcon((Icon)quickFix.getAction().getValue("SmallIcon"));
                    label.setText(quickFix.toString());
                }
                return label;
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(null);
            return label;
        }
    };
    private final ExtendedJTable table = new ExtendedJTable(){
        private static final long serialVersionUID = 3731781319040565353L;

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return ErrorTable.this.iconRenderer;
        }

        @Override
        public void populatePopupMenu(JPopupMenu menu) {
            List<? extends QuickFix> fixes = ((ProcessSetupError)ErrorTable.this.errors.get(this.getSelectedRow())).getQuickFixes();
            if (!fixes.isEmpty()) {
                ResourceMenu fixMenu = new ResourceMenu("quick_fixes");
                for (QuickFix quickFix : fixes) {
                    fixMenu.add(quickFix.getAction());
                }
                menu.add(fixMenu);
                menu.addSeparator();
            }
            super.populatePopupMenu(menu);
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){
                private static final long serialVersionUID = -2000774622129683602L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return COLUMN_TOOLTIPS[realIndex];
                }
            };
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int realColumnIndex = this.convertColumnIndexToModel(this.columnAtPoint(p));
            int rowIndex = this.rowAtPoint(p);
            if (rowIndex >= 0 && rowIndex < this.getRowCount() && realColumnIndex == 1) {
                Object value = this.getModel().getValueAt(rowIndex, realColumnIndex);
                if (value == null) {
                    return I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.no_quickfix_available.tip", new Object[0]);
                }
                if (value instanceof List) {
                    return I18N.getMessage(I18N.getGUIBundle(), "gui.errortable.choose_quickfix.tip", ((List)value).size());
                }
                if (value instanceof QuickFix) {
                    return ((QuickFix)value).toString();
                }
            }
            return super.getToolTipText(e);
        }
    };
    private final JLabel headerLabel = new JLabel();
    private final JToggleButton onlyCurrent = new JToggleButton(new ResourceAction(true, "error_table_only_current", new Object[0]){
        private static final long serialVersionUID = -1454330266199555397L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ErrorTable.this.updateErrors();
        }
    });
    private List<ProcessSetupError> errors = new LinkedList<ProcessSetupError>();
    private final AbstractTableModel model = new AbstractTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return ErrorTable.this.errors.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ProcessSetupError error = (ProcessSetupError)ErrorTable.this.errors.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return error;
                }
                case 1: {
                    List<? extends QuickFix> fixes = error.getQuickFixes();
                    if (fixes.size() > 1) {
                        return fixes;
                    }
                    if (fixes.size() == 1) {
                        return fixes.get(0);
                    }
                    return null;
                }
                case 2: {
                    if (error instanceof MetaDataError) {
                        return ((MetaDataError)error).getPort();
                    }
                    return error.getOwner().getOperator();
                }
            }
            return null;
        }
    };
    private Process currentProcess;
    public static final String ERROR_TABLE_DOCK_KEY = "error_table";
    private final DockKey DOCK_KEY = new ResourceDockKey("error_table");
    private Operator currentOperator;

    public ErrorTable(MainFrame mainFrame) {
        super(new BorderLayout());
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.mainFrame = mainFrame;
        this.onlyCurrent.setSelected(false);
        this.table.setShowVerticalLines(false);
        this.table.setModel(this.model);
        this.table.installToolTip();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.table.setBorder(null);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.table);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        ViewToolBar toolBar = new ViewToolBar();
        toolBar.add(this.onlyCurrent);
        this.onlyCurrent.setText(null);
        toolBar.add(this.headerLabel);
        this.add((Component)toolBar, "North");
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    switch (ErrorTable.this.table.getSelectedColumn()) {
                        case 1: {
                            List<? extends QuickFix> quickFixes = ((ProcessSetupError)ErrorTable.this.errors.get(ErrorTable.this.table.getSelectedRow())).getQuickFixes();
                            if (quickFixes.size() == 1) {
                                quickFixes.get(0).apply();
                            }
                            if (quickFixes.size() <= 1) break;
                            new QuickFixDialog(quickFixes).setVisible(true);
                            break;
                        }
                        default: {
                            ProcessSetupError error = (ProcessSetupError)ErrorTable.this.errors.get(ErrorTable.this.table.getSelectedRow());
                            Operator op = error.getOwner().getOperator();
                            ErrorTable.this.mainFrame.selectOperator(op);
                        }
                    }
                }
            }
        });
    }

    private void updateErrors() {
        if (this.currentOperator != null && this.onlyCurrent.isSelected()) {
            this.fill(this.currentOperator);
        } else if (this.currentProcess != null) {
            this.fill(this.currentProcess.getRootOperator());
        }
    }

    private void fill(Operator root) {
        String errorString;
        int numTotal = root.getProcess().getRootOperator().getErrorList().size();
        this.errors = root.getErrorList();
        switch (this.errors.size()) {
            case 0: {
                errorString = "No problems found";
                break;
            }
            case 1: {
                errorString = "One potential problem";
                break;
            }
            default: {
                errorString = this.errors.size() + " potential problems";
            }
        }
        if (this.errors.size() != numTotal) {
            errorString = errorString + " (" + (numTotal - this.errors.size()) + " Filtered)";
        }
        this.headerLabel.setText(errorString);
        this.model.fireTableDataChanged();
    }

    @Override
    public void processChanged(Process process) {
        this.currentProcess = process;
        this.updateErrors();
    }

    @Override
    public void processUpdated(Process process) {
        this.currentProcess = process;
        this.updateErrors();
    }

    @Override
    public void setSelection(List<Operator> selection) {
        this.currentOperator = selection.isEmpty() ? null : selection.get(0);
        this.updateErrors();
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

