/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.flow;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.EditBlockingProgressThread;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import java.util.LinkedList;
import java.util.List;

public class AutoWireThread
extends EditBlockingProgressThread {
    private List<Operator> newOperators;

    private AutoWireThread(List<Operator> newOperators) {
        super("auto_wiring");
        this.newOperators = newOperators;
    }

    @Override
    public void execute() {
        this.getProgressListener().setTotal(this.newOperators.size() + 1);
        for (int i = 0; i < this.newOperators.size(); ++i) {
            Operator newOp = this.newOperators.get(i);
            this.getProgressListener().setCompleted(i + 1);
            newOp.getExecutionUnit().autoWireSingle(newOp, CompatibilityLevel.VERSION_5, RapidMinerGUI.getMainFrame().getNewOperatorEditor().shouldAutoConnectNewOperatorsInputs(), RapidMinerGUI.getMainFrame().getNewOperatorEditor().shouldAutoConnectNewOperatorsOutputs());
        }
        this.getProgressListener().complete();
    }

    public static void autoWireInBackground(List<Operator> newOperators, boolean firstMustBeWired) {
        if (!firstMustBeWired) {
            newOperators = new LinkedList<Operator>(newOperators);
            newOperators.remove(0);
        }
        if (RapidMinerGUI.getMainFrame().VALIDATE_AUTOMATICALLY_ACTION.isSelected()) {
            new AutoWireThread(newOperators).start();
        }
    }
}

