/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.docking;

import com.rapidminer.gui.docking.DetachedDockViewAsTab;
import com.rapidminer.gui.docking.RapidFloatingDialog;
import com.vlsolutions.swing.docking.DockViewAsTab;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.MaximizedDockViewAsTab;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.TabFactory;
import com.vlsolutions.swing.docking.TabbedDockView;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

public class RapidDockableContainerFactory
extends TabFactory {
    public SingleDockableContainer createDockableContainer(Dockable dockable, DockableContainerFactory.ParentType parentType) {
        switch (parentType) {
            case PARENT_TABBED_CONTAINER: {
                return new TabbedDockView(dockable);
            }
            case PARENT_DESKTOP: {
                return new MaximizedDockViewAsTab(dockable);
            }
            case PARENT_SPLIT_CONTAINER: {
                return new DockViewAsTab(dockable);
            }
            case PARENT_DETACHED_WINDOW: {
                return new DetachedDockViewAsTab(dockable);
            }
        }
        throw new RuntimeException("Wrong dockable container type");
    }

    public FloatingDockableContainer createFloatingDockableContainer(Window owner) {
        if (owner instanceof Dialog) {
            return new RapidFloatingDialog((Dialog)owner);
        }
        return new RapidFloatingDialog((Frame)owner);
    }
}

