/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.docking;

import com.vlsolutions.swing.docking.DockGroup;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.DockViewAsTab;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import com.vlsolutions.swing.docking.event.DockingActionCreateTabEvent;
import com.vlsolutions.swing.docking.event.DockingActionEvent;
import com.vlsolutions.swing.tabbedpane.JTabbedPaneSmartIcon;
import com.vlsolutions.swing.tabbedpane.SmartIconJButton;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class DetachedDockViewAsTab
extends DockViewAsTab {
    private static final long serialVersionUID = -2316449349513873264L;
    protected Action attachAction;
    protected SmartIconJButton attachSmartIcon;

    public DetachedDockViewAsTab(Dockable dockable) {
        super(dockable);
    }

    public void resetTabIcons() {
        this.attachAction = new AbstractAction("Attach"){
            private static final long serialVersionUID = 390635147992456838L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DetachedDockViewAsTab.this.desktop.setFloating(DetachedDockViewAsTab.this.getDockable(), false);
            }
        };
        this.attachSmartIcon = new SmartIconJButton(this.attachAction);
        this.attachAction.putValue("ShortDescription", UIManager.get("DockViewTitleBar.attachButtonText"));
        this.attachSmartIcon.setIcon(UIManager.getIcon("DockViewTitleBar.attach"));
        this.attachSmartIcon.setPressedIcon(UIManager.getIcon("DockViewTitleBar.attach.pressed"));
        this.attachSmartIcon.setRolloverIcon(UIManager.getIcon("DockViewTitleBar.attach.rollover"));
        ArrayList<SmartIconJButton> icons = new ArrayList<SmartIconJButton>();
        DockKey dockKey = this.getDockable().getDockKey();
        if (dockKey.isCloseEnabled()) {
            icons.add(this.closeSmartIcon);
        }
        if (dockKey.isFloatEnabled()) {
            icons.add(this.attachSmartIcon);
        }
        if (icons.size() > 0) {
            SmartIconJButton[] iconsArray = icons.toArray(new SmartIconJButton[0]);
            this.smartIcon = new JTabbedPaneSmartIcon(dockKey.getIcon(), dockKey.getName(), iconsArray);
            this.smartIcon.setIconForTabbedPane((JTabbedPane)this.tabHeader);
            this.tabHeader.addTab("", (Icon)this.smartIcon, this.getDockable().getComponent());
        } else {
            this.tabHeader.addTab(dockKey.getName(), dockKey.getIcon(), this.getDockable().getComponent());
        }
    }

    protected void scanDrop(DockEvent event, boolean drop) {
        if (this.getParent() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        if (event.getDragSource().getDockable() == this.dockable) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        if (event.getDragSource().getDockableContainer() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        Rectangle bounds = this.getBounds();
        DockGroup sourceGroup = event.getDragSource().getDockable().getDockKey().getDockGroup();
        DockGroup destinationGroup = this.dockable.getDockKey().getDockGroup();
        if (!DockGroup.areGroupsCompatible((DockGroup)destinationGroup, (DockGroup)sourceGroup)) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        Dockable sourceDockable = event.getDragSource().getDockable();
        DockableState.Location dockableLocation = sourceDockable.getDockKey().getLocation();
        DockableState.Location viewLocation = this.dockable.getDockKey().getLocation();
        if (drop) {
            event.setDockingAction((DockingActionEvent)new DockingActionCreateTabEvent(event.getDesktop(), sourceDockable, dockableLocation, viewLocation, this.dockable, 0));
            ((DockDropEvent)event).acceptDrop(false);
            this.desktop.createTab(this.dockable, event.getDragSource().getDockable(), 0, true);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
            event.setDockingAction((DockingActionEvent)new DockingActionCreateTabEvent(event.getDesktop(), sourceDockable, dockableLocation, viewLocation, this.dockable, 0));
            if (r2d.equals(this.lastDropShape)) {
                ((DockDragEvent)event).acceptDrag(this.lastDropGeneralPath);
            } else {
                GeneralPath path = this.buildPathForTab(bounds);
                this.lastDropShape = r2d;
                this.lastDropGeneralPath = path;
                ((DockDragEvent)event).acceptDrag(this.lastDropGeneralPath);
            }
        }
    }
}

