/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dnd;

import com.rapidminer.operator.Operator;
import com.rapidminer.repository.RepositoryLocation;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;

public class TransferableOperator
implements Transferable {
    public static final DataFlavor LOCAL_TRANSFERRED_OPERATORS_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Operator.class.getName(), "transferedOperatorArray");
    public static final DataFlavor LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + RepositoryLocation.class.getName(), "transferedOperatorArray");
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{LOCAL_TRANSFERRED_OPERATORS_FLAVOR, DataFlavor.stringFlavor};
    private final Operator[] transferedOperators;

    public TransferableOperator(Operator[] operators) {
        this.transferedOperators = operators;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(LOCAL_TRANSFERRED_OPERATORS_FLAVOR)) {
            return this.transferedOperators;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuilder b = new StringBuilder();
            for (Operator op : this.transferedOperators) {
                b.append(op.getXML(false));
            }
            return b.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(DATA_FLAVORS).contains(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    protected Operator[] getOperators() {
        return this.transferedOperators;
    }
}

