/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dnd;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.OperatorTransferHandler;
import com.rapidminer.gui.dnd.TransferableOperator;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.io.RepositorySource;
import com.rapidminer.operator.meta.ProcessEmbeddingOperator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class ReceivingOperatorTransferHandler
extends OperatorTransferHandler {
    private static final long serialVersionUID = 5355397064093668659L;
    private final List<DataFlavor> acceptableFlavors = new LinkedList<DataFlavor>();

    public ReceivingOperatorTransferHandler() {
        this.acceptableFlavors.add(TransferableOperator.LOCAL_TRANSFERRED_OPERATORS_FLAVOR);
        this.acceptableFlavors.add(TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR);
        this.acceptableFlavors.add(DataFlavor.javaFileListFlavor);
        this.acceptableFlavors.add(DataFlavor.stringFlavor);
    }

    protected abstract boolean dropNow(List<Operator> var1, Point var2);

    protected abstract void markDropOver(Point var1);

    protected abstract boolean isDropLocationOk(List<Operator> var1, Point var2);

    protected abstract void dropEnds();

    protected abstract Process getProcess();

    @Override
    public boolean canImport(TransferHandler.TransferSupport ts) {
        for (DataFlavor flavor : this.acceptableFlavors) {
            if (!ts.isDataFlavorSupported(flavor)) continue;
            if (ts.isDrop()) {
                this.markDropOver(ts.getDropLocation().getDropPoint());
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport ts) {
        boolean result;
        List<Operator> newOperators;
        Object transferData;
        if (!this.canImport(ts)) {
            return false;
        }
        DataFlavor acceptedFlavor = null;
        for (DataFlavor flavor : this.acceptableFlavors) {
            if (!ts.isDataFlavorSupported(flavor)) continue;
            acceptedFlavor = flavor;
            break;
        }
        if (acceptedFlavor == null) {
            this.dropEnds();
            return false;
        }
        try {
            transferData = ts.getTransferable().getTransferData(acceptedFlavor);
        }
        catch (Exception e1) {
            LogService.getRoot().log(Level.SEVERE, "While accepting drop: ", e1);
            this.dropEnds();
            return false;
        }
        if (acceptedFlavor.equals(DataFlavor.javaFileListFlavor)) {
            File file = (File)((List)transferData).get(0);
            if (file.getName().toLowerCase().endsWith(".rmp")) {
                try {
                    ProcessEmbeddingOperator processEmbedder = OperatorService.createOperator(ProcessEmbeddingOperator.class);
                    processEmbedder.setParameter("process_location", file.getAbsolutePath());
                    newOperators = Collections.singletonList(processEmbedder);
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("cannot_create_process_embedder", (Throwable)e, new Object[0]);
                    this.dropEnds();
                    return false;
                }
            }
            try {
                newOperators = Collections.singletonList(AbstractReader.createReader(file.toURI().toURL()));
            }
            catch (OperatorCreationException e1) {
                LogService.getRoot().log(Level.SEVERE, "While accepting drop: ", e1);
                SwingTools.showSimpleErrorMessage("cannot_create_reader_for_file", (Throwable)e1, file.getName());
                return false;
            }
            catch (MalformedURLException e) {
                LogService.getRoot().log(Level.SEVERE, "While accepting drop: ", e);
                SwingTools.showSimpleErrorMessage("cannot_create_reader_for_file", (Throwable)e, file.getName());
                return false;
            }
            if (newOperators == null) {
                JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), "No reader operator available for file " + file.getName());
                this.dropEnds();
                return false;
            }
        } else if (acceptedFlavor.equals(TransferableOperator.LOCAL_TRANSFERRED_OPERATORS_FLAVOR)) {
            if (!(transferData instanceof Operator[])) {
                LogService.getRoot().warning("Expected Operator[] for data flavor " + acceptedFlavor);
                this.dropEnds();
                return false;
            }
            newOperators = Arrays.asList((Operator[])transferData);
        } else if (acceptedFlavor.equals(DataFlavor.stringFlavor)) {
            if (!(transferData instanceof String)) {
                LogService.getRoot().warning("Expected String for data flavor " + acceptedFlavor);
                this.dropEnds();
                return false;
            }
            try {
                Process process = new Process((String)transferData);
                newOperators = process.getRootOperator().getSubprocess(0).getOperators();
            }
            catch (Exception e) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader((String)transferData)));
                    NodeList opElements = document.getDocumentElement().getChildNodes();
                    Operator newOp = null;
                    for (int i = 0; i < opElements.getLength(); ++i) {
                        Element elem;
                        Node child = opElements.item(i);
                        if (!(child instanceof Element) || !"operator".equals((elem = (Element)child).getTagName())) continue;
                        newOp = new XMLImporter(null).parseOperator(elem, RapidMiner.getVersion(), this.getProcess(), new LinkedList<UnknownParameterInformation>());
                        break;
                    }
                    if (newOp == null) {
                        LogService.getRoot().log(Level.WARNING, "Cannot parse operator from clipboard. No <operator> tag found. String is: " + transferData);
                        this.dropEnds();
                        return false;
                    }
                    newOperators = Collections.singletonList(newOp);
                }
                catch (Exception e1) {
                    LogService.getRoot().log(Level.WARNING, "Cannot parse operator from clipboard (" + e1 + "). String is: " + transferData, e1);
                    this.dropEnds();
                    return false;
                }
            }
        } else {
            boolean createSource;
            if (!acceptedFlavor.equals(TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR)) {
                this.dropEnds();
                return false;
            }
            if (!(transferData instanceof RepositoryLocation)) {
                LogService.getRoot().warning("Expected RepositoryLocation for data flavor " + acceptedFlavor);
                this.dropEnds();
                return false;
            }
            RepositoryLocation repositoryLocation = (RepositoryLocation)transferData;
            try {
                Entry entry = repositoryLocation.locateEntry();
                createSource = !(entry instanceof ProcessEntry);
            }
            catch (Exception e) {
                createSource = true;
            }
            String resolvedLocation = this.getProcess().getRepositoryLocation() != null ? repositoryLocation.makeRelative(this.getProcess().getRepositoryLocation().parent()) : repositoryLocation.getAbsoluteLocation();
            if (createSource) {
                try {
                    RepositorySource source = OperatorService.createOperator(RepositorySource.class);
                    source.setParameter("repository_entry", resolvedLocation);
                    newOperators = Collections.singletonList(source);
                }
                catch (OperatorCreationException e1) {
                    LogService.getRoot().log(Level.WARNING, "Cannot create RepositorySource: " + e1, e1);
                    return false;
                }
            }
            try {
                ProcessEmbeddingOperator embedder = OperatorService.createOperator(ProcessEmbeddingOperator.class);
                embedder.setParameter("process_location", resolvedLocation);
                newOperators = Collections.singletonList(embedder);
            }
            catch (OperatorCreationException e1) {
                LogService.getRoot().log(Level.WARNING, "Cannot create RepositorySource: " + e1, e1);
                return false;
            }
        }
        if (ts.isDrop()) {
            boolean result2;
            boolean dropLocationOk;
            Point loc = ts.getDropLocation().getDropPoint();
            boolean bl = dropLocationOk = !ts.isDrop() || this.isDropLocationOk(newOperators, loc);
            if (!dropLocationOk) {
                this.dropEnds();
                return false;
            }
            if (ts.getDropAction() == 2) {
                for (Operator operator : newOperators) {
                    operator.removeAndKeepConnections(newOperators);
                }
            }
            newOperators = this.cloneAll(newOperators);
            try {
                result2 = this.dropNow(newOperators, ts.isDrop() ? loc : null);
            }
            catch (RuntimeException e) {
                LogService.getRoot().log(Level.WARNING, "Error in drop: " + e, e);
                SwingTools.showVerySimpleErrorMessage("error_in_paste", e.getMessage(), e.getMessage());
                this.dropEnds();
                return false;
            }
            this.dropEnds();
            return result2;
        }
        newOperators = this.cloneAll(newOperators);
        try {
            result = this.dropNow(newOperators, null);
        }
        catch (RuntimeException e) {
            LogService.getRoot().log(Level.WARNING, "Error in paste: " + e, e);
            SwingTools.showVerySimpleErrorMessage("error_in_paste", e.getMessage(), e.getMessage());
            this.dropEnds();
            return false;
        }
        this.dropEnds();
        return result;
    }

    private List<Operator> cloneAll(List<Operator> operators) {
        LinkedList<Operator> result = new LinkedList<Operator>();
        for (Operator op : operators) {
            result.add(op.cloneOperator(op.getName(), false));
        }
        if (operators.size() > 1) {
            HashMap<String, Operator> originalOps = new HashMap<String, Operator>();
            for (Operator op : operators) {
                originalOps.put(op.getName(), op);
            }
            HashMap<String, Operator> clonedOps = new HashMap<String, Operator>();
            for (Operator op : result) {
                clonedOps.put(op.getName(), op);
            }
            for (Operator op : operators) {
                this.cloneConnections(op.getOutputPorts(), originalOps, clonedOps);
            }
            for (Operator op : operators) {
                op.getInputPorts().unlockPortExtenders();
                op.getOutputPorts().unlockPortExtenders();
            }
        }
        return result;
    }

    private void cloneConnections(OutputPorts originalPorts, Map<String, Operator> originalOperatorsByName, Map<String, Operator> clonedOperatorsByName) {
        for (OutputPort originalSource : originalPorts.getAllPorts()) {
            Operator mySourceOperator;
            if (!originalSource.isConnected() || (mySourceOperator = clonedOperatorsByName.get(originalSource.getPorts().getOwner().getOperator().getName())) == null) continue;
            OutputPort mySource = (OutputPort)mySourceOperator.getOutputPorts().getPortByName(originalSource.getName());
            if (mySource == null) {
                throw new RuntimeException("Error during clone: Corresponding source for " + originalSource + " not found (no such output port).");
            }
            InputPort originalDestination = originalSource.getDestination();
            Operator myDestOperator = clonedOperatorsByName.get(originalDestination.getPorts().getOwner().getOperator().getName());
            if (myDestOperator == null) continue;
            InputPort myDestination = (InputPort)myDestOperator.getInputPorts().getPortByName(originalDestination.getName());
            if (myDestination == null) {
                throw new RuntimeException("Error during clone: Corresponding destination for " + originalDestination + " not found (no such input port).");
            }
            mySource.connectTo(myDestination);
        }
    }
}

