/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dnd;

import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.ReceivingOperatorTransferHandler;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.operatortree.ProcessTreeModel;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;
import javax.swing.tree.TreePath;

public class OperatorTreeTransferHandler
extends ReceivingOperatorTransferHandler {
    private static final long serialVersionUID = -3039947430247192040L;
    private final OperatorTree operatorTree;
    private final Timer nodeExpandDelay = new Timer(1500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OperatorTreeTransferHandler.this.operatorTree.isRootVisible() && OperatorTreeTransferHandler.this.operatorTree.getRowForPath(OperatorTreeTransferHandler.this.currentPath) == 0) {
                return;
            }
            if (OperatorTreeTransferHandler.this.operatorTree.isExpanded(OperatorTreeTransferHandler.this.currentPath)) {
                OperatorTreeTransferHandler.this.operatorTree.collapsePath(OperatorTreeTransferHandler.this.currentPath);
            } else {
                OperatorTreeTransferHandler.this.operatorTree.expandPath(OperatorTreeTransferHandler.this.currentPath);
            }
        }
    }){
        private static final long serialVersionUID = 5805944782054617670L;
        {
            this.setRepeats(false);
        }
    };
    private DnDMarker currentDnDMarker = null;
    private TreePath currentPath;

    public OperatorTreeTransferHandler(OperatorTree operatorTree) {
        this.operatorTree = operatorTree;
    }

    @Override
    protected boolean dropNow(List<Operator> droppedOperators, Point loc) {
        if (loc != null || this.currentDnDMarker != null) {
            this.currentDnDMarker.drop(droppedOperators);
        } else {
            RapidMinerGUI.getMainFrame().getActions().insert(droppedOperators);
        }
        return true;
    }

    @Override
    protected void dropEnds() {
        this.currentPath = null;
        this.nodeExpandDelay.stop();
        this.currentDnDMarker = null;
    }

    @Override
    protected boolean isDropLocationOk(List<Operator> newOperators, Point loc) {
        return this.currentDnDMarker.canDrop(newOperators);
    }

    @Override
    protected void markDropOver(Point currentCursorLocation) {
        Object currentDropZone;
        this.currentPath = this.operatorTree.getClosestPathForLocation(currentCursorLocation.x, currentCursorLocation.y);
        Rectangle dropActionTriggerArea = this.operatorTree.getPathBounds(this.currentPath);
        if (dropActionTriggerArea != null && (currentDropZone = this.currentPath.getLastPathComponent()) != null) {
            int operatorPosition = this.operatorTree.getPathBounds((TreePath)this.currentPath).getLocation().y;
            double operatorHeight = this.operatorTree.getPathBounds(this.currentPath).getHeight();
            Position position = this.currentPath.getLastPathComponent() instanceof OperatorChain && ((OperatorChain)this.currentPath.getLastPathComponent()).getNumberOfSubprocesses() == 1 ? ((double)currentCursorLocation.y < (double)operatorPosition + operatorHeight / 3.0 ? Position.ABOVE : ((double)currentCursorLocation.y > (double)operatorPosition + operatorHeight * 2.0 / 3.0 ? Position.BELOW : Position.INTO)) : ((double)currentCursorLocation.y < (double)operatorPosition + operatorHeight / 2.0 ? Position.ABOVE : Position.BELOW);
            if (currentDropZone instanceof ExecutionUnit) {
                this.currentDnDMarker = new DnDMarker((ExecutionUnit)currentDropZone, position);
                this.nodeExpandDelay.restart();
            } else if (currentDropZone instanceof Operator) {
                if (((Operator)currentDropZone).getExecutionUnit() == null) {
                    position = Position.INTO;
                }
                this.currentDnDMarker = new DnDMarker((Operator)currentDropZone, position);
                if (currentDropZone instanceof OperatorChain) {
                    this.nodeExpandDelay.restart();
                }
            } else {
                throw new IllegalArgumentException("Nodes of tree must be Operators or ExecutionUnits.");
            }
        }
        Insets insets = new Insets(40, 40, 40, 40);
        Rectangle currentlyVisible = this.operatorTree.getVisibleRect();
        Rectangle validCursorArea = new Rectangle(currentlyVisible.x + insets.left, currentlyVisible.y + insets.top, currentlyVisible.width - (insets.left + insets.right), currentlyVisible.height - (insets.top + insets.bottom));
        if (!validCursorArea.contains(currentCursorLocation)) {
            Rectangle updatedArea = new Rectangle(currentCursorLocation.x - insets.left, currentCursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.operatorTree.scrollRectToVisible(updatedArea);
        }
    }

    @Override
    protected List<Operator> getDraggedOperators() {
        List<Operator> ops = this.operatorTree.getSelectedOperators();
        if (ops.isEmpty()) {
            return null;
        }
        return ops;
    }

    public Position getMarkerPosition(Operator operator) {
        if (this.currentDnDMarker == null) {
            return Position.UNMARKED;
        }
        if (this.currentDnDMarker.markedOperator == operator) {
            return this.currentDnDMarker.markerPosition;
        }
        return Position.UNMARKED;
    }

    public Position getMarkerPosition(ExecutionUnit unit) {
        if (this.currentDnDMarker == null) {
            return Position.UNMARKED;
        }
        if (this.currentDnDMarker.markedUnit == unit) {
            return this.currentDnDMarker.markerPosition;
        }
        return Position.UNMARKED;
    }

    @Override
    protected Process getProcess() {
        return ((Operator)((ProcessTreeModel)this.operatorTree.getModel()).getRoot()).getProcess();
    }

    private static class DnDMarker {
        private final ExecutionUnit markedUnit;
        private final Operator markedOperator;
        private final Position markerPosition;

        public DnDMarker(Operator operator, Position position) {
            this.markedOperator = operator;
            this.markerPosition = position;
            this.markedUnit = null;
        }

        private DnDMarker(ExecutionUnit unit, Position position) {
            this.markedUnit = unit;
            this.markerPosition = position;
            this.markedOperator = null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DnDMarker)) {
                return false;
            }
            DnDMarker marker = (DnDMarker)o;
            return marker != null && marker.markedOperator == this.markedOperator && marker.markerPosition == this.markerPosition && marker.markedUnit == this.markedUnit;
        }

        public boolean canDrop(List<Operator> operators) {
            Operator target = this.markedOperator;
            if (target.getExecutionUnit() == null && this.markerPosition != Position.INTO) {
                return false;
            }
            for (Operator operator : operators) {
                if (!(operator instanceof OperatorChain)) continue;
                if (target == operator) {
                    return false;
                }
                if (this.markedUnit != null) {
                    target = this.markedUnit.getEnclosingOperator();
                }
                if (target != operator && !((OperatorChain)operator).getAllInnerOperators().contains(target)) continue;
                return false;
            }
            return true;
        }

        public void drop(List<Operator> operators) {
            if (this.markedOperator != null) {
                if (this.markerPosition == Position.INTO) {
                    for (Operator operator : operators) {
                        ((OperatorChain)this.markedOperator).getSubprocess(0).addOperator(operator);
                    }
                } else {
                    ExecutionUnit executionUnit = this.markedOperator.getExecutionUnit();
                    if (executionUnit == null) {
                        return;
                    }
                    int newIndex = executionUnit.getOperators().indexOf(this.markedOperator);
                    if (this.markerPosition == Position.BELOW) {
                        ++newIndex;
                    }
                    int i = 0;
                    for (Operator operator : operators) {
                        executionUnit.addOperator(operator, newIndex + i);
                        ++i;
                    }
                }
            } else {
                switch (this.markerPosition) {
                    case ABOVE: {
                        int i = 0;
                        for (Operator operator : operators) {
                            this.markedUnit.addOperator(operator, i);
                            ++i;
                        }
                        break;
                    }
                    case BELOW: {
                        for (Operator operator : operators) {
                            this.markedUnit.addOperator(operator);
                        }
                        break;
                    }
                }
            }
            for (Operator operator : operators) {
                if (!RapidMinerGUI.getMainFrame().VALIDATE_AUTOMATICALLY_ACTION.isSelected()) continue;
                operator.getExecutionUnit().autoWireSingle(operator, CompatibilityLevel.VERSION_5, RapidMinerGUI.getMainFrame().getNewOperatorEditor().shouldAutoConnectNewOperatorsInputs(), RapidMinerGUI.getMainFrame().getNewOperatorEditor().shouldAutoConnectNewOperatorsOutputs());
            }
        }
    }

    public static enum Position {
        ABOVE,
        BELOW,
        INTO,
        UNMARKED;

    }
}

