/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dnd;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dnd.TransferableOperator;
import com.rapidminer.gui.operatortree.actions.CutCopyPasteAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.tools.LogService;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;

public abstract class OperatorTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    protected abstract List<Operator> getDraggedOperators();

    @Override
    public Icon getVisualRepresentation(Transferable transferable) {
        if (transferable instanceof TransferableOperator) {
            try {
                Operator op = (Operator)transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                return op.getOperatorDescription().getIcon();
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Error while dragging: " + e, e);
                return null;
            }
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        List<Operator> operators = this.getDraggedOperators();
        if (operators == null || operators.isEmpty()) {
            return null;
        }
        Iterator<Operator> i = operators.iterator();
        while (i.hasNext()) {
            Operator op = i.next();
            OperatorChain parent = op.getParent();
            while (parent != null) {
                if (operators.contains(parent)) {
                    i.remove();
                    continue;
                }
                parent = parent.getParent();
            }
        }
        return new TransferableOperator(operators.toArray(new Operator[operators.size()]));
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (data instanceof TransferableOperator) {
            TransferableOperator top = (TransferableOperator)data;
            switch (action) {
                case 2: {
                    OperatorChain parent = null;
                    for (Operator operator : top.getOperators()) {
                        if (parent == null) {
                            parent = operator.getParent();
                        }
                        operator.removeAndKeepConnections(Arrays.asList(top.getOperators()));
                    }
                    if (parent == null) break;
                    RapidMinerGUI.getMainFrame().selectOperator(parent);
                    break;
                }
            }
        }
        super.exportDone(source, data, action);
    }

    public static void installMenuItems(JPopupMenu editmenu) {
        editmenu.add(CutCopyPasteAction.CUT_ACTION);
        editmenu.add(CutCopyPasteAction.COPY_ACTION);
        editmenu.add(CutCopyPasteAction.PASTE_ACTION);
    }

    public static void installMenuItems(JMenu editmenu) {
        editmenu.add(CutCopyPasteAction.CUT_ACTION);
        editmenu.add(CutCopyPasteAction.COPY_ACTION);
        editmenu.add(CutCopyPasteAction.PASTE_ACTION);
    }

    public static void addToActionMap(JComponent component) {
        ActionMap actionMap = component.getActionMap();
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        InputMap inputMap = component.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke("ctrl X"), TransferHandler.getCutAction().getValue("Name"));
        inputMap.put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
        inputMap.put(KeyStroke.getKeyStroke("ctrl V"), TransferHandler.getPasteAction().getValue("Name"));
    }
}

