/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.Process;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Tutorial
extends ButtonDialog
implements WindowListener {
    private static final long serialVersionUID = 2826577972132069114L;
    private static final String START_TEXT = "<h2>Welcome to the RapidMiner online tutorial!</h2><p>This tutorial demonstrates basic concepts of RapidMiner and simple process setups which can be performed. The user should have some knowledge in the domains of data mining and ETL.</p><p>Whenever this tutorial refers to the &quot;RapidMiner Tutorial / Manual&quot;, it means the printed version of the RapidMiner manual available at<br><br><center><code>http://rapid-i.com</code></center></p><p>You should read the RapidMiner Manual for better motivation and an idea of the basic concepts of RapidMiner, but you can also try to start with the online tutorial without reading the printed version first. Please read the texts carefully and try at least the suggested steps. The online tutorial will take about one hour.</p><br><h4>Please note:</h4><p>Most parts of RapidMiner provide additional information if you hold the mouse pointer a few moments on the part (tool tip texts). In this way all operators and parameters are described too.</p>";
    private static final String END_TEXT = "<h2>Congratulations!</h2><p>You have finished the RapidMiner online tutorial. You should be able to perform many of the possible process definitions. Now, you know the most important building blocks of the possible data mining process definitions. Of course these building blocks can be arbitrarily nested in RapidMiner as long as their input and output types fits. For a reference of all operators please refer to the RapidMiner Tutorial. Check also the other sample process setups which can be found in the sample directory of RapidMiner.</p><p>We have added many known preprocessing steps and learning operators to RapidMiner. Most data formats can also be handled. If you need to adapt RapidMiner you should read the chapter of the RapidMiner Tutorial which describes the creation of operators and the extension mechanism. RapidMiner can easily be extended. Have fun!</p>";
    private static final String[] PROCESSES;
    private int state = 0;
    private final MainFrame mainFrame;
    private final JEditorPane description;
    private final JScrollPane descriptionScrollPane;
    private final JButton prevButton;
    private final JButton nextButton;

    public Tutorial(MainFrame mainFrame) {
        super("tutorial", false, new Object[0]);
        this.mainFrame = mainFrame;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.description = new ExtendedHTMLJEditorPane("text/html", SwingTools.text2DisplayHtml(START_TEXT));
        this.description.setEditable(false);
        this.description.setBackground(this.getBackground());
        this.description.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.descriptionScrollPane = new ExtendedJScrollPane(this.description);
        this.descriptionScrollPane.setBorder(Tutorial.createBorder());
        this.prevButton = new JButton(new ResourceAction("previous", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Tutorial.this.previous();
            }
        });
        this.prevButton.setEnabled(false);
        this.nextButton = new JButton(new ResourceAction("next", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Tutorial.this.next();
            }
        });
        mainFrame.setTutorialMode(true);
        this.layoutDefault((JComponent)this.descriptionScrollPane, this.prevButton, this.nextButton, this.makeCloseButton());
        this.setSize(500, 600);
        this.setLocationRelativeTo(mainFrame);
    }

    private void setProcess(String processName) {
        Process process;
        try {
            RepositoryLocation loc = new RepositoryLocation("//" + RepositoryManager.getInstance(null).getSampleRepository().getName() + '/' + "processes" + '/' + processName);
            process = new RepositoryProcessLocation(loc).load(null);
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("cannot_load_tutorial_file", (Throwable)e, processName);
            this.dispose();
            return;
        }
        RapidMinerGUI.getMainFrame().setOpenedProcess(process, false, null);
        this.description.setText(SwingTools.text2DisplayHtml(process.getRootOperator().getUserDescription()));
        this.description.getCaret().setDot(0);
        this.descriptionScrollPane.getVerticalScrollBar().setValue(0);
        this.setTitle("RapidMiner Tutorial - Step " + this.state + " of " + PROCESSES.length);
    }

    private void previous() {
        this.nextButton.setEnabled(true);
        if (this.state > 0) {
            --this.state;
        }
        if (this.state == 0) {
            this.prevButton.setEnabled(false);
            this.description.setText(SwingTools.text2DisplayHtml(START_TEXT));
        } else {
            this.setProcess(PROCESSES[this.state - 1]);
        }
    }

    private void next() {
        this.prevButton.setEnabled(true);
        if (this.state < PROCESSES.length + 1) {
            ++this.state;
        }
        if (this.state == PROCESSES.length + 1) {
            this.nextButton.setEnabled(false);
            this.description.setText(SwingTools.text2DisplayHtml(END_TEXT));
        } else {
            this.setProcess(PROCESSES[this.state - 1]);
        }
    }

    @Override
    protected void close() {
        this.mainFrame.setTutorialMode(false);
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    static {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Font f = new Font("SansSerif", 0, 12);
        FontUIResource font = new FontUIResource(f);
        uiDefaults.put("EditorPane.font", font);
        PROCESSES = new String[]{"01_Learner/01_DecisionTree", "01_Learner/12_AssociationRules", "01_Learner/19_Stacking", "07_Clustering/01_KMeans", "05_Visualisation/08_SVMVisualisation", "02_Preprocessing/07_MissingValueReplenishment", "02_Preprocessing/08_NoiseGenerator", "02_Preprocessing/15_ExampleSetJoin", "03_Validation/03_XValidation_Numerical", "01_Learner/14_CostSensitiveLearningAndROCPlot", "01_Learner/13_AsymmetricCostLearning", "01_Learner/18_SimpleCostSensitiveLearning", "04_Attributes/03_PrincipalComponents", "04_Attributes/10_ForwardSelection", "04_Attributes/18_MultiobjectiveSelection", "03_Validation/12_WrapperValidation", "04_Attributes/19_YAGGA", "04_Attributes/20_YAGGAResultAttributeSetting", "02_Preprocessing/12_UserDefinedFeatureGeneration", "04_Attributes/13_EvolutionaryWeighting", "05_Visualisation/07_DataSetAndWeightsVisualisation", "06_Meta/01_ParameterOptimization", "06_Meta/06_OperatorEnabler", "04_Attributes/17_WeightingThreshold", "03_Validation/13_SignificanceTest", "02_Preprocessing/24_GroupBasedCalculations"};
    }
}

