/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.WizardPropertyTable;
import com.rapidminer.gui.templates.OperatorParameterPair;
import com.rapidminer.gui.templates.Template;
import com.rapidminer.gui.templates.TemplatesDialog;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.gui.tools.dialogs.wizards.AbstractWizard;
import com.rapidminer.gui.tools.dialogs.wizards.WizardStep;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TemplateWizardDialog
extends AbstractWizard {
    private static final long serialVersionUID = 1L;
    private Process process = null;
    private Template template;
    private Collection<OperatorParameterPair> parameters = null;

    public TemplateWizardDialog() {
        super((Frame)RapidMinerGUI.getMainFrame(), "open_template", true, new Object[0]);
        this.addStep(new WizardStep("open_template.choose_template"){
            private TemplatesDialog dialog;
            private JPanel panel;
            {
                this.dialog = new TemplatesDialog(2);
                this.dialog.addChangeListener(TemplateWizardDialog.this);
                this.panel = this.dialog.createTemplateManagementPanel();
            }

            @Override
            protected boolean canGoBack() {
                return false;
            }

            @Override
            protected boolean canProceed() {
                return this.dialog.getSelectedTemplate() != null;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                try {
                    TemplateWizardDialog.this.template = this.dialog.getSelectedTemplate();
                    TemplateWizardDialog.this.process = TemplateWizardDialog.this.template.getProcess();
                    TemplateWizardDialog.this.parameters = TemplateWizardDialog.this.template.getParameters();
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Error loading process template: " + e, e);
                    return false;
                }
                return true;
            }

            @Override
            protected JComponent getComponent() {
                return this.panel;
            }
        });
        this.addStep(new WizardStep("open_template.parameters"){
            private WizardPropertyTable propertyTable;
            private JLabel headerLabel;
            {
                this.propertyTable = new WizardPropertyTable();
                this.headerLabel = new JLabel();
            }

            @Override
            protected boolean canGoBack() {
                return true;
            }

            @Override
            protected boolean canProceed() {
                return true;
            }

            @Override
            protected boolean performEnteringAction(AbstractWizard.WizardStepDirection direction) {
                if (TemplateWizardDialog.this.process == null || TemplateWizardDialog.this.parameters == null) {
                    return false;
                }
                this.propertyTable.setProcess(TemplateWizardDialog.this.process, TemplateWizardDialog.this.parameters);
                this.headerLabel.setText(TemplateWizardDialog.this.template.getHTMLDescription());
                return true;
            }

            @Override
            protected boolean performLeavingAction(AbstractWizard.WizardStepDirection direction) {
                RapidMinerGUI.getMainFrame().setProcess(TemplateWizardDialog.this.process, true);
                return true;
            }

            @Override
            protected JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout());
                ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.propertyTable);
                tablePane.setBorder(ButtonDialog.createBorder());
                panel.add((Component)tablePane, "Center");
                panel.add((Component)this.headerLabel, "North");
                return panel;
            }
        });
        this.layoutDefault();
    }
}

