/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.dialog.SearchableTextComponent;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchDialog
extends ButtonDialog {
    private static final long serialVersionUID = -1019890951712706875L;
    private final JTextField patternField = new JTextField(20);
    private final JTextField replaceField = new JTextField(20);
    private final JCheckBox caseSensitive = new JCheckBox(new ResourceActionAdapter("case_sensitive", new Object[0]));
    private final JCheckBox regExp = new JCheckBox(new ResourceActionAdapter("search_regular_expression", new Object[0]));
    private final JRadioButton forwardRadioButton = new JRadioButton(new ResourceActionAdapter("search_forward", new Object[0]));
    private final JRadioButton backwardRadioButton = new JRadioButton(new ResourceActionAdapter("search_backward", new Object[0]));
    private final transient SearchableTextComponent textComponent;

    public SearchDialog(Component owner, SearchableTextComponent textComponent) {
        this(owner, textComponent, false);
    }

    public SearchDialog(Component owner, SearchableTextComponent textComponent, boolean allowReplace) {
        super("search_replace", false, new Object[0]);
        this.textComponent = textComponent;
        this.textComponent.requestFocus();
        this.textComponent.setCaretPosition(0);
        if (allowReplace) {
            this.setTitle(I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".search_replace.title", new Object[0]));
        } else {
            this.setTitle(I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".search.title", new Object[0]));
        }
        JPanel searchPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(4, 0, 4, 0);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        ResourceLabel label = new ResourceLabel("search_what", new Object[0]);
        searchPanel.add((Component)label, c);
        c.gridwidth = 0;
        c.gridx = 1;
        c.gridy = 0;
        searchPanel.add((Component)this.patternField, c);
        label.setLabelFor(this.patternField);
        LinkedList<AbstractButton> buttons = new LinkedList<AbstractButton>();
        JButton search = new JButton(new ResourceAction("start_search", new Object[0]){
            private static final long serialVersionUID = -7450018802479146549L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.search();
            }
        });
        buttons.add(search);
        if (allowReplace) {
            c.insets = new Insets(4, 0, 4, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 1;
            label = new ResourceLabel("replace_with", new Object[0]);
            searchPanel.add((Component)label, c);
            c.gridwidth = 0;
            c.gridx = 1;
            c.gridy = 1;
            searchPanel.add((Component)this.replaceField, c);
            JButton replaceButton = new JButton(new ResourceAction("start_replace", new Object[0]){
                private static final long serialVersionUID = -5028551435610677265L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.replace();
                    SearchDialog.this.search();
                }
            });
            buttons.add(replaceButton);
        }
        GridLayout settingsPanelLayout = new GridLayout(1, 2);
        settingsPanelLayout.setVgap(0);
        settingsPanelLayout.setHgap(0);
        JPanel settingsPanel = new JPanel(settingsPanelLayout);
        GridLayout directionPanelLayout = new GridLayout(2, 1);
        directionPanelLayout.setVgap(0);
        directionPanelLayout.setHgap(0);
        JPanel directionPanel = new JPanel(directionPanelLayout);
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        ButtonGroup directionGroup = new ButtonGroup();
        directionGroup.add(this.forwardRadioButton);
        directionGroup.add(this.backwardRadioButton);
        this.forwardRadioButton.setSelected(true);
        directionPanel.add(this.forwardRadioButton);
        directionPanel.add(this.backwardRadioButton);
        settingsPanel.add(directionPanel);
        JPanel optionsPanel = new JPanel(new GridLayout(2, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        optionsPanel.add(this.caseSensitive);
        optionsPanel.add(this.regExp);
        settingsPanel.add(optionsPanel);
        c.gridwidth = 0;
        c.gridx = 0;
        c.gridy = 2;
        searchPanel.add((Component)settingsPanel, c);
        buttons.add(this.makeCloseButton());
        this.layoutDefault((JComponent)searchPanel, buttons);
        this.getRootPane().setDefaultButton(search);
    }

    private void search() {
        String text;
        String pattern = this.patternField.getText().trim();
        if (pattern.length() == 0) {
            return;
        }
        int startPos = this.textComponent.getCaretPosition();
        if (startPos > (text = this.textComponent.getText()).length()) {
            startPos = 0;
        }
        if (this.forwardRadioButton.isSelected()) {
            Result result = this.search(startPos, pattern, text, this.textComponent.canHandleCarriageReturn());
            if (result == null) {
                this.noMoreHits();
                return;
            }
            this.textComponent.select(result.start, result.end);
        } else {
            Result result;
            Result lastResult = null;
            int pos = 0;
            while ((result = this.search(pos, pattern, text, this.textComponent.canHandleCarriageReturn())) != null && result.end < startPos) {
                pos = result.start + 1;
                lastResult = result;
            }
            if (lastResult == null) {
                this.noMoreHits();
            } else {
                this.textComponent.select(lastResult.start, lastResult.end);
            }
        }
    }

    private void replace() {
        this.textComponent.replaceSelection(this.replaceField.getText());
    }

    private Result search(int start, String pattern, String text, boolean canHandleCarriageReturn) {
        int result;
        if (!canHandleCarriageReturn) {
            text = Tools.transformAllLineSeparators(text);
        }
        if (this.regExp.isSelected()) {
            Matcher matcher = Pattern.compile(pattern, this.caseSensitive.isSelected() ? 0 : 2).matcher(text.subSequence(start, text.length()));
            if (matcher.find()) {
                return new Result(start + matcher.start(), start + matcher.end());
            }
            return null;
        }
        if (!this.caseSensitive.isSelected()) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        if ((result = text.indexOf(pattern, start)) == -1) {
            return null;
        }
        return new Result(result, result + pattern.length());
    }

    private void noMoreHits() {
        String restartAt = this.backwardRadioButton.isSelected() ? "end" : "beginning";
        switch (SwingTools.showConfirmDialog("editor.search_replace.no_more_hits", 0, restartAt)) {
            case 0: {
                this.textComponent.setCaretPosition(this.backwardRadioButton.isSelected() ? this.textComponent.getText().replaceAll("\r", "").length() : 0);
                this.search();
                break;
            }
            default: {
                return;
            }
        }
    }

    private static class Result {
        private final int start;
        private final int end;

        private Result(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "start: " + this.start + ", end: " + this.end;
        }
    }
}

