/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.ResultContainer;
import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.XMLEditor;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import com.rapidminer.tools.math.TestGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResultHistoryDialog
extends JDialog {
    private static final long serialVersionUID = 7498142147390911809L;
    private final transient Action ANOVA_ACTION = new AnovaAction();
    private List<TestGroup> selectedTestGroups = new LinkedList<TestGroup>();

    public ResultHistoryDialog(Frame owner) {
        super(owner, "Result Comparator");
        this.setLayout(new BorderLayout());
        JSplitPane resultSelectionSplitPane = new JSplitPane(0);
        resultSelectionSplitPane.setBorder(null);
        JPanel processSelectionPanel = new JPanel();
        processSelectionPanel.setBorder(null);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        processSelectionPanel.setLayout(layout);
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        final JList resultSelectionList = new JList(RapidMinerGUI.getResultHistory());
        resultSelectionList.setBorder(null);
        resultSelectionList.setSelectionMode(2);
        ExtendedJScrollPane listPane = new ExtendedJScrollPane(resultSelectionList);
        c.weighty = 1.0;
        layout.setConstraints(listPane, c);
        processSelectionPanel.add(listPane);
        JPanel testPanel = new JPanel(new FlowLayout(1));
        testPanel.setBorder(null);
        this.ANOVA_ACTION.setEnabled(false);
        JButton testButton = new JButton(this.ANOVA_ACTION);
        testPanel.add(testButton);
        c.weighty = 0.0;
        layout.setConstraints(testPanel, c);
        processSelectionPanel.add(testPanel);
        ExtendedJTabbedPane processTabbedPane = new ExtendedJTabbedPane();
        processTabbedPane.add("Process", processSelectionPanel);
        resultSelectionSplitPane.add(processTabbedPane);
        JPanel xmlPanel = new JPanel();
        layout = new GridBagLayout();
        c = new GridBagConstraints();
        xmlPanel.setLayout(layout);
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        final XMLEditor xmlArea = new XMLEditor();
        xmlArea.setEditable(false);
        c.weighty = 1.0;
        layout.setConstraints(xmlArea, c);
        xmlPanel.add(xmlArea);
        ExtendedJTabbedPane xmlTabbedPane = new ExtendedJTabbedPane();
        xmlTabbedPane.add("XML Setup", xmlPanel);
        resultSelectionSplitPane.add(xmlTabbedPane);
        JSplitPane mainSplitPane = new JSplitPane(1);
        mainSplitPane.setBorder(null);
        mainSplitPane.add(resultSelectionSplitPane);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setBorder(null);
        layout = new GridBagLayout();
        c = new GridBagConstraints();
        resultsPanel.setLayout(layout);
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        final JTextArea resultsArea = new JTextArea();
        resultsArea.setBorder(null);
        resultsArea.setEditable(false);
        resultsArea.setLineWrap(true);
        resultsArea.setWrapStyleWord(true);
        ExtendedJScrollPane resultsPane = new ExtendedJScrollPane(resultsArea);
        c.weighty = 1.0;
        layout.setConstraints(resultsPane, c);
        resultsPanel.add(resultsPane);
        ExtendedJTabbedPane resultsTabbedPane = new ExtendedJTabbedPane();
        resultsTabbedPane.add("Results", resultsPanel);
        mainSplitPane.add(resultsTabbedPane);
        resultSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] indices = resultSelectionList.getSelectedIndices();
                    if (indices.length > 0) {
                        if (indices.length == 1) {
                            ResultContainer selectedContainer = (ResultContainer)resultSelectionList.getSelectedValue();
                            xmlArea.setText(selectedContainer.getProcess());
                            resultsArea.setText(selectedContainer.getResults());
                            ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(false);
                        } else {
                            xmlArea.setText("");
                            resultsArea.setText("");
                            ResultHistoryDialog.this.selectedTestGroups.clear();
                            for (int i = 0; i < indices.length; ++i) {
                                ResultContainer selectedContainer = (ResultContainer)RapidMinerGUI.getResultHistory().getElementAt(indices[i]);
                                TestGroup group = selectedContainer.getTestGroup();
                                if (group == null) continue;
                                ResultHistoryDialog.this.selectedTestGroups.add(group);
                            }
                            if (indices.length == ResultHistoryDialog.this.selectedTestGroups.size()) {
                                ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(true);
                            } else {
                                ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(false);
                            }
                        }
                    } else {
                        xmlArea.setText("");
                        resultsArea.setText("");
                        ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(false);
                    }
                }
            }
        });
        mainSplitPane.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)mainSplitPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultHistoryDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(640, 480);
        resultSelectionSplitPane.setDividerLocation(150);
        mainSplitPane.setDividerLocation(200);
        this.setLocationRelativeTo(owner);
    }

    private class AnovaAction
    extends AbstractAction {
        private static final long serialVersionUID = 6768585475843634549L;

        public AnovaAction() {
            super("Anova");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnovaCalculator calculator = new AnovaCalculator();
            calculator.setAlpha(0.05);
            for (TestGroup group : ResultHistoryDialog.this.selectedTestGroups) {
                calculator.addGroup(group);
            }
            try {
                SignificanceTestResult result = calculator.performSignificanceTest();
                JOptionPane.showMessageDialog(ResultHistoryDialog.this, ResultDisplayTools.createVisualizationComponent(result, null, "ANOVA Calculation"), "ANOVA result", -1);
            }
            catch (SignificanceCalculationException ex) {
                SwingTools.showSimpleErrorMessage("cannot_calc_statistical_significance", (Throwable)ex, new Object[0]);
            }
        }
    }
}

