/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.OperatorDocViewer;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.FixedWidthLabel;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.Ports;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class OperatorInfoScreen
extends ButtonDialog {
    private static final long serialVersionUID = -6566133238783779634L;
    private final transient Operator operator;

    public OperatorInfoScreen(Operator operator) {
        super("operator_info", true, new Object[0]);
        JLabel label;
        this.operator = operator;
        this.setTitle(this.getTitle());
        JTabbedPane tabs = new JTabbedPane();
        OperatorDocViewer documentationViewer = new OperatorDocViewer();
        documentationViewer.setDisplayedOperator(operator);
        final JPanel overviewPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        if (operator.getOperatorDescription().isDeprecated()) {
            JPanel deprecatedPanel = new JPanel(new BorderLayout());
            label = new JLabel(SwingTools.createIcon("24/sign_warning.png"));
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
            label.setText("<html><b>Depreceated!</b></html>");
            label.setPreferredSize(new Dimension(180, 50));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 40));
            deprecatedPanel.add((Component)label, "West");
            deprecatedPanel.add((Component)OperatorInfoScreen.createDeprecationInfoPanel(operator), "Center");
            deprecatedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            overviewPanel.add((Component)deprecatedPanel, c);
        }
        if (operator instanceof Learner) {
            JPanel learnerPanel = new JPanel(new BorderLayout());
            label = new JLabel(SwingTools.createIcon("24/briefcase2.png"));
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
            label.setText("Capabilities");
            label.setPreferredSize(new Dimension(180, 50));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 40));
            learnerPanel.add((Component)label, "West");
            learnerPanel.add((Component)OperatorInfoScreen.createCapabilitiesPanel(operator), "Center");
            learnerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            overviewPanel.add((Component)learnerPanel, c);
        }
        if (operator.getInputPorts().getNumberOfPorts() > 0 || operator.getOutputPorts().getNumberOfPorts() > 0) {
            JPanel portPanel = new JPanel(new BorderLayout());
            label = new JLabel(SwingTools.createIcon("24/plug.png"));
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
            label.setText("Ports");
            label.setPreferredSize(new Dimension(180, 50));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 40));
            portPanel.add((Component)label, "West");
            portPanel.add((Component)OperatorInfoScreen.createPortsDescriptionPanel("input_ports", "output_ports", operator.getInputPorts(), operator.getOutputPorts()), "Center");
            portPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            overviewPanel.add((Component)portPanel, c);
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            for (ExecutionUnit subprocess : chain.getSubprocesses()) {
                JPanel subprocessPanel = new JPanel(new BorderLayout());
                JLabel label2 = new JLabel(SwingTools.createIcon("24/elements_selection.png"));
                label2.setHorizontalTextPosition(0);
                label2.setVerticalTextPosition(3);
                label2.setText(subprocess.getName());
                label2.setPreferredSize(new Dimension(180, 50));
                label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 40));
                subprocessPanel.add((Component)label2, "West");
                subprocessPanel.add((Component)OperatorInfoScreen.createPortsDescriptionPanel("inner_sources", "inner_sinks", subprocess.getInnerSources(), subprocess.getInnerSinks()), "Center");
                subprocessPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
                overviewPanel.add((Component)subprocessPanel, c);
            }
        }
        c.fill = 1;
        c.weighty = 1.0;
        overviewPanel.add((Component)new JPanel(new BorderLayout()), c);
        final JScrollPane overviewPane = new JScrollPane(overviewPanel);
        overviewPane.setHorizontalScrollBarPolicy(31);
        overviewPane.getViewport().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                overviewPanel.setPreferredSize(new Dimension((int)overviewPane.getViewport().getExtentSize().getWidth(), (int)overviewPanel.getPreferredSize().getHeight()));
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        tabs.add("Overview", overviewPane);
        tabs.add("Description", documentationViewer);
        this.layoutDefault((JComponent)tabs, 1, this.makeCloseButton());
    }

    @Override
    protected Icon getInfoIcon() {
        return this.operator.getOperatorDescription().getLargeIcon();
    }

    @Override
    protected String getInfoText() {
        return "<html><b>" + this.operator.getOperatorDescription().getName() + "</b>" + (this.operator.getOperatorDescription().getGroup().equals("") ? "" : "<br/>Group: " + this.operator.getOperatorDescription().getGroupName()) + "</html>";
    }

    @Override
    public String getTitle() {
        if (this.operator != null) {
            return super.getTitle() + ": " + this.operator.getOperatorDescription().getName();
        }
        return super.getTitle();
    }

    public static JPanel createPortsDescriptionPanel(String inKey, String outKey, Ports<? extends Port> inputPorts, Ports<? extends Port> outputPorts) {
        int numberOfInputPorts = inputPorts.getNumberOfPorts();
        int numberOfOutputPorts = outputPorts.getNumberOfPorts();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(3, 0, 3, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        final JPanel panel = new JPanel(layout);
        JPanel rowPanel = new JPanel(new GridLayout(1, 2));
        ResourceLabel label = new ResourceLabel(inKey, new Object[0]);
        label.setText("<html><i>" + label.getText() + "</i></html>");
        Icon inIcon = label.getIcon();
        label.setIcon(null);
        rowPanel.add(label);
        label = new ResourceLabel(outKey, new Object[0]);
        label.setText("<html><i>" + label.getText() + "</i></html>");
        Icon outIcon = label.getIcon();
        label.setIcon(null);
        rowPanel.add(label);
        panel.add((Component)rowPanel, c);
        final LinkedList<FixedWidthLabel> labels = new LinkedList<FixedWidthLabel>();
        for (int i = 0; i < Math.max(numberOfInputPorts, numberOfOutputPorts); ++i) {
            FixedWidthLabel label2;
            Port port;
            JPanel rowPanel2 = new JPanel(new GridLayout(1, 2));
            if (i < numberOfInputPorts) {
                port = inputPorts.getPortByIndex(i);
                label2 = new FixedWidthLabel(rowPanel2.getWidth() / 2, port.getName());
                label2.setIcon(inIcon);
                label2.setText(port.getName() + (port.getDescription().equals("") ? "" : " (" + port.getDescription() + ")"));
                labels.add(label2);
                rowPanel2.add(label2);
            } else {
                rowPanel2.add(new JLabel());
            }
            if (i < numberOfOutputPorts) {
                port = outputPorts.getPortByIndex(i);
                label2 = new FixedWidthLabel(rowPanel2.getWidth() / 2, port.getName());
                label2.setIcon(outIcon);
                label2.setText(port.getName() + (port.getDescription().equals("") ? "" : " (" + port.getDescription() + ")"));
                labels.add(label2);
                rowPanel2.add(label2);
            } else {
                rowPanel2.add(new JLabel());
            }
            panel.add((Component)rowPanel2, c);
        }
        panel.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                for (FixedWidthLabel label : labels) {
                    label.setWidth((int)((double)panel.getWidth() / 2.2));
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        return panel;
    }

    public static JPanel createDeprecationInfoPanel(Operator operator) {
        final JPanel panel = new JPanel(new BorderLayout());
        final FixedWidthLabel info = new FixedWidthLabel(200, operator.getOperatorDescription().getDeprecationInfo());
        panel.add((Component)info, "Center");
        panel.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                info.setWidth(panel.getWidth());
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        return panel;
    }

    public static JPanel createCapabilitiesPanel(Operator operator) {
        CapabilityProvider capabilityProvider = (CapabilityProvider)((Object)operator);
        int length = OperatorCapability.values().length;
        GridLayout layout = new GridLayout(length / 2, 2);
        layout.setHgap(6);
        layout.setVgap(6);
        JPanel capabilitiesPanel = new JPanel(layout);
        for (OperatorCapability capability : OperatorCapability.values()) {
            JLabel capabilityLabel = new JLabel(capability.getDescription());
            try {
                if (capabilityProvider.supportsCapability(capability)) {
                    capabilityLabel.setIcon(SwingTools.createIcon("16/ok.png"));
                } else {
                    capabilityLabel.setIcon(SwingTools.createIcon("16/error.png"));
                }
            }
            catch (Exception e) {
                break;
            }
            capabilitiesPanel.add(capabilityLabel);
        }
        return capabilitiesPanel;
    }
}

