/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.dialog.OperatorInfoScreen;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceTabbedPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class OperatorInfoPanel
extends JPanel {
    private static final long serialVersionUID = 3610550973456646750L;
    public static final Icon WARNING_ICON = SwingTools.createIcon("16/sign_warning.png");

    public OperatorInfoPanel(OperatorDescription description) {
        if (description == null) {
            this.add(new JLabel("No operator selected!"));
        } else {
            JPanel panel;
            Operator operator = null;
            try {
                operator = description.createOperatorInstance();
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Cannot create operator: " + e.getMessage(), e);
            }
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel("<html><b>" + description.getName() + "</b><br/>Group: " + description.getGroupName() + "</html>");
            label.setIcon(operator.getOperatorDescription().getIcon());
            label.setBorder(BorderFactory.createEmptyBorder(8, 16, 24, 12));
            label.setIconTextGap(12);
            this.add((Component)label, "North");
            ResourceTabbedPane tabs = new ResourceTabbedPane("operator_info_panel");
            if (description.isDeprecated()) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)OperatorInfoScreen.createDeprecationInfoPanel(operator), "North");
                panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                tabs.addTabI18N("deprecation", panel2, new String[0]);
            }
            ExtendedHTMLJEditorPane descriptionLabel = new ExtendedHTMLJEditorPane("text/html", "");
            StyleSheet css = ((HTMLEditorKit)descriptionLabel.getEditorKit()).getStyleSheet();
            css.addRule("p { margin : 0pt; font-family : sans-serif; font-size : 9px; font-style : normal; }");
            descriptionLabel.setToolTipText("The description of this operator");
            descriptionLabel.setEditable(false);
            descriptionLabel.setBackground(this.getBackground());
            String descriptionString = operator.getOperatorDescription().getLongDescriptionHTML();
            descriptionLabel.setText("<p>" + descriptionString + "</p>");
            descriptionLabel.setCaretPosition(0);
            tabs.addTabI18N("description", new ExtendedJScrollPane(descriptionLabel), new String[0]);
            if (operator instanceof CapabilityProvider) {
                panel = new JPanel(new BorderLayout());
                panel.add((Component)OperatorInfoScreen.createCapabilitiesPanel(operator), "North");
                panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                tabs.addTabI18N("capabilities", new ExtendedJScrollPane(panel), new String[0]);
            }
            if (operator.getInputPorts().getNumberOfPorts() > 0 || operator.getOutputPorts().getNumberOfPorts() > 0) {
                panel = new JPanel(new BorderLayout());
                panel.add((Component)OperatorInfoScreen.createPortsDescriptionPanel("input_ports", "output_ports", operator.getInputPorts(), operator.getOutputPorts()), "North");
                panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                tabs.addTabI18N("ports", new ExtendedJScrollPane(panel), new String[0]);
            }
            if (operator instanceof OperatorChain) {
                OperatorChain chain = (OperatorChain)operator;
                for (ExecutionUnit subprocess : chain.getSubprocesses()) {
                    JPanel panel3 = new JPanel(new BorderLayout());
                    panel3.add((Component)OperatorInfoScreen.createPortsDescriptionPanel("inner_sources", "inner_sinks", subprocess.getInnerSources(), subprocess.getInnerSinks()), "North");
                    panel3.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                    tabs.addTabI18N("subprocess", new ExtendedJScrollPane(panel3), subprocess.getName());
                }
            }
            this.add((Component)tabs, "Center");
        }
    }
}

