/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.dialog.OperatorInfoPanel;
import com.rapidminer.gui.tools.CamelCaseFilter;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.OperatorList;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.CapabilityProvider;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.OperatorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class NewOperatorDialog
extends ButtonDialog {
    private static final long serialVersionUID = 390653805759799295L;
    private transient OperatorDescription description = null;
    private final JPanel mainPanel = new JPanel();
    private OperatorInfoPanel operatorInfo = null;
    private final JList operatorList = new OperatorList();
    private String searchText = "";
    private boolean isFullText;
    private Class<? extends IOObject> inputClass = null;
    private Class<? extends IOObject> outputClass = null;
    private String group = null;
    private transient OperatorCapability firstCapability = null;
    private transient OperatorCapability secondCapability = null;
    private final Actions actions;
    private final JCheckBox fullTextCheckBox;
    private final UpdateQueue updateQueue = new UpdateQueue("operator-filter");

    public NewOperatorDialog(Actions actions) {
        this(actions, null, null, null, null, false);
    }

    public NewOperatorDialog(Actions actions, Class<? extends IOObject> inputClass, Class<? extends IOObject> outputClass, OperatorCapability firstCapability, OperatorCapability secondCapability, boolean modal) {
        super("new_operator", modal, new Object[0]);
        this.actions = actions;
        this.inputClass = inputClass;
        this.outputClass = outputClass;
        this.firstCapability = firstCapability;
        this.secondCapability = secondCapability;
        this.mainPanel.setLayout(new BorderLayout(6, 0));
        int rows = 2;
        if (inputClass == null) {
            ++rows;
        }
        if (outputClass == null) {
            ++rows;
        }
        if (firstCapability == null) {
            ++rows;
        }
        if (secondCapability == null) {
            ++rows;
        }
        JPanel searchPanel = new JPanel(new GridLayout(rows + 1, 2));
        searchPanel.setBorder(NewOperatorDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.new_op_dialog.search_constraints", new Object[0])));
        this.mainPanel.add((Component)searchPanel, "North");
        final String[] ioObjects = this.convertSet2Strings(OperatorService.getIOObjectsNames());
        String[] inputObjects = new String[ioObjects.length + 1];
        inputObjects[0] = "Any";
        System.arraycopy(ioObjects, 0, inputObjects, 1, ioObjects.length);
        JPanel searchFieldPanel = new JPanel(new BorderLayout());
        final JTextField searchField = new JTextField(this.searchText);
        searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NewOperatorDialog.this.searchText = searchField.getText().trim();
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchFieldPanel.add((Component)searchField, "Center");
        JButton clearSearchFieldButton = new JButton(new ResourceAction(true, "new_op_dialog.clear_search_field", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOperatorDialog.this.searchText = "";
                searchField.setText(NewOperatorDialog.this.searchText);
                searchField.requestFocusInWindow();
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchFieldPanel.add((Component)clearSearchFieldButton, "East");
        ResourceLabel textLabel = new ResourceLabel("new_op_dialog.search_text", new Object[0]);
        textLabel.setLabelFor(searchField);
        searchPanel.add(textLabel);
        searchPanel.add(searchFieldPanel);
        searchPanel.add(new JPanel());
        this.fullTextCheckBox = new JCheckBox(new ResourceAction("new_op_dialog.full_text_search", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOperatorDialog.this.isFullText = NewOperatorDialog.this.fullTextCheckBox.isSelected();
            }
        });
        this.isFullText = this.fullTextCheckBox.isSelected();
        searchPanel.add(this.fullTextCheckBox);
        LinkedList<String> allGroups = new LinkedList<String>();
        allGroups.add("Any");
        GroupTree groupTree = OperatorService.getGroups();
        this.addGroups(groupTree, null, allGroups);
        Collections.sort(allGroups);
        final String[] groupArray = new String[allGroups.size()];
        allGroups.toArray(groupArray);
        final JComboBox<String> groupComboBox = new JComboBox<String>(groupArray);
        groupComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = groupComboBox.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.group = null;
                } else {
                    NewOperatorDialog.this.group = groupArray[selectedIndex];
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        ResourceLabel groupLabel = new ResourceLabel("new_op_dialog.operator_group", new Object[0]);
        searchPanel.add(groupLabel);
        groupLabel.setLabelFor(groupComboBox);
        searchPanel.add(groupComboBox);
        if (inputClass == null) {
            final JComboBox<String> inputType = new JComboBox<String>(inputObjects);
            inputType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = inputType.getSelectedIndex();
                    if (selectedIndex <= 0) {
                        NewOperatorDialog.this.inputClass = null;
                    } else {
                        NewOperatorDialog.this.inputClass = OperatorService.getIOObjectClass(ioObjects[selectedIndex - 1]);
                    }
                    NewOperatorDialog.this.updateOperatorList();
                }
            });
            ResourceLabel inputLabel = new ResourceLabel("new_op_dialog.required_input", new Object[0]);
            searchPanel.add(inputLabel);
            inputLabel.setLabelFor(inputType);
            searchPanel.add(inputType);
        }
        if (outputClass == null) {
            final JComboBox<String> outputType = new JComboBox<String>(inputObjects);
            outputType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = outputType.getSelectedIndex();
                    if (selectedIndex <= 0) {
                        NewOperatorDialog.this.outputClass = null;
                    } else {
                        NewOperatorDialog.this.outputClass = OperatorService.getIOObjectClass(ioObjects[selectedIndex - 1]);
                    }
                    NewOperatorDialog.this.updateOperatorList();
                }
            });
            ResourceLabel outputLabel = new ResourceLabel("new_op_dialog.delivered_output", new Object[0]);
            searchPanel.add(outputLabel);
            outputLabel.setLabelFor(outputType);
            searchPanel.add(outputType);
        }
        OperatorCapability[] caps = OperatorCapability.values();
        String[] capabilities = new String[caps.length + 1];
        capabilities[0] = "Any";
        int k = 1;
        for (OperatorCapability capability : caps) {
            capabilities[k++] = capability.getDescription();
        }
        if (firstCapability == null) {
            final JComboBox<String> firstCapabilityType = new JComboBox<String>(capabilities);
            firstCapabilityType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = firstCapabilityType.getSelectedIndex();
                    if (selectedIndex <= 0) {
                        NewOperatorDialog.this.firstCapability = null;
                    } else {
                        NewOperatorDialog.this.firstCapability = OperatorCapability.values()[selectedIndex - 1];
                    }
                    NewOperatorDialog.this.updateOperatorList();
                }
            });
            ResourceLabel firstCapabilityLabel = new ResourceLabel("new_op_dialog.first_capability", new Object[0]);
            searchPanel.add(firstCapabilityLabel);
            firstCapabilityLabel.setLabelFor(firstCapabilityType);
            searchPanel.add(firstCapabilityType);
        }
        if (secondCapability == null) {
            final JComboBox<String> secondCapabilityType = new JComboBox<String>(capabilities);
            secondCapabilityType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedIndex = secondCapabilityType.getSelectedIndex();
                    if (selectedIndex <= 0) {
                        NewOperatorDialog.this.secondCapability = null;
                    } else {
                        NewOperatorDialog.this.secondCapability = OperatorCapability.values()[selectedIndex - 1];
                    }
                    NewOperatorDialog.this.updateOperatorList();
                }
            });
            ResourceLabel secondCapabilityLabel = new ResourceLabel("new_op_dialog.second_capability", new Object[0]);
            searchPanel.add(secondCapabilityLabel);
            secondCapabilityLabel.setLabelFor(secondCapabilityType);
            searchPanel.add(secondCapabilityType);
        }
        this.operatorList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OperatorDescription selection = (OperatorDescription)NewOperatorDialog.this.operatorList.getSelectedValue();
                    NewOperatorDialog.this.setSelectedOperator(selection);
                }
            }
        });
        this.operatorList.setSelectionMode(0);
        ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(this.operatorList);
        listScrollPane.setPreferredSize(new Dimension(250, 50));
        GridBagLayout layout = new GridBagLayout();
        JPanel listPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        listPanel.setBorder(NewOperatorDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.new_op_dialog.matching_operators", new Object[0])));
        layout.setConstraints(listScrollPane, c);
        listPanel.add(listScrollPane);
        this.mainPanel.add((Component)listPanel, "West");
        this.updateOperatorListNow();
        this.updateQueue.start();
        if (!modal) {
            JButton addButton = new JButton(new ResourceAction("add_operator_now", new Object[0]){
                private static final long serialVersionUID = -6725386765826715152L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewOperatorDialog.this.add();
                }
            });
            this.layoutDefault((JComponent)this.mainPanel, 3, addButton, this.makeCloseButton());
            this.getRootPane().setDefaultButton(addButton);
        } else {
            JButton okButton = this.makeOkButton();
            this.layoutDefault((JComponent)this.mainPanel, 3, okButton, this.makeCancelButton());
            this.getRootPane().setDefaultButton(okButton);
        }
    }

    private void updateOperatorList() {
        this.updateQueue.execute(new Runnable(){

            @Override
            public void run() {
                NewOperatorDialog.this.updateOperatorListNow();
            }
        });
    }

    private void updateOperatorListNow() {
        CamelCaseFilter filter = null;
        if (this.searchText != null) {
            filter = new CamelCaseFilter(this.searchText.trim());
        }
        final Vector<OperatorDescription> operators = new Vector<OperatorDescription>();
        for (String name : OperatorService.getOperatorNames()) {
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            if (this.searchText != null && this.searchText.length() > 0 && (!this.isFullText ? !filter.matches(description.getName()) : !description.getLongDescriptionHTML().toLowerCase().contains(this.searchText.toLowerCase()))) continue;
            if (this.group != null && this.group.length() > 0 && description.getGroup().indexOf(this.group) < 0) continue;
            try {
                Operator operator = description.createOperatorInstance();
                if (this.inputClass != null && !operator.acceptsInput(this.inputClass) || this.outputClass != null && !operator.producesOutput(this.outputClass) || this.firstCapability != null && (!(operator instanceof CapabilityProvider) || !((CapabilityProvider)((Object)operator)).supportsCapability(this.firstCapability)) || this.secondCapability != null && (!(operator instanceof CapabilityProvider) || !((CapabilityProvider)((Object)operator)).supportsCapability(this.secondCapability))) {
                    continue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            operators.add(description);
        }
        Collections.sort(operators);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewOperatorDialog.this.operatorList.removeAll();
                NewOperatorDialog.this.operatorList.setListData(operators);
                if (operators.size() > 0) {
                    NewOperatorDialog.this.operatorList.setSelectedIndex(0);
                }
            }
        });
    }

    private void addGroups(GroupTree tree, String parentName, Collection<String> names) {
        for (GroupTree subGroup : tree.getSubGroups()) {
            String name = parentName == null ? subGroup.getName() : parentName + "." + subGroup.getName();
            names.add(name);
            this.addGroups(subGroup, name, names);
        }
    }

    private void setSelectedOperator(OperatorDescription descriptionName) {
        if (this.operatorInfo != null) {
            this.mainPanel.remove(this.operatorInfo);
        }
        if (descriptionName != null) {
            this.description = descriptionName;
            this.operatorInfo = new OperatorInfoPanel(this.description);
        } else {
            this.operatorInfo = new OperatorInfoPanel(null);
        }
        this.operatorInfo.setBorder(NewOperatorDialog.createTitledBorder(I18N.getMessage(I18N.getGUIBundle(), "gui.dialog.new_op_dialog.operator_info", new Object[0])));
        this.mainPanel.add((Component)this.operatorInfo, "Center");
        this.operatorInfo.revalidate();
    }

    private String[] convertSet2Strings(Collection<String> ioObjects) {
        String[] objectArray = new String[ioObjects.size()];
        Iterator<String> i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            objectArray[index++] = i.next();
        }
        return objectArray;
    }

    private Operator getOperator() throws OperatorCreationException {
        if (this.description != null) {
            Operator operator = OperatorService.createOperator(this.description);
            return operator;
        }
        return null;
    }

    private void add() {
        try {
            Operator operator = this.getOperator();
            if (operator != null) {
                this.actions.insert(Collections.singletonList(operator));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SwingTools.showSimpleErrorMessage("cannot_create_operator", (Throwable)ex, new Object[0]);
        }
    }

    public static Operator selectMatchingOperator(Actions actions, Class<? extends IOObject> inputClass, Class<? extends IOObject> outputClass, OperatorCapability firstCapability, OperatorCapability secondCapability) throws OperatorCreationException {
        NewOperatorDialog dialog = new NewOperatorDialog(actions, inputClass, outputClass, firstCapability, secondCapability, true);
        dialog.setVisible(true);
        if (dialog.wasConfirmed()) {
            return dialog.getOperator();
        }
        return null;
    }
}

