/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class IndividualSelectorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4666469076881936719L;
    private Population population;
    private List<String> columnNames = new ArrayList<String>();
    private int columnOffset = 3;
    private String[] attributeNames;

    public IndividualSelectorTableModel(String[] attributeNames, Population population) {
        this.attributeNames = attributeNames;
        this.population = population;
        if (population.getNumberOfIndividuals() > 0) {
            this.columnNames.add("Index");
            this.columnNames.add("Features");
            this.columnNames.add("Names");
            Individual individual = population.get(0);
            PerformanceVector performanceVector = individual.getPerformance();
            for (int i = 0; i < performanceVector.getSize(); ++i) {
                PerformanceCriterion criterion = performanceVector.getCriterion(i);
                this.columnNames.add(criterion.getName());
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
        }
        return Double.class;
    }

    @Override
    public String getColumnName(int c) {
        return this.columnNames.get(c);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.population.getNumberOfIndividuals();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return rowIndex + 1;
            }
            case 1: {
                Individual individual = this.population.get(rowIndex);
                return individual.getNumberOfUsedAttributes();
            }
            case 2: {
                Individual individual = this.population.get(rowIndex);
                double[] weights = individual.getWeights();
                StringBuffer names = new StringBuffer();
                boolean first = true;
                for (int w = 0; w < weights.length; ++w) {
                    if (!(weights[w] > 0.0)) continue;
                    if (!first) {
                        names.append(", ");
                    }
                    names.append(this.attributeNames[w]);
                    first = false;
                }
                return names.toString();
            }
        }
        int perfIndex = columnIndex - this.columnOffset;
        Individual individual = this.population.get(rowIndex);
        PerformanceCriterion criterion = individual.getPerformance().getCriterion(perfIndex);
        return criterion.getAverage();
    }
}

