/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.IndividualSelectorTableModel;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.MetaDataViewer;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class IndividualSelector
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = -6512675217777454316L;
    private transient Population population;
    private ExtendedJTable individualTable;
    private MetaDataViewer metaDataViewer = null;
    private boolean selected = false;
    private ExampleSet exampleSet = null;

    public IndividualSelector(ExampleSet exampleSet, Population population) {
        this(exampleSet, population, true);
    }

    public IndividualSelector(ExampleSet exampleSet, Population population, boolean modal) {
        this(RapidMinerGUI.getMainFrame(), exampleSet, population, -1, -1, modal);
    }

    public IndividualSelector(Frame owner, ExampleSet exampleSet, Population population, int width, int height, boolean modal) {
        super(owner, "Result Individual Selection", modal);
        this.setDefaultCloseOperation(2);
        this.population = population;
        this.exampleSet = exampleSet;
        this.individualTable = new ExtendedJTable((TableModel)new IndividualSelectorTableModel(Tools.getRegularAttributeNames(exampleSet), population), true);
        this.individualTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.individualTable.setSelectionMode(0);
        this.individualTable.setCellSelectionEnabled(false);
        this.individualTable.setColumnSelectionAllowed(false);
        this.individualTable.setRowSelectionAllowed(true);
        this.individualTable.getSelectionModel().addListSelectionListener(this);
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.individualTable);
        tablePane.setBorder(BorderFactory.createTitledBorder("All Individuals"));
        ExampleSet result = FeatureOperator.createCleanClone(exampleSet, population.get(0).getWeights());
        this.metaDataViewer = new MetaDataViewer(result, false);
        ExtendedJScrollPane metaDataPane = new ExtendedJScrollPane(this.metaDataViewer);
        metaDataPane.setBorder(BorderFactory.createTitledBorder("Selected Individual"));
        JSplitPane mainSplitPane = new JSplitPane(0);
        mainSplitPane.add(tablePane);
        mainSplitPane.add(metaDataPane);
        this.getContentPane().add((Component)mainSplitPane, "Center");
        JPanel buttonPanel = new JPanel();
        GridBagLayout buttonLayout = new GridBagLayout();
        buttonPanel.setLayout(buttonLayout);
        GridBagConstraints buttonC = new GridBagConstraints();
        buttonC.fill = 1;
        buttonC.weightx = 0.0;
        buttonC.insets = new Insets(4, 4, 4, 4);
        JButton saveDataButton = new JButton("Save Data...");
        saveDataButton.setToolTipText("Save the upper data table into a file in CSV format.");
        saveDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualSelector.this.saveData();
            }
        });
        buttonLayout.setConstraints(saveDataButton, buttonC);
        buttonPanel.add(saveDataButton);
        JPanel fillPanel = new JPanel();
        buttonC.weightx = 1.0;
        buttonLayout.setConstraints(fillPanel, buttonC);
        buttonPanel.add(fillPanel);
        buttonC.weightx = 0.0;
        JButton selectButton = new JButton("Select");
        selectButton.setToolTipText("Use the currently selected individual as result instead of the best one according to the main criterion.");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualSelector.this.select();
            }
        });
        buttonLayout.setConstraints(selectButton, buttonC);
        buttonPanel.add(selectButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setToolTipText("Do not use the currently selected individual but the best one according to the main criterion.");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndividualSelector.this.cancel();
            }
        });
        buttonLayout.setConstraints(cancelButton, buttonC);
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.individualTable.addRowSelectionInterval(0, 0);
        if (width < 0 || height < 0) {
            this.setSize(800, 600);
            mainSplitPane.setDividerLocation(400);
        } else {
            this.setSize(width, height);
            mainSplitPane.setDividerLocation(height / 2);
        }
        this.setLocationRelativeTo(owner);
    }

    private void saveData() {
        File file = SwingTools.chooseFile(this, null, false, "csv", "comma separated values");
        if (file != null) {
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(file));
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("cannot_write_data_into_file", (Throwable)e, new Object[0]);
            }
            if (out != null) {
                TableModel model = this.individualTable.getModel();
                for (int c = 0; c < model.getColumnCount(); ++c) {
                    if (c != 0) {
                        out.print(";");
                    }
                    out.print(model.getColumnName(c));
                }
                out.println();
                for (int r = 0; r < model.getRowCount(); ++r) {
                    for (int c = 0; c < model.getColumnCount(); ++c) {
                        if (c != 0) {
                            out.print(";");
                        }
                        out.print(model.getValueAt(r, c));
                    }
                    out.println();
                }
                out.close();
            }
        }
    }

    private void select() {
        this.selected = true;
        this.dispose();
    }

    private void cancel() {
        this.dispose();
    }

    public Individual getSelectedIndividual() {
        if (!this.selected) {
            return null;
        }
        int index = this.individualTable.getModelIndex(this.individualTable.getSelectedRow());
        if (index >= 0 && index < this.population.getNumberOfIndividuals()) {
            return this.population.get(index);
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int index = this.individualTable.getModelIndex(this.individualTable.getSelectedRow());
            if (index >= 0 && index < this.population.getNumberOfIndividuals()) {
                Individual selected = this.population.get(index);
                ExampleSet result = FeatureOperator.createCleanClone(this.exampleSet, selected.getWeights());
                this.metaDataViewer.setExampleSet(result);
            } else {
                this.metaDataViewer.setExampleSet(null);
            }
        }
    }
}

