/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.BugReport;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class BugAssistant
extends ButtonDialog {
    private static final long serialVersionUID = 8379605320787188372L;
    private static final String TEXT_INSTRUCTIONS = "Enter a brief description of what happened into this text field. Please also describe the purpose of your process definition because this cannot always be concluded trivially from the process setup.";
    private final JTextArea message = new JTextArea("Enter a brief description of what happened into this text field. Please also describe the purpose of your process definition because this cannot always be concluded trivially from the process setup.", 5, 20);
    private final JList attachments = new JList(new DefaultListModel());

    public BugAssistant(final Throwable exception) {
        super("send_bugreport", true, new Object[0]);
        LinkedList<AbstractButton> buttons = new LinkedList<AbstractButton>();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel addressPanel = new JPanel(new BorderLayout(6, 6));
        JLabel nameLabel = new JLabel(I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".e_mail.label", new Object[0]));
        addressPanel.add((Component)nameLabel, "West");
        final JTextField name = new JTextField(15);
        name.setToolTipText(I18N.getMessage(I18N.getGUIBundle(), this.getKey() + ".e_mail.tip", new Object[0]));
        addressPanel.add((Component)name, "Center");
        panel.add((Component)addressPanel, "North");
        JPanel mailPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        ExtendedJScrollPane messagePane = new ExtendedJScrollPane(this.message);
        messagePane.setBorder(BugAssistant.createBorder());
        messagePane.setPreferredSize(new Dimension(400, 300));
        c.gridwidth = -1;
        c.fill = 1;
        c.insets = new Insets(6, 0, 0, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.9;
        c.weighty = 1.0;
        mailPanel.add((Component)messagePane, c);
        c.insets = new Insets(6, 0, 0, 0);
        c.gridx = 1;
        c.weightx = 0.1;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.attachments.setSelectionMode(0);
        JScrollPane attachmentPane = new JScrollPane(this.attachments);
        attachmentPane.setBorder(BugAssistant.createBorder());
        attachmentPane.setPreferredSize(new Dimension(150, 300));
        mailPanel.add((Component)attachmentPane, c);
        panel.add((Component)mailPanel, "Center");
        buttons.add(new JButton(new ResourceAction("send_bugreport.add_file", new Object[0]){
            private static final long serialVersionUID = 5152169309271935854L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile(null, null, true, null, null);
                if (file != null) {
                    ((DefaultListModel)BugAssistant.this.attachments.getModel()).addElement(file);
                }
            }
        }));
        buttons.add(new JButton(new ResourceAction("send_bugreport.remove_file", new Object[0]){
            private static final long serialVersionUID = 5353693430346577972L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BugAssistant.this.attachments.getSelectedIndex() >= 0) {
                    ((DefaultListModel)BugAssistant.this.attachments.getModel()).remove(BugAssistant.this.attachments.getSelectedIndex());
                }
            }
        }));
        buttons.add(new JButton(new ResourceAction("send_bugreport.submit", new Object[0]){
            private static final long serialVersionUID = -4559762951458936715L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String email = name.getText().trim();
                if (email.length() == 0) {
                    SwingTools.showVerySimpleErrorMessage("enter_email", new Object[0]);
                    return;
                }
                File file = SwingTools.chooseFile(null, new File("bugreport.zip"), false, false, ".zip", "zip archives");
                if (file != null) {
                    try {
                        ListModel model = BugAssistant.this.attachments.getModel();
                        File[] attachments = new File[model.getSize()];
                        for (int i = 0; i < attachments.length; ++i) {
                            attachments[i] = (File)model.getElementAt(i);
                        }
                        BugReport.createBugReport(file, exception, "From: " + name.getText() + Tools.getLineSeparator() + "Date: " + new Date() + Tools.getLineSeparator() + Tools.getLineSeparator() + BugAssistant.this.message.getText(), RapidMinerGUI.getMainFrame().getProcess(), RapidMinerGUI.getMainFrame().getMessageViewer().getLogMessage(), attachments);
                        BugAssistant.this.dispose();
                    }
                    catch (Throwable t) {
                        SwingTools.showVerySimpleErrorMessage("bugreport_creation_failed", new Object[0]);
                    }
                }
            }
        }));
        buttons.add(this.makeCancelButton());
        this.message.setSelectionStart(0);
        this.message.setSelectionEnd(TEXT_INSTRUCTIONS.length() - 1);
        this.layoutDefault((JComponent)panel, 3, buttons);
    }
}

