/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.gui.dialog.AttributeWeightCellEditor;
import com.rapidminer.gui.properties.celleditors.value.PropertyValueCellEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class AttributeWeightsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6151252627227324898L;
    public static final int VIEW_ALL = 0;
    public static final int VIEW_FILE = 1;
    public static final int VIEW_PROCESS = 2;
    public static final int VIEW_UPDATED = 3;
    public static final int VIEW_SELECTED = 4;
    public static final String[] VIEW_MODES = new String[]{"Show all", "Show from file", "Show from process", "Show updated", "Show selected"};
    private transient AttributeWeights weights;
    private String[] attributeNames;
    private PropertyValueCellEditor[] editors;
    private Map<String, State> updateMap = new HashMap<String, State>();
    private int viewMode = 0;
    private boolean overwrite = false;
    private double minWeight = Double.NEGATIVE_INFINITY;
    private int selectionCount = 0;

    public AttributeWeightsTableModel(AttributeWeights weights) {
        this.weights = weights != null ? (AttributeWeights)weights.clone() : new AttributeWeights();
        for (String attributeName : this.weights.getAttributeNames()) {
            double oldWeight = this.weights.getWeight(attributeName);
            this.updateMap.put(attributeName, new State(1, oldWeight));
        }
        this.updateTable();
    }

    protected Object readResolve() {
        this.weights = new AttributeWeights();
        return this;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.attributeNames[row];
        }
        if (column == 1) {
            return this.weights.getWeight(this.attributeNames[row]);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        double weight = this.weights.getWeight(this.attributeNames[row]);
        try {
            weight = Double.parseDouble((String)value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.weights.setWeight(this.attributeNames[row], weight);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    @Override
    public int getRowCount() {
        return this.attributeNames.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Attribute";
            }
            case 1: {
                return "Weight";
            }
        }
        return "?";
    }

    public AttributeWeights getAttributeWeights() {
        return this.weights;
    }

    public PropertyValueCellEditor getWeightEditor(int row) {
        return this.editors[row];
    }

    public void setViewMode(int mode) {
        this.viewMode = mode;
    }

    public void setOverwriteMode(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMinWeight(double minWeight) {
        this.minWeight = minWeight;
    }

    public double getMinWeight() {
        return this.minWeight;
    }

    public void mergeWeights(AttributeWeights fileWeights) {
        for (String attributeName : fileWeights.getAttributeNames()) {
            double fileWeight = fileWeights.getWeight(attributeName);
            double processWeight = this.weights.getWeight(attributeName);
            if (fileWeight == 0.0) {
                this.weights.setWeight(attributeName, 0.0);
            } else if (this.overwrite) {
                this.weights.setWeight(attributeName, fileWeight);
            } else if (Double.isNaN(this.weights.getWeight(attributeName))) {
                this.weights.setWeight(attributeName, fileWeight);
            }
            State state = this.updateMap.get(attributeName);
            if (state != null) {
                if (state.getSource() == 1) {
                    state.setSource(3);
                }
                if (fileWeight == processWeight) continue;
                state.setUpdated(true);
                continue;
            }
            this.updateMap.put(attributeName, new State(2, this.weights.getWeight(attributeName)));
        }
    }

    public int getNumberOfSelected() {
        return this.selectionCount;
    }

    public int getTotalNumber() {
        return this.weights.size();
    }

    public void updateTable() {
        Iterator<String> i = this.weights.getAttributeNames().iterator();
        LinkedList<String> names = new LinkedList<String>();
        this.selectionCount = 0;
        block6: while (i.hasNext()) {
            String attributeName = i.next();
            double weight = this.weights.getWeight(attributeName);
            if (weight != 0.0) {
                ++this.selectionCount;
            }
            if (!(weight >= this.minWeight)) continue;
            State state = this.updateMap.get(attributeName);
            switch (this.viewMode) {
                case 1: {
                    if (state.getSource() != 2 && state.getSource() != 3) continue block6;
                    names.add(attributeName);
                    continue block6;
                }
                case 2: {
                    if (state.getSource() != 1 && state.getSource() != 3) continue block6;
                    names.add(attributeName);
                    continue block6;
                }
                case 3: {
                    if (!state.isUpdated()) continue block6;
                    names.add(attributeName);
                    continue block6;
                }
                case 4: {
                    if (this.weights.getWeight(attributeName) == 0.0) continue block6;
                    names.add(attributeName);
                    continue block6;
                }
            }
            names.add(attributeName);
        }
        this.attributeNames = new String[names.size()];
        names.toArray(this.attributeNames);
        this.editors = new PropertyValueCellEditor[this.attributeNames.length];
        for (int k = 0; k < this.editors.length; ++k) {
            this.editors[k] = new AttributeWeightCellEditor(this.updateMap.get(this.attributeNames[k]).getOldWeight());
        }
        super.fireTableChanged(new TableModelEvent(this));
    }

    private static class State {
        public static final int SOURCE_PROCESS = 1;
        public static final int SOURCE_FILE = 2;
        public static final int SOURCE_BOTH = 3;
        private int source = 1;
        private double oldWeight = 0.0;
        private boolean updated = false;

        public State(int source, double oldWeight) {
            this.source = source;
            this.oldWeight = oldWeight;
        }

        public int getSource() {
            return this.source;
        }

        public void setSource(int source) {
            this.source = source;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void setUpdated(boolean updated) {
            this.updated = updated;
        }

        public double getOldWeight() {
            return this.oldWeight;
        }
    }
}

