/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class AnovaCalculatorDialog
extends ButtonDialog {
    private static final long serialVersionUID = 3023267244921354296L;
    private transient AnovaCalculator calculator = new AnovaCalculator();
    private final JTextField alphaField = new JTextField(8);
    private final AnovaTableModel tableModel;

    public AnovaCalculatorDialog() {
        super("anova_calculator", true, new Object[0]);
        this.alphaField.setText("0.05");
        JPanel panel = new JPanel(new BorderLayout());
        this.calculator = new AnovaCalculator();
        this.tableModel = new AnovaTableModel();
        final ExtendedJTable dataTable = new ExtendedJTable((TableModel)this.tableModel, false);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(dataTable);
        scrollPane.setBorder(AnovaCalculatorDialog.createBorder());
        panel.add((Component)scrollPane, "Center");
        JPanel significancePanel = new JPanel(new FlowLayout());
        significancePanel.add(new JLabel("Significance Level: "));
        significancePanel.add(this.alphaField);
        JButton addRowButton = new JButton(new ResourceAction("anova_calculator.add_row", new Object[0]){
            private static final long serialVersionUID = 207462851508903445L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AnovaCalculatorDialog.this.tableModel.addRow(new Object[]{0.0, 0.0, 0});
            }
        });
        JButton removeRowButton = new JButton(new ResourceAction("anova_calculator.remove_row", new Object[0]){
            private static final long serialVersionUID = -5306772619829043512L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = dataTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    AnovaCalculatorDialog.this.tableModel.removeRow(rows[i]);
                }
            }
        });
        JButton calculateButton = new JButton(new ResourceAction("anova_calculator.calculate", new Object[0]){
            private static final long serialVersionUID = -8155818315917061669L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AnovaCalculatorDialog.this.calculateANOVA();
                }
                catch (SignificanceCalculationException e1) {
                    SwingTools.showSimpleErrorMessage("cannot_calc_anova", (Throwable)e1, new Object[0]);
                }
            }
        });
        JButton clearButton = new JButton(new ResourceAction("anova_calculator.clear", new Object[0]){
            private static final long serialVersionUID = -3732977250759096948L;

            @Override
            public void actionPerformed(ActionEvent e) {
                while (AnovaCalculatorDialog.this.tableModel.getRowCount() > 0) {
                    AnovaCalculatorDialog.this.tableModel.removeRow(0);
                }
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)significancePanel, "West");
        buttonPanel.add(this.makeButtonPanel(addRowButton, removeRowButton, clearButton, calculateButton, this.makeCloseButton()));
        this.layoutDefault((JComponent)panel, buttonPanel, 3);
    }

    private void calculateANOVA() throws SignificanceCalculationException {
        double alpha = -1.0;
        String alphaString = this.alphaField.getText();
        try {
            alpha = Double.parseDouble(alphaString);
        }
        catch (NumberFormatException e) {
            SwingTools.showVerySimpleErrorMessage("sign_lvl_between_0_1", new Object[0]);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            SwingTools.showVerySimpleErrorMessage("sign_lvl_between_0_1", new Object[0]);
        } else {
            this.calculator.clearGroups();
            this.calculator.setAlpha(alpha);
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                double mean = (Double)this.tableModel.getValueAt(i, 0);
                double variance = (Double)this.tableModel.getValueAt(i, 1);
                int number = (Integer)this.tableModel.getValueAt(i, 2);
                this.calculator.addGroup(number, mean, variance);
            }
            if (this.tableModel.getRowCount() < 2) {
                SwingTools.showVerySimpleErrorMessage("two_rows_to_calc_anova_test", new Object[0]);
                return;
            }
            SignificanceTestResult result = this.calculator.performSignificanceTest();
            SwingTools.showResultsDialog("anova", ResultDisplayTools.createVisualizationComponent(result, null, "ANOVA Result"), new Object[0]);
        }
    }

    private static class AnovaTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -2904775003271582149L;

        public AnovaTableModel() {
            super(new String[]{"Mean", "Variance", "Number"}, 0);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return Integer.class;
            }
            return Double.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

