/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.attributeeditor;

import com.rapidminer.gui.attributeeditor.DataControlListener;
import com.rapidminer.tools.LogService;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataControl
extends JPanel {
    private static final long serialVersionUID = 6441468388055505143L;
    private JLabel rowCounter;
    private JLabel columnCounter;
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private JTextField fromRowField;
    private JTextField toRowField;
    private JTextField fromColumnField;
    private JTextField toColumnField;
    private JTextField fractionDigitsField;
    private int maxRows;
    private int maxColumns;
    private String rowName;
    private String columnName;
    private int fractionDigits = 3;
    private List<DataControlListener> listeners = new LinkedList<DataControlListener>();

    public DataControl(int _maxRows, int _maxColumns, String _rowName, String _columnName) {
        this(_maxRows, _maxColumns, _rowName, _columnName, true);
    }

    public DataControl(int _maxRows, int _maxColumns, String _rowName, String _columnName, final boolean fractionD) {
        this.maxRows = _maxRows;
        this.maxColumns = _maxColumns;
        this.rowName = _rowName;
        this.columnName = _columnName;
        this.firstRow = 1;
        this.lastRow = Math.min(10, this.maxRows);
        this.firstColumn = 1;
        this.lastColumn = Math.min(10, this.maxColumns);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        this.setLayout(gridBag);
        this.rowCounter = new JLabel("Number of " + this.rowName + "s: " + this.maxRows);
        gridBag.setConstraints(this.rowCounter, c);
        this.add(this.rowCounter);
        this.columnCounter = new JLabel("Number of " + this.columnName + "s: " + this.maxColumns);
        gridBag.setConstraints(this.columnCounter, c);
        this.add(this.columnCounter);
        JLabel label = new JLabel(this.rowName + " range:");
        gridBag.setConstraints(label, c);
        this.add(label);
        c.gridwidth = -1;
        label = new JLabel("from:");
        gridBag.setConstraints(label, c);
        this.add(label);
        this.fromRowField = new JTextField(this.firstRow + "");
        this.fromRowField.setToolTipText("The first " + this.rowName + " which is shown.");
        c.weightx = 1.0;
        c.gridwidth = 0;
        gridBag.setConstraints(this.fromRowField, c);
        this.add(this.fromRowField);
        c.gridwidth = -1;
        c.weightx = 0.0;
        label = new JLabel("to:");
        gridBag.setConstraints(label, c);
        this.add(label);
        this.toRowField = new JTextField(this.lastRow + "");
        this.toRowField.setToolTipText("The last " + this.rowName + " which is shown.");
        c.weightx = 1.0;
        c.gridwidth = 0;
        gridBag.setConstraints(this.toRowField, c);
        this.add(this.toRowField);
        JLabel fillLabel = new JLabel("");
        gridBag.setConstraints(fillLabel, c);
        this.add(fillLabel);
        label = new JLabel(this.columnName + " range:");
        gridBag.setConstraints(label, c);
        this.add(label);
        c.gridwidth = -1;
        label = new JLabel("from:");
        gridBag.setConstraints(label, c);
        this.add(label);
        this.fromColumnField = new JTextField(this.firstColumn + "");
        this.fromColumnField.setToolTipText("The first " + this.columnName + " which is shown.");
        c.weightx = 1.0;
        c.gridwidth = 0;
        gridBag.setConstraints(this.fromColumnField, c);
        this.add(this.fromColumnField);
        c.gridwidth = -1;
        c.weightx = 0.0;
        label = new JLabel("to:");
        gridBag.setConstraints(label, c);
        this.add(label);
        this.toColumnField = new JTextField(this.lastColumn + "");
        this.toColumnField.setToolTipText("The last " + this.columnName + " which is shown.");
        c.weightx = 1.0;
        c.gridwidth = 0;
        gridBag.setConstraints(this.toColumnField, c);
        this.add(this.toColumnField);
        if (fractionD) {
            label = new JLabel("Fraction digits:");
            c.weightx = 0.0;
            gridBag.setConstraints(label, c);
            this.add(label);
            c.weightx = 1.0;
            this.fractionDigits = 3;
            try {
                String numberDigitsString = System.getProperty("rapidminer.general.fractiondigits.numbers");
                if (numberDigitsString != null) {
                    this.fractionDigits = Integer.parseInt(numberDigitsString);
                }
            }
            catch (NumberFormatException e) {
                LogService.getGlobal().log("Bad integer format in property 'rapidminer.gui.fractiondigits.numbers', using default number of fraction digits (3).", 5);
            }
            this.fractionDigitsField = new JTextField(this.fractionDigits + "");
            this.fractionDigitsField.setToolTipText("The number of fraction digits which is used for numerical values.");
            gridBag.setConstraints(this.fractionDigitsField, c);
            this.add(this.fractionDigitsField);
        }
        c.weightx = 1.0;
        JButton updateButton = new JButton("Update");
        updateButton.setToolTipText("Update the view.");
        updateButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int newFirstRow = Integer.parseInt(DataControl.this.fromRowField.getText());
                    if (newFirstRow >= 1 && newFirstRow < DataControl.this.maxRows) {
                        DataControl.this.firstRow = newFirstRow;
                    }
                }
                catch (NumberFormatException ex) {
                }
                finally {
                    DataControl.this.fromRowField.setText(DataControl.this.firstRow + "");
                }
                try {
                    int newLastRow = Integer.parseInt(DataControl.this.toRowField.getText());
                    if (newLastRow >= 1 && newLastRow <= DataControl.this.maxRows) {
                        DataControl.this.lastRow = newLastRow;
                    }
                }
                catch (NumberFormatException ex) {
                }
                finally {
                    DataControl.this.toRowField.setText(DataControl.this.lastRow + "");
                }
                try {
                    int newFirstColumn = Integer.parseInt(DataControl.this.fromColumnField.getText());
                    if (newFirstColumn >= 1 && newFirstColumn < DataControl.this.maxColumns) {
                        DataControl.this.firstColumn = newFirstColumn;
                    }
                }
                catch (NumberFormatException ex) {
                }
                finally {
                    DataControl.this.fromColumnField.setText(DataControl.this.firstColumn + "");
                }
                try {
                    int newLastColumn = Integer.parseInt(DataControl.this.toColumnField.getText());
                    if (newLastColumn >= 1 && newLastColumn <= DataControl.this.maxColumns) {
                        DataControl.this.lastColumn = newLastColumn;
                    }
                }
                catch (NumberFormatException ex) {
                }
                finally {
                    DataControl.this.toColumnField.setText(DataControl.this.lastColumn + "");
                }
                if (fractionD) {
                    try {
                        int newFractionDigits = Integer.parseInt(DataControl.this.fractionDigitsField.getText());
                        if (newFractionDigits >= 0) {
                            DataControl.this.fractionDigits = newFractionDigits;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    finally {
                        DataControl.this.fractionDigitsField.setText(DataControl.this.fractionDigits + "");
                    }
                }
                if (DataControl.this.firstRow > DataControl.this.lastRow) {
                    DataControl.this.firstRow = DataControl.this.lastRow;
                    DataControl.this.fromRowField.setText(DataControl.this.firstRow + "");
                }
                if (DataControl.this.firstColumn > DataControl.this.lastColumn) {
                    DataControl.this.firstColumn = DataControl.this.lastColumn;
                    DataControl.this.fromColumnField.setText(DataControl.this.firstColumn + "");
                }
                DataControl.this.update();
            }
        });
        gridBag.setConstraints(updateButton, c);
        this.add(updateButton);
        c.weighty = 1.0;
        fillLabel = new JLabel("");
        gridBag.setConstraints(fillLabel, c);
        this.add(fillLabel);
    }

    public void setFirstRow(int i) {
        this.firstRow = i;
        this.fromRowField.setText(this.firstRow + "");
    }

    public void setLastRow(int i) {
        this.lastRow = i;
        this.toRowField.setText(this.lastRow + "");
    }

    public void setFirstColumn(int i) {
        this.firstColumn = i;
        this.fromColumnField.setText(this.firstColumn + "");
    }

    public void setLastColumn(int i) {
        this.lastColumn = i;
        this.toColumnField.setText(this.lastColumn + "");
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        this.rowCounter.setText("Number of " + this.rowName + "s: " + maxRows);
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
        this.columnCounter.setText("Number of " + this.columnName + "s: " + maxColumns);
    }

    public void addViewChangeListener(DataControlListener listener) {
        this.listeners.add(listener);
    }

    public void removeViewChangeListener(DataControlListener listener) {
        this.listeners.remove(listener);
    }

    public void update() {
        if (this.firstRow > this.maxRows) {
            this.firstRow = this.maxRows;
            this.fromRowField.setText(this.firstRow + "");
        }
        if (this.lastRow > this.maxRows) {
            this.lastRow = this.maxRows;
            this.toRowField.setText(this.lastRow + "");
        }
        if (this.firstColumn > this.maxColumns) {
            this.firstColumn = this.maxColumns;
            this.fromColumnField.setText(this.firstColumn + "");
        }
        if (this.lastColumn > this.maxColumns) {
            this.lastColumn = this.maxColumns;
            this.toColumnField.setText(this.lastColumn + "");
        }
        Iterator<DataControlListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().update(this.firstRow, this.lastRow, this.firstColumn, this.lastColumn, this.fractionDigits);
        }
    }
}

