/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.attributeeditor;

import com.rapidminer.gui.attributeeditor.AttributeEditor;
import com.rapidminer.gui.attributeeditor.DataControl;
import com.rapidminer.gui.attributeeditor.actions.ClearAction;
import com.rapidminer.gui.attributeeditor.actions.CloseAction;
import com.rapidminer.gui.attributeeditor.actions.LoadDataAction;
import com.rapidminer.gui.attributeeditor.actions.LoadSeriesDataAction;
import com.rapidminer.gui.attributeeditor.actions.OpenAttributeFileAction;
import com.rapidminer.gui.attributeeditor.actions.SaveAttributeFileAction;
import com.rapidminer.gui.attributeeditor.actions.SaveDataAction;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class AttributeEditorDialog
extends ButtonDialog
implements WindowListener {
    private static final long serialVersionUID = 6448298163392765295L;
    private final AttributeEditor attributeEditor;
    public transient Action OPEN_ATTRIBUTE_FILE_ACTION;
    public transient Action SAVE_ATTRIBUTE_FILE_ACTION;
    public transient Action LOAD_DATA_ACTION;
    public transient Action LOAD_SERIES_DATA_ACTION;
    public transient Action SAVE_DATA_ACTION;
    public transient Action CLEAR_ACTION;
    public transient Action CLOSE_ACTION;

    public AttributeEditorDialog(JFrame owner, Operator exampleSource, File file) {
        this(owner, exampleSource);
        if (file != null) {
            this.attributeEditor.openAttributeFile(file);
        }
    }

    public AttributeEditorDialog(JFrame owner, Operator exampleSource) {
        super((Frame)owner, "attribute_editor", true, new Object[0]);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        DataControl control = new DataControl(0, 0, "Example", "Attribute", false);
        this.attributeEditor = new AttributeEditor(exampleSource, control);
        control.addViewChangeListener(this.attributeEditor);
        this.getContentPane().add((Component)control, "West");
        this.getContentPane().add((Component)new ExtendedJScrollPane(this.attributeEditor), "Center");
        control.update();
        this.initActions();
        JMenuBar menuBar = new JMenuBar();
        ResourceMenu fileMenu = new ResourceMenu("attribute_editor_file");
        fileMenu.add(this.OPEN_ATTRIBUTE_FILE_ACTION);
        fileMenu.add(this.SAVE_ATTRIBUTE_FILE_ACTION);
        fileMenu.add(this.LOAD_DATA_ACTION);
        fileMenu.add(this.SAVE_DATA_ACTION);
        fileMenu.add(this.LOAD_SERIES_DATA_ACTION);
        fileMenu.addSeparator();
        fileMenu.add(this.CLOSE_ACTION);
        menuBar.add(fileMenu);
        ResourceMenu tableMenu = new ResourceMenu("attribute_editor_table");
        tableMenu.add(this.attributeEditor.GUESS_TYPE_ACTION);
        tableMenu.add(this.attributeEditor.GUESS_ALL_TYPES_ACTION);
        tableMenu.add(this.attributeEditor.REMOVE_COLUMN_ACTION);
        tableMenu.add(this.attributeEditor.REMOVE_ROW_ACTION);
        tableMenu.add(this.attributeEditor.USE_ROW_AS_NAMES_ACTION);
        tableMenu.add(this.CLEAR_ACTION);
        menuBar.add(tableMenu);
        this.setJMenuBar(menuBar);
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.add(this.OPEN_ATTRIBUTE_FILE_ACTION);
        toolBar.add(this.SAVE_ATTRIBUTE_FILE_ACTION);
        toolBar.add(this.LOAD_DATA_ACTION);
        toolBar.add(this.SAVE_DATA_ACTION);
        toolBar.addSeparator();
        toolBar.add(this.CLEAR_ACTION);
        this.getContentPane().add((Component)toolBar, "North");
        this.setSize((int)Math.max(600.0, (double)owner.getWidth() * 2.0 / 3.0), (int)Math.max(400.0, (double)owner.getHeight() * 2.0 / 3.0));
        this.setLocationRelativeTo(owner);
    }

    public void initActions() {
        this.OPEN_ATTRIBUTE_FILE_ACTION = new OpenAttributeFileAction(this.attributeEditor);
        this.SAVE_ATTRIBUTE_FILE_ACTION = new SaveAttributeFileAction(this.attributeEditor);
        this.LOAD_DATA_ACTION = new LoadDataAction(this.attributeEditor);
        this.LOAD_SERIES_DATA_ACTION = new LoadSeriesDataAction(this.attributeEditor);
        this.SAVE_DATA_ACTION = new SaveDataAction(this.attributeEditor);
        this.CLEAR_ACTION = new ClearAction(this.attributeEditor);
        this.CLOSE_ACTION = new CloseAction(this);
    }

    public File getFile() {
        return this.attributeEditor.getFile();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.close();
    }

    @Override
    public void close() {
        if (this.attributeEditor.hasDataChanged()) {
            int selectedOption = JOptionPane.showConfirmDialog(this, "It seems that you have changed the data without saving it afterwards." + Tools.getLineSeparator() + "Do you still want to proceed and close the editor (changes will be lost)?", "Save data file?", 0, 3);
            if (selectedOption == 0) {
                this.dispose();
            }
        } else if (this.attributeEditor.hasMetaDataChanged()) {
            int selectedOption = JOptionPane.showConfirmDialog(this, "It seems that you have changed the attribute descriptions without saving an attribute description file (.aml) afterwards." + Tools.getLineSeparator() + "Do you still want to proceed and close the editor (changes will be lost)?", "Save attribute description file?", 0, 3);
            if (selectedOption == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }
}

