/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.attributeeditor;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.FileDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.RapidMinerLineReader;
import com.rapidminer.gui.EditorCellRenderer;
import com.rapidminer.gui.attributeeditor.CellEditors;
import com.rapidminer.gui.attributeeditor.CellRenderers;
import com.rapidminer.gui.attributeeditor.DataControl;
import com.rapidminer.gui.attributeeditor.DataControlListener;
import com.rapidminer.gui.attributeeditor.actions.GuessAllTypesAction;
import com.rapidminer.gui.attributeeditor.actions.GuessTypeAction;
import com.rapidminer.gui.attributeeditor.actions.RemoveColumnAction;
import com.rapidminer.gui.attributeeditor.actions.RemoveRowAction;
import com.rapidminer.gui.attributeeditor.actions.UseRowAsNamesAction;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.att.AttributeDataSource;
import com.rapidminer.tools.att.AttributeDataSources;
import com.rapidminer.tools.att.AttributeSet;
import com.rapidminer.tools.io.Encoding;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AttributeEditor
extends ExtendedJTable
implements MouseListener,
DataControlListener {
    private static final long serialVersionUID = -3312532913749370288L;
    public static final int LOAD_DATA = 0;
    public static final int LOAD_SERIES_DATA = 1;
    private static final int COLUMN_WIDTH = 120;
    protected transient Action REMOVE_COLUMN_ACTION = new RemoveColumnAction(this);
    protected transient Action REMOVE_ROW_ACTION = new RemoveRowAction(this);
    protected transient Action USE_ROW_AS_NAMES_ACTION = new UseRowAsNamesAction(this);
    protected transient Action GUESS_TYPE_ACTION = new GuessTypeAction(this);
    protected transient Action GUESS_ALL_TYPES_ACTION = new GuessAllTypesAction(this);
    private static final int NAME_ROW = 0;
    private static final int TYPE_ROW = 1;
    private static final int VALUE_TYPE_ROW = 2;
    private static final int BLOCK_TYPE_ROW = 3;
    private static final int SEPARATOR_ROW = 4;
    private static final int NUM_OF_HEADER_ROWS = 5;
    private transient CellEditors cellEditors = new CellEditors(5);
    private transient CellRenderers cellRenderers = new CellRenderers(5);
    private transient TableCellRenderer dataRenderer = new DataCellRenderer();
    private final ArrayList<AttributeDataSource> sourceList = new ArrayList();
    private File file;
    private final transient Operator exampleSource;
    private AttributeTableModel model;
    private int rowCount = 0;
    private int firstRow = 1;
    private int lastRow = 10;
    private int firstColumn = 1;
    private int lastColumn = 10;
    private boolean dataChanged = false;
    private boolean metaDataChanged = false;
    private final Vector<Vector<String>> dataColumnVector = new Vector();
    private final DataControl dataControl;

    public AttributeEditor(Operator exampleSource, DataControl dataControl) {
        super(null, false);
        this.dataControl = dataControl;
        this.model = new AttributeTableModel();
        this.setModel(this.model);
        this.exampleSource = exampleSource;
        this.setRowHeight(this.getRowHeight() + 10);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.addMouseListener(this);
    }

    @Override
    protected Object readResolve() {
        this.cellEditors = new CellEditors(5);
        this.cellRenderers = new CellRenderers(5);
        this.dataRenderer = new DataCellRenderer();
        return this;
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public boolean hasMetaDataChanged() {
        return this.metaDataChanged;
    }

    private AttributeDataSource getDataSource(int i) {
        return this.sourceList.get(i);
    }

    private String getDatum(int row, int column) {
        Vector<String> col = this.dataColumnVector.get(column);
        if (row >= col.size()) {
            return "?";
        }
        return col.get(row);
    }

    private void setDatum(int row, int column, String value) {
        Vector<String> col = this.dataColumnVector.get(column);
        if (row >= col.size()) {
            col.addElement(value);
            if (row >= this.rowCount) {
                this.rowCount = row + 1;
            }
        } else {
            col.setElementAt(value, row);
        }
        this.dataControl.setMaxRows(Math.max(this.dataControl.getMaxRows(), col.size()));
        this.dataControl.setMaxColumns(Math.max(this.dataControl.getMaxColumns(), this.dataColumnVector.size()));
    }

    private int getDefaultMaximumNumber(String limitName, int defaultNumber) {
        String max = System.getProperty("rapidminer.gui.attributeeditor." + limitName);
        if (max != null) {
            try {
                int number = Integer.parseInt(max);
                if (number == -1) {
                    return defaultNumber;
                }
                return number;
            }
            catch (NumberFormatException e) {
                LogService.getGlobal().log("Value of rapidminer.gui.attributeeditor." + limitName + " must be an integer!", 6);
                return defaultNumber;
            }
        }
        return defaultNumber;
    }

    private void createNewColumn() {
        JTextField nameField = new JTextField();
        nameField.setToolTipText("The name of the attribute.");
        this.cellEditors.add(0, new DefaultCellEditor(nameField));
        JComboBox<String> typeBox = new JComboBox<String>(Attributes.KNOWN_ATTRIBUTE_TYPES);
        typeBox.setEditable(true);
        typeBox.setToolTipText("The type of the attribute ('attribute' for regular learning attributes or a special attribute name).");
        this.cellEditors.add(1, new DefaultCellEditor(typeBox));
        LinkedList<String> usedTypes = new LinkedList<String>();
        for (int i = 0; i < Ontology.VALUE_TYPE_NAMES.length; ++i) {
            if (i == 0 || i == 8 || Ontology.ATTRIBUTE_VALUE_TYPE.isA(i, 9)) continue;
            usedTypes.add(Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(i));
        }
        String[] valueTypes = new String[usedTypes.size()];
        int vCounter = 0;
        for (String type : usedTypes) {
            valueTypes[vCounter++] = type;
        }
        JComboBox<String> valueTypeBox = new JComboBox<String>(valueTypes);
        valueTypeBox.setToolTipText("The value type of the attribute.");
        this.cellEditors.add(2, new DefaultCellEditor(valueTypeBox));
        JComboBox<String> blockTypeBox = new JComboBox<String>(Ontology.ATTRIBUTE_BLOCK_TYPE.getNames());
        blockTypeBox.setToolTipText("The block type of this attribute.");
        this.cellEditors.add(3, new DefaultCellEditor(blockTypeBox));
        JTextField separator = new JTextField();
        separator.setToolTipText("Separates meta data from data.");
        separator.setEditable(false);
        this.cellEditors.add(4, new DefaultCellEditor(separator));
        for (int i = 0; i < this.cellRenderers.getSize(); ++i) {
            this.cellRenderers.add(i, new EditorCellRenderer(this.cellEditors.get(i, this.cellEditors.getSize(i) - 1)));
        }
        this.dataColumnVector.add(new Vector());
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        TableColumn column = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1);
        column.setPreferredWidth(120);
    }

    private void addColumn(File file, int index, int valueType) {
        String name = file.getName() + " (" + (index + 1) + ")";
        AttributeDataSource source = new AttributeDataSource(AttributeFactory.createAttribute(name, valueType), file, index, "attribute");
        this.createNewColumn();
        this.sourceList.add(source);
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    public void clear() {
        this.sourceList.clear();
        this.dataColumnVector.clear();
        this.rowCount = 0;
        this.dataControl.setMaxRows(0);
        this.dataControl.setMaxColumns(0);
        this.dataControl.update();
        this.dataChanged = false;
        this.metaDataChanged = false;
    }

    public void readData(File file, int dataType) throws IOException {
        int i;
        String[] columns;
        int columnOffset = this.sourceList.size();
        int numberOfNewColumns = 0;
        int currentRow = -1;
        BufferedReader in = new BufferedReader(new FileReader(file));
        RapidMinerLineReader reader = null;
        try {
            reader = new RapidMinerLineReader(this.exampleSource.getParameterAsString("column_separators"), this.exampleSource.getParameterAsString("comment_chars").toCharArray(), this.exampleSource.getParameterAsBoolean("use_quotes"), this.exampleSource.getParameterAsString("quote_character").charAt(0), this.exampleSource.getParameterAsString("quoting_escape_character").charAt(0), this.exampleSource.getParameterAsBoolean("trim_lines"), this.exampleSource.getParameterAsBoolean("skip_error_lines"));
        }
        catch (UndefinedParameterError e) {
            throw new IOException("Cannot create RapidMiner line reader: " + e.getMessage());
        }
        ArrayList<Integer> valueTypes = new ArrayList<Integer>();
        int expectedNumberOfColumns = -1;
        while ((columns = reader.readLine(in, expectedNumberOfColumns)) != null) {
            expectedNumberOfColumns = columns.length;
            ++currentRow;
            for (int currentColumn = 0; currentColumn < columns.length; ++currentColumn) {
                int valueType = 3;
                String value = columns[currentColumn];
                if (!value.equals("?") && value.length() > 0) {
                    try {
                        double d = Double.parseDouble(value);
                        valueType = Tools.isEqual(Math.round(d), d) ? 3 : 4;
                    }
                    catch (NumberFormatException e) {
                        valueType = 1;
                    }
                }
                if (currentColumn >= numberOfNewColumns) {
                    this.addColumn(file, currentColumn, valueType);
                    ++numberOfNewColumns;
                    valueTypes.add(valueType);
                } else {
                    int soFar = (Integer)valueTypes.get(currentColumn);
                    if (soFar != valueType) {
                        if (soFar == 1 || valueType == 1) {
                            valueTypes.set(currentColumn, 1);
                        } else {
                            valueTypes.set(currentColumn, 4);
                        }
                    }
                }
                this.setDatum(currentRow, currentColumn + columnOffset, value);
            }
        }
        in.close();
        for (i = 0; i < valueTypes.size(); ++i) {
            this.getDataSource(i + columnOffset).setAttribute(AttributeFactory.changeValueType(this.getDataSource(i + columnOffset).getAttribute(), (Integer)valueTypes.get(i)));
        }
        if (dataType == 1) {
            this.getDataSource(columnOffset).getAttribute().setBlockType(3);
            for (i = 1; i < valueTypes.size() - 1; ++i) {
                this.getDataSource(i + columnOffset).getAttribute().setBlockType(2);
            }
            this.getDataSource(valueTypes.size() - 1 + columnOffset).getAttribute().setBlockType(4);
        }
        this.update();
        this.guessAllColumnTypes();
        this.dataChanged = false;
        this.metaDataChanged = true;
    }

    public void guessColumnType() {
        int column = this.getSelectedColumn();
        if (column != -1) {
            this.autoSetValueType(column);
        }
    }

    public void guessAllColumnTypes() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.autoSetValueType(i);
        }
    }

    private void autoSetValueType(int column) {
        char decimalPointCharacter = '.';
        try {
            decimalPointCharacter = this.exampleSource.getParameterAsString("decimal_point_character").charAt(0);
        }
        catch (UndefinedParameterError e) {
            // empty catch block
        }
        int valueType = 3;
        AttributeDataSource source = this.getDataSource(column);
        for (int i = 0; i < this.rowCount; ++i) {
            String value = this.getDatum(i, column);
            if (value == null || value.equals("?") || value.trim().length() <= 0) continue;
            try {
                String valueString = value.replace(decimalPointCharacter, '.');
                double d = Double.parseDouble(valueString);
                if (valueType != 3 || Tools.isEqual(Math.round(d), d)) continue;
                valueType = 4;
                continue;
            }
            catch (NumberFormatException e) {
                valueType = 1;
                break;
            }
        }
        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), valueType));
        this.model.fireTableCellUpdated(2, column);
        this.metaDataChanged = true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (row >= 5) {
            return super.getCellEditor(row, column);
        }
        return this.cellEditors.get(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row >= 5) {
            return this.dataRenderer;
        }
        return this.cellRenderers.get(row, column);
    }

    private boolean checkData(Object value, int row, int column) {
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int row = this.rowAtPoint(e.getPoint());
        int column = this.columnAtPoint(e.getPoint());
        this.setRowSelectionInterval(row, row);
        this.setColumnSelectionInterval(column, column);
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu(this.columnAtPoint(e.getPoint())).show(this, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu(int column) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.GUESS_TYPE_ACTION);
        menu.add(this.GUESS_ALL_TYPES_ACTION);
        menu.add(this.REMOVE_COLUMN_ACTION);
        menu.add(this.REMOVE_ROW_ACTION);
        menu.add(this.USE_ROW_AS_NAMES_ACTION);
        return menu;
    }

    public void useRowAsNames() {
        int row = this.getSelectedRow() - 5;
        if (row >= 0) {
            this.useRowAsNames(row);
        }
    }

    public void removeColumn() {
        int column = this.getSelectedColumn();
        if (column != -1) {
            this.removeColumn(column);
        }
    }

    public void removeColumn(int column) {
        this.sourceList.remove(column);
        this.dataColumnVector.removeElementAt(column);
        this.rowCount = 0;
        if (this.dataColumnVector.size() > 0) {
            this.rowCount = this.dataColumnVector.get(0).size();
        }
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.setMaxColumns(Math.max(0, this.dataControl.getMaxColumns() - 1));
        this.dataControl.update();
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    public void removeRow() {
        int row = this.getSelectedRow() - 5;
        if (row != -1) {
            this.removeRow(row);
        }
    }

    public void removeRow(int row) {
        if (this.rowCount == 0 || row < 0) {
            return;
        }
        for (Vector<String> column : this.dataColumnVector) {
            column.remove(row);
        }
        --this.rowCount;
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.update();
        this.dataChanged = true;
    }

    public void useRowAsNames(int row) {
        if (this.rowCount == 0 || row < 0) {
            return;
        }
        int columnIndex = 0;
        for (Vector<String> column : this.dataColumnVector) {
            String name = column.remove(row);
            this.setValueAt(name, 0, columnIndex);
            ++columnIndex;
        }
        --this.rowCount;
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.update();
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<AttributeDataSource> columns = new LinkedList<AttributeDataSource>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<AttributeDataSource> i = this.sourceList.iterator();
        int j = 0;
        while (i.hasNext()) {
            AttributeDataSource source = i.next();
            if (source.getType() != null && source.getType().equals(type)) {
                columns.add(source);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            i = columns.iterator();
            j = 0;
            while (i.hasNext()) {
                names[j++] = i.next().getAttribute().getName();
            }
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, type + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                i = columns.iterator();
                Iterator k = columnNumbers.iterator();
                while (i.hasNext()) {
                    AttributeDataSource source = i.next();
                    Integer number = (Integer)k.next();
                    if (source.getAttribute().getName().equals(selection)) continue;
                    source.setType("attribute");
                    this.model.fireTableCellUpdated(1, number);
                }
            }
        }
    }

    public void writeData(File file) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        Charset encoding = Tools.getDefaultEncoding();
        try {
            encoding = Encoding.getEncoding(this.exampleSource);
        }
        catch (Exception e) {
            // empty catch block
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            for (int i = 0; i < this.sourceList.size(); ++i) {
                AttributeDataSource source = this.sourceList.get(i);
                source.setSource(file, i);
            }
            for (int row = 0; row < this.rowCount; ++row) {
                for (int col = 0; col < this.sourceList.size(); ++col) {
                    if (col != 0) {
                        out.print("\t");
                    }
                    String value = this.getDatum(row, col);
                    out.print(value);
                    Attribute attribute = this.sourceList.get(col).getAttribute();
                    if (!attribute.isNominal() || value == null || value.length() == 0 || value.equals("?")) continue;
                    attribute.getMapping().mapString(value);
                }
                out.println();
            }
            this.dataChanged = false;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void openAttributeFile() {
        File file = SwingTools.chooseFile(this, null, true, "aml", "attribute description file");
        if (file != null) {
            this.openAttributeFile(file);
        }
    }

    public void openAttributeFile(File file) {
        AttributeDataSources attributeDataSources = null;
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(file, true, LogService.getGlobal());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not open '" + file + "':" + Tools.getLineSeparator() + e, "Error", 0);
            return;
        }
        if (attributeDataSources != null) {
            Charset encoding;
            this.file = file;
            this.clear();
            try {
                encoding = Encoding.getEncoding(this.exampleSource);
            }
            catch (UndefinedParameterError e1) {
                encoding = Charset.defaultCharset();
            }
            catch (UserError e1) {
                encoding = Charset.defaultCharset();
            }
            FileDataRowReader reader = null;
            try {
                char[] commentCharacters = null;
                if (this.exampleSource.getParameterAsBoolean("use_comment_characters")) {
                    commentCharacters = this.exampleSource.getParameterAsString("comment_chars").toCharArray();
                }
                reader = new FileDataRowReader(new DataRowFactory(this.exampleSource.getParameterAsInt("datamanagement"), this.exampleSource.getParameterAsString("decimal_point_character").charAt(0)), attributeDataSources.getDataSources(), 1.0, -1, this.exampleSource.getParameterAsString("column_separators"), commentCharacters, this.exampleSource.getParameterAsBoolean("use_quotes"), this.exampleSource.getParameterAsString("quote_character").charAt(0), this.exampleSource.getParameterAsString("quoting_escape_character").charAt(0), this.exampleSource.getParameterAsBoolean("trim_lines"), this.exampleSource.getParameterAsBoolean("skip_error_lines"), encoding, RandomGenerator.getGlobalRandomGenerator());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Cannot open data file: " + e, "Error", 0);
                return;
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            if (reader != null) {
                this.sourceList.addAll(attributeDataSources.getDataSources());
                for (int j = 0; j < attributeDataSources.getDataSources().size(); ++j) {
                    this.createNewColumn();
                }
                MemoryExampleTable table = null;
                try {
                    table = new MemoryExampleTable(new AttributeSet(attributeDataSources).getAllAttributes(), reader);
                }
                catch (UserError e) {
                    SwingTools.showSimpleErrorMessage("cannot_load_attr_descr", (Throwable)e, new Object[0]);
                }
                if (table != null) {
                    Iterator e = table.createExampleSet().iterator();
                    this.rowCount = 0;
                    while (e.hasNext()) {
                        Example example = (Example)e.next();
                        Iterator<AttributeDataSource> adsIterator = this.sourceList.iterator();
                        int n = 0;
                        while (adsIterator.hasNext()) {
                            AttributeDataSource ads = adsIterator.next();
                            this.setDatum(this.rowCount, n++, example.getValueAsString(ads.getAttribute()));
                        }
                        ++this.rowCount;
                    }
                }
                this.update();
                this.metaDataChanged = false;
                this.dataChanged = false;
            }
        }
    }

    public void saveAttributeFile() {
        for (int i = 1; i < Attributes.KNOWN_ATTRIBUTE_TYPES.length; ++i) {
            this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
        }
        File file = SwingTools.chooseFile(this, null, false, "aml", "attribute description file");
        if (file != null) {
            this.file = file;
            try {
                Charset encoding = Charset.defaultCharset();
                try {
                    encoding = Encoding.getEncoding(this.exampleSource);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.writeXML(file, encoding);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving attribute file " + file, 0);
            }
        }
        this.metaDataChanged = false;
    }

    private void writeXML(File attFile, Charset encoding) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        if (this.getDataSource(0).getFile() == null) {
            throw new IOException("ExampleSet writing: cannot determine path to data file: data file was not given!");
        }
        String relativePath = Tools.getRelativePath(this.getDataSource(0).getFile(), attFile);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("attributeset");
            root.setAttribute("default_source", relativePath);
            root.setAttribute("encoding", encoding.name());
            document.appendChild(root);
            for (AttributeDataSource ads : this.sourceList) {
                root.appendChild(ads.writeXML(document, this.getDataSource(0).getFile()));
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(attFile), encoding));
            writer.print(XMLTools.toString(document, encoding));
            writer.close();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create XML document builder: " + e, e);
        }
        catch (XMLException e) {
            throw new IOException("Could not format XML document:" + e, e);
        }
    }

    public File getFile() {
        return this.file;
    }

    private void update() {
        this.dataControl.setFirstRow(1);
        this.dataControl.setLastRow(Math.min(this.dataControl.getMaxRows(), this.getDefaultMaximumNumber("rowlimit", this.dataControl.getMaxRows())));
        this.dataControl.setFirstColumn(1);
        this.dataControl.setLastColumn(Math.min(this.dataControl.getMaxColumns(), this.getDefaultMaximumNumber("columnlimit", this.dataControl.getMaxColumns())));
        this.dataControl.update();
    }

    @Override
    public void update(int firstRow, int lastRow, int firstColumn, int lastColumn, int what) {
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstColumn = firstColumn;
        this.lastColumn = lastColumn;
        this.model.fireTableStructureChanged();
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 6911819468492570763L;

        private AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return Math.min(AttributeEditor.this.sourceList.size(), AttributeEditor.this.lastColumn - (AttributeEditor.this.firstColumn - 1));
        }

        @Override
        public int getRowCount() {
            return Math.min(AttributeEditor.this.rowCount, AttributeEditor.this.lastRow - (AttributeEditor.this.firstRow - 1)) + 5;
        }

        @Override
        public String getColumnName(int _column) {
            int column = _column + (AttributeEditor.this.firstColumn - 1);
            AttributeDataSource source = AttributeEditor.this.getDataSource(column);
            return source.getFile().getName() + " (" + (source.getColumn() + 1) + ")";
        }

        @Override
        public Object getValueAt(int _row, int _column) {
            int row = _row;
            int column = _column + (AttributeEditor.this.firstColumn - 1);
            if (row < 5) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 0: {
                        return source.getAttribute().getName();
                    }
                    case 1: {
                        return source.getType();
                    }
                    case 2: {
                        return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(source.getAttribute().getValueType());
                    }
                    case 3: {
                        return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(source.getAttribute().getBlockType());
                    }
                    case 4: {
                        return null;
                    }
                }
                return "This cannot happen!";
            }
            row = _row + (AttributeEditor.this.firstRow - 1);
            return AttributeEditor.this.getDatum(row - 5, column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < 5) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 0: {
                        source.getAttribute().setName((String)value);
                        break;
                    }
                    case 1: {
                        source.setType((String)value);
                        break;
                    }
                    case 2: {
                        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), Ontology.ATTRIBUTE_VALUE_TYPE.mapName((String)value)));
                        break;
                    }
                    case 3: {
                        source.getAttribute().setBlockType(Ontology.ATTRIBUTE_BLOCK_TYPE.mapName((String)value));
                        break;
                    }
                }
            } else {
                AttributeEditor.this.setDatum(row - 5, column, (String)value);
            }
        }
    }

    private class DataCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7231941979925919248L;

        private DataCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!AttributeEditor.this.checkData(value, row, column)) {
                c.setBackground(Color.red);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }
}

