/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.components.ToggleDropDownButton;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;

public abstract class ToggleAction
extends ResourceAction {
    private static final long serialVersionUID = -4465114837957358373L;
    private boolean selected = false;
    private Collection<ToggleActionListener> listeners = new LinkedList<ToggleActionListener>();

    public ToggleAction(boolean smallIcon, String key, Object ... args) {
        super(smallIcon, key, args);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSelected(!this.isSelected());
        this.actionToggled(null);
    }

    public abstract void actionToggled(ActionEvent var1);

    public void resetAction(boolean selected) {
        if (selected != this.isSelected()) {
            this.setSelected(!this.isSelected());
            this.actionToggled(null);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        for (ToggleActionListener l : this.listeners) {
            l.setSelected(selected);
        }
    }

    public JCheckBoxMenuItem createMenuItem() {
        ToggleJCheckBoxMenuItem item = new ToggleJCheckBoxMenuItem(this);
        this.listeners.add(item);
        return item;
    }

    public JToggleButton createToggleButton() {
        ToggleJToggleButton button = new ToggleJToggleButton(this);
        this.listeners.add(button);
        return button;
    }

    public ToggleDropDownButton createDropDownToggleButton(final JPopupMenu popupMenu) {
        ToggleJToggleDropDownButton button = new ToggleJToggleDropDownButton(this){
            private static final long serialVersionUID = 619422148555974973L;

            @Override
            protected JPopupMenu getPopupMenu() {
                return popupMenu;
            }
        };
        this.listeners.add(button);
        return button;
    }

    public void addToggleActionListener(ToggleActionListener l) {
        this.listeners.add(l);
    }

    public void removeToggleActionListener(ToggleActionListener l) {
        this.listeners.remove(l);
    }

    private abstract class ToggleJToggleDropDownButton
    extends ToggleDropDownButton
    implements ToggleActionListener {
        private static final long serialVersionUID = 1534764344656638939L;

        private ToggleJToggleDropDownButton(ToggleAction action) {
            super(action);
            this.setSelected(ToggleAction.this.isSelected());
        }
    }

    private class ToggleJToggleButton
    extends JToggleButton
    implements ToggleActionListener {
        private static final long serialVersionUID = 8939204437291275737L;

        private ToggleJToggleButton(Action action) {
            super(action);
            this.setSelected(ToggleAction.this.isSelected());
        }
    }

    private class ToggleJCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements ToggleActionListener {
        private static final long serialVersionUID = 8604924475187496354L;

        private ToggleJCheckBoxMenuItem(Action action) {
            super(action);
            this.setSelected(ToggleAction.this.isSelected());
        }
    }

    public static interface ToggleActionListener {
        public void setSelected(boolean var1);
    }
}

