/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import java.awt.event.ActionEvent;

public class StoreInRepositoryAction
extends ResourceAction {
    private final IOObject object;
    private static final long serialVersionUID = 1L;

    public StoreInRepositoryAction(IOObject object) {
        super(true, "store_in_repository", object instanceof ResultObject ? ((ResultObject)object).getName() : "result");
        this.object = object;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String loc = RepositoryLocationChooser.selectLocation(null, null, RapidMinerGUI.getMainFrame(), true, false);
        if (loc != null) {
            RepositoryLocation location;
            try {
                location = new RepositoryLocation(loc);
            }
            catch (Exception ex) {
                SwingTools.showSimpleErrorMessage("malformed_rep_location", (Throwable)ex, loc);
                return;
            }
            try {
                RepositoryManager.getInstance(null).store(this.object, location, null);
            }
            catch (RepositoryException ex) {
                SwingTools.showSimpleErrorMessage("cannot_store_obj_at_location", (Throwable)ex, loc);
            }
        }
    }
}

