/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.OperatorDocViewer;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;

public class ShowHelpTextInBrowserAction
extends ResourceAction {
    private final OperatorDocViewer operatorDocViewer;
    private static final String[] browsers = new String[]{"iexplorer"};
    public static final String WIKI_PREFIX_FOR_OPERATORS = "http://rapid-i.com/wiki/index.php?title=";
    private static final long serialVersionUID = 909390054503086861L;

    public ShowHelpTextInBrowserAction(boolean smallIcon, String i18nKey, Object[] i18nArgs, OperatorDocViewer operatorDocViewer) {
        super(smallIcon, i18nKey, i18nArgs);
        this.operatorDocViewer = operatorDocViewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url = WIKI_PREFIX_FOR_OPERATORS + this.operatorDocViewer.getDisplayedOperatorDescName().replaceAll(" ", "_");
        try {
            Class<?> d = Class.forName("java.awt.Desktop");
            d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
        }
        catch (Exception ignore) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac")) {
                try {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                }
                catch (IllegalArgumentException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
                catch (SecurityException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
                catch (IllegalAccessException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
                catch (InvocationTargetException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
                catch (NoSuchMethodException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
                catch (ClassNotFoundException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
            }
            if (osName.startsWith("Windows")) {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{url});
                }
                catch (IOException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", (Throwable)e1, true, new Object[]{url});
                }
            }
            String browser = null;
            for (String b : browsers) {
                try {
                    if (browser != null || Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() == -1) continue;
                    Runtime.getRuntime().exec(new String[]{browser = b, url});
                    if (browser != null) continue;
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", null, true, new Object[]{Arrays.toString(browsers)});
                }
                catch (IOException e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", (Throwable)e1, true, new Object[]{url});
                }
                catch (Exception e1) {
                    SwingTools.showFinalErrorMessage("rapid_doc_bot_importer_showInBrowser", (Throwable)e1, true, new Object[]{url});
                }
            }
        }
    }
}

