/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.Process;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.SaveAction;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import java.awt.event.ActionEvent;

public class SaveAsAction
extends ResourceAction {
    private static final long serialVersionUID = -6107588898380953147L;

    public SaveAsAction() {
        super("save_as", new Object[0]);
        this.setCondition(9, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SaveAsAction.saveAs(RapidMinerGUI.getMainFrame().getProcess());
    }

    public static void saveAs(Process process) {
        String loc;
        String initial = null;
        if (process.getRepositoryLocation() != null) {
            initial = process.getRepositoryLocation().toString();
        }
        if ((loc = RepositoryLocationChooser.selectLocation(null, initial, RapidMinerGUI.getMainFrame(), true, false)) != null) {
            try {
                RepositoryLocation location = new RepositoryLocation(loc);
                Entry entry = location.locateEntry();
                if (entry instanceof ProcessEntry && SwingTools.showConfirmDialog("overwrite", 0, entry.getLocation()) == 1) {
                    return;
                }
                process.setProcessLocation(new RepositoryProcessLocation(location));
            }
            catch (MalformedRepositoryLocationException e) {
                SwingTools.showSimpleErrorMessage("cannot_save_process", (Throwable)e, new Object[0]);
            }
            catch (RepositoryException e) {
                SwingTools.showSimpleErrorMessage("cannot_save_process", (Throwable)e, new Object[0]);
            }
            SaveAction.save(process);
        }
    }
}

