/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.SaveAsAction;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.DecisionRememberingConfirmDialog;
import java.awt.event.ActionEvent;
import java.io.IOException;

public class SaveAction
extends ResourceAction {
    private static final long serialVersionUID = -2226200404990114956L;

    public SaveAction() {
        super("save", new Object[0]);
        this.setEnabled(false);
        this.setCondition(9, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SaveAction.save(RapidMinerGUI.getMainFrame().getProcess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Process process) {
        try {
            if (process.hasSaveDestination()) {
                Process process2 = process;
                synchronized (process2) {
                    if (!SaveAction.confirmOverwriteWithNewVersion(process)) {
                        return;
                    }
                    process.save();
                }
            } else {
                SaveAsAction.saveAs(process);
            }
            RapidMinerGUI.useProcessFile(process);
            RapidMinerGUI.getMainFrame().processHasBeenSaved();
        }
        catch (IOException ex) {
            SwingTools.showSimpleErrorMessage("cannot_save_process", (Throwable)ex, new Object[0]);
        }
    }

    private static boolean confirmOverwriteWithNewVersion(Process process) {
        return !process.isProcessConverted() || DecisionRememberingConfirmDialog.confirmAction("save_over_with_new_version", "rapidminer.gui.saveover_new_version");
    }
}

