/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.tools.ComponentPrinter;
import com.rapidminer.gui.tools.PrintingTools;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;

public class PrintAction
extends ResourceAction {
    private static final long serialVersionUID = -9086092676881347047L;
    private final Component component;

    public PrintAction(Component component, String componentName) {
        super("print", componentName);
        this.component = component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrintingTools.getPrinterJob().setPrintable(new ComponentPrinter(this.component));
        if (PrintingTools.getPrinterJob().printDialog()) {
            try {
                PrintingTools.getPrinterJob().print();
            }
            catch (PrinterException pe) {
                SwingTools.showSimpleErrorMessage("printer_error", (Throwable)pe, new Object[0]);
            }
        }
    }

    protected static void pageSetup() {
        PrintingTools.setPageFormat(PrintingTools.getPrinterJob().pageDialog(PrintingTools.getPageFormat()));
    }
}

