/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.repository.gui.RepositoryTree;
import com.rapidminer.tools.XMLException;
import java.awt.event.ActionEvent;
import java.io.IOException;

public class OpenAction
extends ResourceAction {
    private static final long serialVersionUID = -323403851840397447L;

    public OpenAction() {
        super("open", new Object[0]);
        this.setCondition(9, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OpenAction.open();
    }

    public static void open() {
        String location;
        if (RapidMinerGUI.getMainFrame().close() && (location = RepositoryLocationChooser.selectLocation(null, null, RapidMinerGUI.getMainFrame(), true, false)) != null) {
            try {
                OpenAction.open(new RepositoryProcessLocation(new RepositoryLocation(location)), true);
            }
            catch (MalformedRepositoryLocationException e) {
                SwingTools.showSimpleErrorMessage("while_loading", (Throwable)e, location, e.getMessage());
            }
        }
    }

    public static void open(final ProcessLocation processLocation, final boolean showInfo) {
        RapidMinerGUI.getMainFrame().stopProcess();
        ProgressThread openProgressThread = new ProgressThread("open_file"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(10);
                try {
                    Process process = processLocation.load(this.getProgressListener());
                    process.setProcessLocation(processLocation);
                    RapidMinerGUI.getMainFrame().setOpenedProcess(process, showInfo, ((Object)processLocation).toString());
                }
                catch (XMLException ex) {
                    try {
                        RapidMinerGUI.getMainFrame().handleBrokenProxessXML(processLocation, processLocation.getRawXML(), ex);
                    }
                    catch (IOException e) {
                        SwingTools.showSimpleErrorMessage("while_loading", (Throwable)e, processLocation, e.getMessage());
                        return;
                    }
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("while_loading", (Throwable)e, processLocation, e.getMessage());
                    return;
                }
                finally {
                    this.getProgressListener().complete();
                }
            }
        };
        openProgressThread.start();
    }

    public static void open(String openLocation, boolean showInfo) {
        block4: {
            try {
                RepositoryLocation location = new RepositoryLocation(openLocation);
                Entry entry = location.locateEntry();
                if (entry instanceof ProcessEntry) {
                    OpenAction.open(new RepositoryProcessLocation(location), false);
                    break block4;
                }
                if (entry instanceof IOObjectEntry) {
                    RepositoryTree.showAsResult((IOObjectEntry)entry);
                    break block4;
                }
                throw new RepositoryException("Cannot open entries of type " + entry.getType() + ".");
            }
            catch (Exception e) {
                SwingTools.showSimpleErrorMessage("while_loading", (Throwable)e, openLocation, e.getMessage());
            }
        }
    }
}

