/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.ApplicationPerspectives;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.InputDialog;
import java.awt.event.ActionEvent;

public class NewPerspectiveAction
extends ResourceAction {
    private static final long serialVersionUID = 5526646387968616318L;
    private final MainFrame mainFrame;

    public NewPerspectiveAction(MainFrame mainFrame) {
        super("new_perspective", new Object[0]);
        this.mainFrame = mainFrame;
        this.setCondition(9, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NewPerspectiveDialog dialog = new NewPerspectiveDialog(this.mainFrame.getPerspectives());
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.mainFrame.getPerspectives().createUserPerspective(dialog.getInputText(), true);
        }
    }

    private static class NewPerspectiveDialog
    extends InputDialog {
        private static final long serialVersionUID = -7106546247629834518L;
        private final ApplicationPerspectives perspectives;
        private boolean ok = false;

        private NewPerspectiveDialog(ApplicationPerspectives perspectives) {
            super("new_perspective");
            this.perspectives = perspectives;
        }

        public boolean isOk() {
            return this.ok;
        }

        @Override
        protected void ok() {
            if (this.perspectives.isValidName(this.getInputText())) {
                this.ok = true;
                this.dispose();
            } else {
                SwingTools.showVerySimpleErrorMessage("invalid_perspective_name", new Object[0]);
            }
        }
    }
}

