/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.gui.templates.NewBuildingBlockDialog;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UnknownParameterInformation;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class NewBuildingBlockAction
extends ResourceAction {
    private static final long serialVersionUID = 3466426013029085115L;
    private final Actions actions;

    public NewBuildingBlockAction(Actions actions) {
        super(true, "new_building_block", new Object[0]);
        this.setCondition(1, 1);
        this.actions = actions;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Operator selectedOperator = this.actions.getSelectedOperator();
        if (selectedOperator != null) {
            NewBuildingBlockDialog dialog = new NewBuildingBlockDialog();
            dialog.setVisible(true);
            if (dialog.isOk()) {
                try {
                    BuildingBlock buildingBlock = dialog.getSelectedBuildingBlock();
                    if (buildingBlock != null) {
                        String xmlDescription = buildingBlock.getXML();
                        try {
                            InputSource source = new InputSource(new StringReader(xmlDescription));
                            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                            Element element = document.getDocumentElement();
                            Operator operator = Operator.createFromXML(element, this.actions.getProcess(), new LinkedList<UnknownParameterInformation>(), null, XMLImporter.CURRENT_VERSION);
                            operator.setUserDescription(buildingBlock.getDescription());
                            this.actions.insert(Collections.singletonList(operator));
                        }
                        catch (Exception ex) {
                            SwingTools.showSimpleErrorMessage("cannot_instantiate_building_block", (Throwable)ex, buildingBlock.getName());
                        }
                    }
                }
                catch (Exception ex) {
                    SwingTools.showSimpleErrorMessage("cannot_instantiate_building_block", (Throwable)ex, new Object[0]);
                }
            }
        }
    }
}

