/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import java.awt.event.ActionEvent;

public class ConnectPortToRepositoryAction
extends ResourceAction {
    private Port port;
    private static final long serialVersionUID = 1L;

    public ConnectPortToRepositoryAction(Port port) {
        super("connect_port_to_repository_location", port.getName());
        this.port = port;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String location;
        Process process = this.port.getPorts().getOwner().getOperator().getProcess();
        RepositoryLocation processLoc = process.getRepositoryLocation();
        if (processLoc != null) {
            processLoc = processLoc.parent();
        }
        if ((location = RepositoryLocationChooser.selectLocation(processLoc, null, RapidMinerGUI.getMainFrame(), true, false)) != null) {
            if (this.port instanceof OutputPort) {
                int index = process.getRootOperator().getSubprocess(0).getInnerSources().getAllPorts().indexOf(this.port);
                if (index != -1) {
                    process.getContext().setInputRepositoryLocation(index, location);
                }
            } else {
                int index = process.getRootOperator().getSubprocess(0).getInnerSinks().getAllPorts().indexOf(this.port);
                if (index != -1) {
                    process.getContext().setOutputRepositoryLocation(index, location);
                }
            }
        }
    }
}

