/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.EditBlockingProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import java.awt.event.ActionEvent;

public class AutoWireAction
extends ResourceAction {
    private static final long serialVersionUID = -4597160351305617508L;
    private final CompatibilityLevel level;
    private final boolean keepConnections;
    private final boolean recursive;
    private final MainFrame mainFrame;

    public AutoWireAction(MainFrame mainFrame, String key, CompatibilityLevel level, boolean recursive, boolean keepConnections) {
        super(true, key, new Object[0]);
        this.setCondition(0, 1);
        this.mainFrame = mainFrame;
        this.recursive = recursive;
        this.level = level;
        this.keepConnections = keepConnections;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new EditBlockingProgressThread("auto_wiring"){

            @Override
            public void execute() {
                Operator op = AutoWireAction.this.mainFrame.getFirstSelectedOperator();
                OperatorChain chain = op instanceof OperatorChain ? (OperatorChain)op : op.getParent();
                if (chain != null) {
                    this.getProgressListener().setTotal(chain.getSubprocesses().size() + 1);
                    int i = 1;
                    for (ExecutionUnit unit : chain.getSubprocesses()) {
                        this.getProgressListener().setCompleted(i++);
                        unit.autoWire(AutoWireAction.this.level, AutoWireAction.this.keepConnections, AutoWireAction.this.recursive);
                    }
                    this.getProgressListener().complete();
                }
            }
        }.start();
    }
}

