/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.gui.ConditionalAction;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.actions.NewBuildingBlockAction;
import com.rapidminer.gui.actions.NewOperatorAction;
import com.rapidminer.gui.dnd.OperatorTransferHandler;
import com.rapidminer.gui.flow.AutoWireThread;
import com.rapidminer.gui.operatormenu.OperatorMenu;
import com.rapidminer.gui.operatortree.actions.DeleteOperatorAction;
import com.rapidminer.gui.operatortree.actions.InfoOperatorAction;
import com.rapidminer.gui.operatortree.actions.SaveBuildingBlockAction;
import com.rapidminer.gui.operatortree.actions.ToggleActivationItem;
import com.rapidminer.gui.operatortree.actions.ToggleAllBreakpointsItem;
import com.rapidminer.gui.operatortree.actions.ToggleBreakpointItem;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.templates.NewBuildingBlockMenu;
import com.rapidminer.gui.tools.EditBlockingProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ProcessRootOperator;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class Actions
implements ProcessEditor {
    public final Action INFO_OPERATOR_ACTION = new InfoOperatorAction(){
        private static final long serialVersionUID = 6758272768665592429L;

        @Override
        protected Operator getOperator() {
            return Actions.this.getFirstSelectedOperator();
        }
    };
    public final ToggleActivationItem TOGGLE_ACTIVATION_ITEM = new ToggleActivationItem(this);
    public final Action RENAME_OPERATOR_ACTION = new ResourceAction(true, "rename_in_processrenderer", new Object[0]){
        private static final long serialVersionUID = -3104160320178045540L;
        {
            this.setCondition(0, 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Operator operator = Actions.this.getFirstSelectedOperator();
            String name = SwingTools.showInputDialog("rename_operator", operator.getName(), new Object[0]);
            if (name != null && name.length() > 0) {
                operator.rename(name);
            }
        }
    };
    public final Action NEW_OPERATOR_ACTION = new NewOperatorAction(this);
    public final Action NEW_BUILDING_BLOCK_ACTION = new NewBuildingBlockAction(this);
    public final Action SAVE_BUILDING_BLOCK_ACTION = new SaveBuildingBlockAction(this);
    public final Action DELETE_OPERATOR_ACTION = new DeleteOperatorAction(this);
    public final ToggleBreakpointItem[] TOGGLE_BREAKPOINT = new ToggleBreakpointItem[]{new ToggleBreakpointItem(this, 0), new ToggleBreakpointItem(this, 1)};
    public final transient ToggleAllBreakpointsItem TOGGLE_ALL_BREAKPOINTS = new ToggleAllBreakpointsItem(this);
    public final transient Action MAKE_DIRTY_ACTION = new ResourceAction(true, "make_dirty", new Object[0]){
        private static final long serialVersionUID = -1260942717363137733L;
        {
            this.setCondition(0, 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Operator selectedOperator : new LinkedList<Operator>(Actions.this.getSelectedOperators())) {
                selectedOperator.makeDirty();
            }
        }
    };
    private List<Operator> selection;
    private Process process;
    private final MainFrame mainFrame;
    private final BreakpointListener breakpointListener = new BreakpointListener(){

        @Override
        public void breakpointReached(Process process, Operator op, IOContainer iocontainer, int location) {
            Actions.this.enableActions();
        }

        @Override
        public void resume() {
            Actions.this.enableActions();
        }
    };
    private final ProcessListener processListener = new ProcessListener(){

        @Override
        public void processEnded(Process process) {
            Actions.this.enableActions();
            ((Actions)Actions.this).mainFrame.RUN_ACTION.setState(process.getProcessState());
        }

        @Override
        public void processFinishedOperator(Process process, Operator op) {
        }

        @Override
        public void processStartedOperator(Process process, Operator op) {
        }

        @Override
        public void processStarts(Process process) {
            Actions.this.enableActions();
        }
    };

    public Actions(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void addToOperatorPopupMenu(JPopupMenu menu, Action renameAction) {
        boolean singleSelection;
        Operator op = this.getFirstSelectedOperator();
        boolean bl = singleSelection = this.getSelectedOperators().size() == 1;
        if (op != null && !singleSelection && !(op instanceof ProcessRootOperator) && op.getParent() != null && op.getParent().isEnabled()) {
            menu.add(this.TOGGLE_ACTIVATION_ITEM.createMultipleActivationItem());
        }
        if (op != null && singleSelection) {
            menu.add(this.INFO_OPERATOR_ACTION);
            if (!(op instanceof ProcessRootOperator) && op.getParent() != null && op.getParent().isEnabled()) {
                menu.add(this.TOGGLE_ACTIVATION_ITEM.createMenuItem());
            }
            if (renameAction != null) {
                menu.add(renameAction);
            } else {
                menu.add(this.RENAME_OPERATOR_ACTION);
            }
            menu.addSeparator();
        }
        if (op != null && op instanceof OperatorChain) {
            menu.add(OperatorMenu.NEW_OPERATOR_MENU);
        }
        if (op != null && !(op instanceof ProcessRootOperator) && singleSelection) {
            if (op instanceof OperatorChain && ((OperatorChain)op).getAllInnerOperators().size() > 0) {
                menu.add(OperatorMenu.REPLACE_OPERATORCHAIN_MENU);
            } else {
                menu.add(OperatorMenu.REPLACE_OPERATOR_MENU);
            }
        }
        if (op != null && op instanceof OperatorChain) {
            final NewBuildingBlockMenu buildingBlockMenu = new NewBuildingBlockMenu(this);
            menu.add(buildingBlockMenu);
            buildingBlockMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    buildingBlockMenu.addAllMenuItems();
                }
            });
        }
        if (op != null && !(op instanceof ProcessRootOperator)) {
            menu.add(this.SAVE_BUILDING_BLOCK_ACTION);
        }
        menu.addSeparator();
        OperatorTransferHandler.installMenuItems(menu);
        menu.add(this.DELETE_OPERATOR_ACTION);
        menu.addSeparator();
        if (op != null && singleSelection) {
            for (int i = 0; i < this.TOGGLE_BREAKPOINT.length; ++i) {
                menu.add(this.TOGGLE_BREAKPOINT[i].createMenuItem());
            }
        }
        menu.add(this.TOGGLE_ALL_BREAKPOINTS.createMenuItem());
    }

    public Operator getFirstSelectedOperator() {
        if (this.selection != null && !this.selection.isEmpty()) {
            return this.selection.get(0);
        }
        return null;
    }

    public List<Operator> getSelectedOperators() {
        return this.selection;
    }

    public void enableActions() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enableActionsNow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Actions.this.enableActionsNow();
                }
            });
        }
        this.updateCheckboxStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableActionsNow() {
        Process process = this.process;
        synchronized (process) {
            int processState;
            boolean[] currentStates = new boolean[10];
            Operator op = this.getFirstSelectedOperator();
            if (op != null) {
                currentStates[0] = true;
                if (op instanceof OperatorChain) {
                    currentStates[1] = true;
                }
                if (op.getParent() == null) {
                    currentStates[2] = true;
                } else {
                    currentStates[7] = op.getParent().isEnabled();
                    if (op.getExecutionUnit().getNumberOfOperators() > 1) {
                        currentStates[3] = true;
                    }
                }
            }
            currentStates[4] = (processState = this.process.getProcessState()) == 0;
            currentStates[5] = processState == 1;
            currentStates[6] = processState == 2;
            currentStates[9] = EditBlockingProgressThread.isEditing();
            ConditionalAction.updateAll(currentStates);
            this.updateCheckboxStates();
        }
    }

    public void delete() {
        OperatorChain parent = null;
        for (Operator selectedOperator : new LinkedList<Operator>(this.getSelectedOperators())) {
            if (parent == null) {
                parent = selectedOperator.getParent();
            }
            selectedOperator.remove();
        }
        this.mainFrame.selectOperator(parent);
    }

    public void insert(List<Operator> newOperators) {
        Operator selectedNode = this.getSelectedOperator();
        if (selectedNode == null) {
            SwingTools.showVerySimpleErrorMessage("cannot_insert_operator", new Object[0]);
            return;
        }
        if (selectedNode instanceof OperatorChain && ((OperatorChain)selectedNode).getNumberOfSubprocesses() == 1) {
            for (Operator newOperator : newOperators) {
                ((OperatorChain)selectedNode).getSubprocess(0).addOperator(newOperator);
            }
        } else {
            int i = 0;
            Operator selectedOperator = selectedNode;
            ExecutionUnit process = selectedOperator.getExecutionUnit();
            int parentIndex = process.getOperators().indexOf(selectedOperator) + 1;
            for (Operator newOperator : newOperators) {
                process.addOperator(newOperator, parentIndex + i);
                ++i;
            }
        }
        AutoWireThread.autoWireInBackground(newOperators, true);
        this.mainFrame.selectOperators(newOperators);
    }

    public Operator getSelectedOperator() {
        return this.getFirstSelectedOperator();
    }

    public Operator getRootOperator() {
        if (this.process != null) {
            return this.process.getRootOperator();
        }
        return null;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void processChanged(Process process) {
        if (this.process != process) {
            if (this.process != null) {
                this.process.removeBreakpointListener(this.breakpointListener);
                this.process.getRootOperator().removeProcessListener(this.processListener);
            }
            this.process = process;
            this.enableActions();
            if (this.process != null) {
                this.process.addBreakpointListener(this.breakpointListener);
                this.process.getRootOperator().addProcessListener(this.processListener);
            }
        }
    }

    @Override
    public void processUpdated(Process process) {
        this.enableActions();
    }

    @Override
    public void setSelection(List<Operator> selection) {
        this.selection = selection;
        this.enableActions();
    }

    private void updateCheckboxStates() {
        Operator op = this.getSelectedOperator();
        if (op != null) {
            for (int pos = 0; pos < this.TOGGLE_BREAKPOINT.length; ++pos) {
                this.TOGGLE_BREAKPOINT[pos].setSelected(op.hasBreakpoint(pos));
            }
            this.TOGGLE_ACTIVATION_ITEM.setSelected(op.isEnabled());
        }
    }
}

