/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.NoBugError;
import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.awt.Toolkit;
import java.util.logging.Level;

public class ProcessThread
extends Thread {
    private Process process;

    public ProcessThread(Process process) {
        super("ProcessThread");
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            IOContainer results = this.process.run();
            ProcessThread.beep("success");
            this.process.getRootOperator().sendEmail(results, null);
            RapidMinerGUI.getMainFrame().processEnded(this.process, results);
        }
        catch (ProcessStoppedException ex) {
            this.process.getLogger().info(ex.getMessage());
        }
        catch (Throwable e) {
            if (!(e instanceof OperatorException)) {
                UsageStatistics.getInstance().count(this.process.getCurrentOperator(), OperatorStatisticsValue.FAILURE);
                UsageStatistics.getInstance().count(this.process.getCurrentOperator(), OperatorStatisticsValue.RUNTIME_EXCEPTION);
            }
            ProcessThread.beep("error");
            String debugProperty = System.getProperty("rapidminer.general.debugmode");
            boolean debugMode = Tools.booleanValue(debugProperty, false);
            String message = e.getMessage();
            if (!debugMode && e instanceof RuntimeException) {
                message = e.getMessage() != null ? "operator cannot be executed (" + e.getMessage() + "). Check the log messages..." : "operator cannot be executed. Check the log messages...";
            }
            this.process.getLogger().log(Level.SEVERE, "Process failed: " + message, e);
            this.process.getLogger().log(Level.SEVERE, "Here: " + this.process.getRootOperator().createMarkedProcessTree(10, "==>", this.process.getCurrentOperator()));
            try {
                this.process.getRootOperator().sendEmail(null, e);
            }
            catch (UndefinedParameterError ex) {
                this.process.getLogger().log(Level.WARNING, "Problems during sending result mail: " + ex.getMessage(), ex);
            }
            if (e instanceof OutOfMemoryError) {
                SwingTools.showVerySimpleErrorMessage("proc_failed_out_of_mem", new Object[0]);
            } else if (e instanceof NoBugError) {
                if (e instanceof UserError) {
                    UserError userError = (UserError)e;
                    SwingTools.showFinalErrorMessage("process_failed_user_error", e, debugMode, new Object[]{userError.getMessage(), userError.getDetails()});
                } else {
                    SwingTools.showFinalErrorMessage("process_failed_simple", e, debugMode, new Object[0]);
                }
            } else if (debugMode) {
                SwingTools.showFinalErrorMessage("process_failed_simple", e, true, new Object[0]);
            } else if (e instanceof NullPointerException || e instanceof ArrayIndexOutOfBoundsException) {
                LogService.getRoot().log(Level.SEVERE, e.toString(), e);
                SwingTools.showVerySimpleErrorMessage("proc_failed_without_obv_reason", new Object[0]);
            } else {
                SwingTools.showSimpleErrorMessage("process_failed_simple", e, false, new Object[0]);
            }
            RapidMinerGUI.getMainFrame().processEnded(this.process, null);
        }
        finally {
            if (this.process.getProcessState() != 0) {
                this.process.stop();
            }
            this.process = null;
        }
    }

    public static void beep(String reason) {
        if (Tools.booleanValue(System.getProperty("rapidminer.gui.beep." + reason), false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void stopProcess() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    public void pauseProcess() {
        if (this.process != null) {
            this.process.pause();
        }
    }

    @Override
    public String toString() {
        return "ProcessThread (" + this.process.getProcessLocation() + ")";
    }
}

