/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.gui.ApplicationPerspectives;
import com.rapidminer.gui.Perspective;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.ws.WSDesktop;
import com.vlsolutions.swing.docking.ws.WSDockKey;

public class Perspectives
extends ApplicationPerspectives {
    public Perspectives(DockingContext context) {
        super(context);
    }

    @Override
    protected void makePredefined() {
        this.addPerspective("design", false);
        this.restoreDefault("design");
        this.addPerspective("result", false);
        this.restoreDefault("result");
        this.addPerspective("welcome", false);
        this.restoreDefault("welcome");
    }

    @Override
    protected void restoreDefault(String perspectiveName) {
        WSDockKey processPanelKey = new WSDockKey("process_panel");
        WSDockKey propertyTableKey = new WSDockKey("property_editor");
        WSDockKey messageViewerKey = new WSDockKey("log_viewer");
        WSDockKey resultsKey = new WSDockKey("result");
        WSDockKey repositoryKey = new WSDockKey("repository_browser");
        WSDockKey newOperatorEditorKey = new WSDockKey("new_operator");
        WSDockKey errorTableKey = new WSDockKey("error_table");
        WSDockKey xmlEditorKey = new WSDockKey("xml_editor");
        WSDockKey commentEditorKey = new WSDockKey("comment_editor");
        WSDockKey operatorHelpKey = new WSDockKey("operator_help");
        WSDockKey welcomeKey = new WSDockKey("welcome");
        WSDockKey overviewKey = new WSDockKey("overview");
        if ("design".equals(perspectiveName)) {
            Perspective designPerspective = this.getPerspective("design");
            WSDesktop designDesktop = designPerspective.getWorkspace().getDesktop(0);
            designDesktop.clear();
            designDesktop.addDockable(processPanelKey);
            designDesktop.split(processPanelKey, propertyTableKey, DockingConstants.SPLIT_RIGHT, 0.8);
            designDesktop.split(propertyTableKey, operatorHelpKey, DockingConstants.SPLIT_BOTTOM, 0.66);
            designDesktop.createTab(operatorHelpKey, commentEditorKey, 1);
            designDesktop.split(processPanelKey, overviewKey, DockingConstants.SPLIT_LEFT, 0.25);
            designDesktop.split(overviewKey, newOperatorEditorKey, DockingConstants.SPLIT_BOTTOM, 0.2);
            designDesktop.createTab(newOperatorEditorKey, repositoryKey, 1);
            designDesktop.split(processPanelKey, errorTableKey, DockingConstants.SPLIT_BOTTOM, 0.8);
            designDesktop.createTab(errorTableKey, messageViewerKey, 1);
            designDesktop.createTab(processPanelKey, xmlEditorKey, 1);
        } else if ("result".equals(perspectiveName)) {
            Perspective resultPerspective = this.getPerspective("result");
            WSDesktop resultsDesktop = resultPerspective.getWorkspace().getDesktop(0);
            resultsDesktop.clear();
            resultsDesktop.addDockable(resultsKey);
            resultsDesktop.split(resultsKey, messageViewerKey, DockingConstants.SPLIT_BOTTOM, 0.8);
            resultsDesktop.split(messageViewerKey, new WSDockKey("system_monitor"), DockingConstants.SPLIT_RIGHT, 0.8);
            resultsDesktop.split(resultsKey, repositoryKey, DockingConstants.SPLIT_RIGHT, 0.8);
        } else if ("welcome".equals(perspectiveName)) {
            Perspective welcomePerspective = this.getPerspective("welcome");
            WSDesktop welcomeDesktop = welcomePerspective.getWorkspace().getDesktop(0);
            welcomeDesktop.clear();
            welcomeDesktop.addDockable(welcomeKey);
        } else {
            throw new IllegalArgumentException("Not a predevined perspective: " + perspectiveName);
        }
    }
}

