/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.gui.ApplicationPerspectives;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.ws.Workspace;
import com.vlsolutions.swing.docking.ws.WorkspaceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;

public class Perspective {
    private final String name;
    private final Workspace workspace = new Workspace();
    private boolean userDefined = false;
    private final ApplicationPerspectives owner;

    public Perspective(ApplicationPerspectives owner, String name) {
        this.name = name;
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void store(DockingContext dockingContext) {
        try {
            this.workspace.loadFrom(dockingContext);
        }
        catch (WorkspaceException e) {
            LogService.getGlobal().logError("Cannot save workspace: " + e.toString());
            e.printStackTrace();
        }
    }

    protected void apply(DockingContext dockingContext) {
        try {
            this.workspace.apply(dockingContext);
        }
        catch (WorkspaceException e) {
            LogService.getGlobal().logError("Cannot apply workspace: " + e.toString());
            e.printStackTrace();
        }
    }

    File getFile() {
        return ParameterService.getUserConfigFile("vlperspective-" + (this.isUserDefined() ? "user-" : "predefined-") + this.name + ".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        File file = this.getFile();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.workspace.writeXML((OutputStream)out);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot save perspective to " + file + ": " + e, e);
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        LogService.getRoot().fine("Loading perspective: " + this.getName());
        File file = this.getFile();
        if (!file.exists()) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.workspace.readXML((InputStream)in);
        }
        catch (Exception e) {
            if (!this.userDefined) {
                LogService.getRoot().log(Level.WARNING, "Cannot read perspective from " + file + ": " + e + ". Restoring default.", e);
                this.owner.restoreDefault(this.getName());
            } else {
                LogService.getRoot().log(Level.WARNING, "Cannot read perspective from " + file + ": " + e + ". Clearing perspective.", e);
                this.workspace.clear();
            }
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setUserDefined(boolean b) {
        this.userDefined = b;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void delete() {
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
        }
    }
}

