/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.Process;
import com.rapidminer.gui.OperatorDocViewer;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.operatormenu.OperatorMenu;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.documentation.OperatorDocumentation;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class OperatorDocEditor
extends OperatorDocViewer {
    private static final long serialVersionUID = 3341472230093161784L;
    private static final String[] EDIT_ACTION_NAMES = new String[]{"font-bold", "font-italic", "InsertOrderedList", "InsertOrderedListItem", "InsertUnorderedList", "InsertUnorderedListItem"};
    private final List<Action> editActions = new LinkedList<Action>();
    private final Action clearAction = new ResourceAction(true, "operatorhelp.clear", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            OperatorDocEditor.this.getEditor().setText("<html><head></head><body></body></html>");
            OperatorDocEditor.this.getEditor().requestFocus();
        }
    };
    private final Action applyChanges = new ResourceAction(true, "operatorhelp.apply_changes", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OperatorDocEditor.this.editWhat != null) {
                String strippedHtml = OperatorDocEditor.stripHtmlFrame(OperatorDocEditor.this.getEditor().getText());
                if (OperatorDocEditor.this.editWhat.equals("edit_description")) {
                    OperatorDocumentation doc = OperatorDocEditor.this.getDisplayedOperator().getOperatorDescription().getOperatorDocumentation();
                    if (doc != null) {
                        doc.setDocumentation(strippedHtml);
                    }
                } else if (OperatorDocEditor.this.editWhat.equals("edit_synopsis")) {
                    OperatorDocumentation doc = OperatorDocEditor.this.getDisplayedOperator().getOperatorDescription().getOperatorDocumentation();
                    if (doc != null) {
                        doc.setSynopsis(strippedHtml);
                    }
                } else if (OperatorDocEditor.this.editWhat.startsWith("edit_parameter_")) {
                    // empty if block
                }
                OperatorDocEditor.this.setEditEnabled(false);
                OperatorDocEditor.this.showHelptext();
            }
        }
    };
    private final Action discardChanges = new ResourceAction(true, "operatorhelp.discard_changes", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OperatorDocEditor.this.editWhat != null) {
                OperatorDocEditor.this.setEditEnabled(false);
                OperatorDocEditor.this.showHelptext();
            }
        }
    };
    private final Action addExample = new ResourceAction(true, "operatorhelp.add_example", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Process current = RapidMinerGUI.getMainFrame().getProcess();
            OperatorDocEditor.this.getDisplayedOperator().getOperatorDescription().getOperatorDocumentation().addExample(current, current.getRootOperator().getUserDescription());
            OperatorDocEditor.this.showHelptext();
        }
    };
    private final Action saveDocumentation = new ResourceAction(true, "operatorhelp.save_docs", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            OperatorDocEditor.this.getDisplayedOperator().getOperatorDescription().getOperatorDocumentation().getBundle().save();
        }
    };
    private final Action insertOpLink = new ResourceAction(true, "operatorhelp.insert_operator_link", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            OperatorMenu menu = new OperatorMenu("test", false){
                private static final long serialVersionUID = 1L;

                @Override
                public void performAction(OperatorDescription description) {
                    try {
                        String link = "<a href=\"rm://opdoc/" + description.getKey() + "\">" + description.getName() + "</a>";
                        ((HTMLEditorKit)OperatorDocEditor.this.getEditor().getEditorKit()).insertHTML((HTMLDocument)OperatorDocEditor.this.getEditor().getDocument(), OperatorDocEditor.this.getEditor().getCaretPosition(), link, 0, 0, null);
                    }
                    catch (Exception e) {
                        LogService.getRoot().log(Level.WARNING, "Error inserting link: " + e.toString(), e);
                    }
                }
            };
            menu.getPopupMenu().show(OperatorDocEditor.this.insertOpLinkButton, 0, OperatorDocEditor.this.insertOpLinkButton.getHeight());
        }
    };
    private final JButton insertOpLinkButton = new JButton(this.insertOpLink);
    private String editWhat;
    private boolean isEditing;

    public OperatorDocEditor() {
        this.insertOpLinkButton.setText(null);
        this.isEditing = false;
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        toolBar.add(this.saveDocumentation);
        toolBar.add(this.addExample);
        toolBar.addSeparator();
        toolBar.add(this.applyChanges);
        toolBar.add(this.discardChanges);
        toolBar.addSeparator();
        toolBar.add(this.clearAction);
        toolBar.add(this.insertOpLinkButton);
        HashMap<String, Action> actionMap = new HashMap<String, Action>();
        for (Action action : this.getEditor().getActions()) {
            actionMap.put((String)action.getValue("Name"), action);
        }
        for (String editActionName : EDIT_ACTION_NAMES) {
            final Action editAction = (Action)actionMap.get(editActionName);
            this.editActions.add(new ResourceAction(true, "operatorhelp." + (String)editAction.getValue("Name"), new Object[0]){
                private static final long serialVersionUID = -8259341536856732400L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    editAction.actionPerformed(e);
                }
            });
        }
        for (Action action : this.editActions) {
            toolBar.add(action);
        }
        this.add((Component)toolBar, "North");
        this.setEditEnabled(false);
        this.getEditor().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e.getDescription().startsWith("edit_")) {
                        OperatorDocEditor.this.edit(e.getDescription());
                    } else if (e.getDescription().startsWith("delete_example_")) {
                        int index = Integer.parseInt(e.getDescription().substring("delete_example_".length()));
                        OperatorDocEditor.this.getDisplayedOperator().getOperatorDescription().getOperatorDocumentation().removeExample(index);
                        OperatorDocEditor.this.showHelptext();
                    }
                }
            }
        });
    }

    private void setEditEnabled(boolean enabled) {
        this.isEditing = enabled;
        this.getEditor().getCaret().setVisible(enabled);
        this.applyChanges.setEnabled(enabled);
        this.discardChanges.setEnabled(enabled);
        for (Action action : this.editActions) {
            action.setEnabled(enabled);
        }
    }

    private void edit(String editWhat) {
        this.editWhat = editWhat;
        String initialText = null;
        if (editWhat.equals("edit_description")) {
            initialText = this.getDisplayedOperator().getOperatorDescription().getLongDescriptionHTML();
        } else if (editWhat.equals("edit_synopsis")) {
            initialText = this.getDisplayedOperator().getOperatorDescription().getShortDescription();
        } else if (editWhat.startsWith("edit_parameter_")) {
            String key = editWhat.substring("edit_parameter_".length());
            ParameterType type = this.getDisplayedOperator().getParameters().getParameterType(key);
            if (type != null) {
                initialText = type.getDescription();
            }
        }
        if (initialText != null) {
            if (initialText.startsWith("<html>")) {
                this.getEditor().setText(initialText);
            } else {
                this.getEditor().setText("<html><head></head><body>" + initialText + "</body></html>");
            }
            this.getEditor().setEditable(true);
            this.setEditEnabled(true);
            this.getEditor().requestFocus(true);
            this.getEditor().setCaretPosition(0);
        }
    }

    @Override
    public void setSelection(List<Operator> selection) {
        if (!this.isEditing) {
            super.setSelection(selection);
        }
    }

    @Override
    public void setDisplayedOperator(Operator operator) {
        if (!this.isEditing) {
            super.setDisplayedOperator(operator);
        }
    }

    private static String stripHtmlFrame(String html) {
        int bodyEnd;
        int bodyStart = html.indexOf("<body>");
        if (bodyStart != -1) {
            html = html.substring(bodyStart + "<body>".length());
        }
        if ((bodyEnd = html.lastIndexOf("</body>")) != -1) {
            html = html.substring(0, bodyEnd);
        }
        html = html.replace("\n\n", "</p><p><br>");
        html = html.replace("\n", "");
        if (!(html = html.trim()).startsWith("<p>")) {
            html = "<p>" + html + "</p>";
        }
        return html;
    }
}

