/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.tools.LogService;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class MetaDataUpdateQueue
extends UpdateQueue {
    private final MainFrame mainFrame;

    public MetaDataUpdateQueue(MainFrame mainFrame) {
        super("MetaDataValidation");
        this.mainFrame = mainFrame;
        this.setPriority(1);
    }

    public void validate(final Process process, final boolean force) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                new ProgressThread("validate_process"){

                    @Override
                    public void run() {
                        this.getProgressListener().setTotal(100);
                        this.getProgressListener().setCompleted(10);
                        if (force || ((MetaDataUpdateQueue)MetaDataUpdateQueue.this).mainFrame.VALIDATE_AUTOMATICALLY_ACTION.isSelected()) {
                            process.getRootOperator().checkAll();
                        } else {
                            process.getRootOperator().checkAllExcludingMetaData();
                        }
                        this.getProgressListener().setCompleted(90);
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    MetaDataUpdateQueue.this.mainFrame.fireProcessUpdated();
                                }
                            });
                        }
                        catch (InterruptedException e) {
                        }
                        catch (InvocationTargetException e) {
                            LogService.getRoot().log(Level.WARNING, "While updating process editors: " + e, e);
                        }
                        this.getProgressListener().setCompleted(100);
                        this.getProgressListener().complete();
                    }
                }.startAndWait();
            }
        });
    }
}

