/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapid_i.deployment.update.client.ExtensionDialog;
import com.rapid_i.deployment.update.client.UpdateDialog;
import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.RapidMiner;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.DockableMenu;
import com.rapidminer.gui.MetaDataUpdateQueue;
import com.rapidminer.gui.OperatorDocViewer;
import com.rapidminer.gui.Perspectives;
import com.rapidminer.gui.ProcessThread;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.AboutAction;
import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.actions.AnovaCalculatorAction;
import com.rapidminer.gui.actions.AutoWireAction;
import com.rapidminer.gui.actions.BrowseAction;
import com.rapidminer.gui.actions.CheckForJDBCDriversAction;
import com.rapidminer.gui.actions.ExitAction;
import com.rapidminer.gui.actions.ExportProcessAction;
import com.rapidminer.gui.actions.ExportViewAction;
import com.rapidminer.gui.actions.ImportProcessAction;
import com.rapidminer.gui.actions.ManageBuildingBlocksAction;
import com.rapidminer.gui.actions.ManageTemplatesAction;
import com.rapidminer.gui.actions.NewAction;
import com.rapidminer.gui.actions.NewPerspectiveAction;
import com.rapidminer.gui.actions.OpenAction;
import com.rapidminer.gui.actions.PageSetupAction;
import com.rapidminer.gui.actions.PauseAction;
import com.rapidminer.gui.actions.PrintAction;
import com.rapidminer.gui.actions.PrintPreviewAction;
import com.rapidminer.gui.actions.RedoAction;
import com.rapidminer.gui.actions.RunAction;
import com.rapidminer.gui.actions.RunRemoteAction;
import com.rapidminer.gui.actions.SaveAction;
import com.rapidminer.gui.actions.SaveAsAction;
import com.rapidminer.gui.actions.SaveAsTemplateAction;
import com.rapidminer.gui.actions.SettingsAction;
import com.rapidminer.gui.actions.StopAction;
import com.rapidminer.gui.actions.ToggleAction;
import com.rapidminer.gui.actions.ToggleExpertModeAction;
import com.rapidminer.gui.actions.TutorialAction;
import com.rapidminer.gui.actions.UndoAction;
import com.rapidminer.gui.actions.ValidateAutomaticallyAction;
import com.rapidminer.gui.actions.ValidateProcessAction;
import com.rapidminer.gui.actions.WizardAction;
import com.rapidminer.gui.dialog.ProcessInfoScreen;
import com.rapidminer.gui.dialog.Tutorial;
import com.rapidminer.gui.dialog.UnknownParametersInfoDialog;
import com.rapidminer.gui.docking.RapidDockingToolbar;
import com.rapidminer.gui.flow.ErrorTable;
import com.rapidminer.gui.flow.ProcessPanel;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.operatortree.OperatorTreePanel;
import com.rapidminer.gui.operatortree.actions.CutCopyPasteAction;
import com.rapidminer.gui.operatortree.actions.ToggleBreakpointItem;
import com.rapidminer.gui.processeditor.CommentEditor;
import com.rapidminer.gui.processeditor.NewOperatorEditor;
import com.rapidminer.gui.processeditor.ProcessContextProcessEditor;
import com.rapidminer.gui.processeditor.ProcessEditor;
import com.rapidminer.gui.processeditor.XMLEditor;
import com.rapidminer.gui.processeditor.profiler.ProfilingListener;
import com.rapidminer.gui.processeditor.profiler.ProfilingViewer;
import com.rapidminer.gui.processeditor.results.ResultDisplay;
import com.rapidminer.gui.processeditor.results.ResultDisplayTools;
import com.rapidminer.gui.properties.OperatorPropertyPanel;
import com.rapidminer.gui.templates.SaveAsTemplateDialog;
import com.rapidminer.gui.tools.LoggingViewer;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.SystemMonitor;
import com.rapidminer.gui.tools.WelcomeScreen;
import com.rapidminer.gui.tools.dialogs.ConfirmDialog;
import com.rapidminer.gui.tools.dialogs.DecisionRememberingConfirmDialog;
import com.rapidminer.gui.tools.dialogs.ManageDatabaseConnectionsDialog;
import com.rapidminer.gui.tools.dialogs.ManageDatabaseDriversDialog;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.BlobImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DatabaseImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.access.AccessImportWizard;
import com.rapidminer.operator.DebugMode;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.nio.CSVImportWizard;
import com.rapidminer.operator.nio.ExcelImportWizard;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.repository.gui.RepositoryBrowser;
import com.rapidminer.repository.gui.process.RemoteProcessViewer;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Plugin;
import com.rapidminer.tools.usagestats.UsageStatsTransmissionDialog;
import com.vlsolutions.swing.docking.DockGroup;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.toolbars.ToolBarConstraints;
import com.vlsolutions.swing.toolbars.ToolBarContainer;
import com.vlsolutions.swing.toolbars.ToolBarPanel;
import com.vlsolutions.swing.toolbars.VLToolBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class MainFrame
extends ApplicationFrame
implements WindowListener {
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_MATRIXPLOT_SIZE = "rapidminer.gui.plotter.matrixplot.size";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_ROWS_MAXIMUM = "rapidminer.gui.plotter.rows.maximum";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_CLASSLIMIT = "rapidminer.gui.plotter.legend.classlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MINCOLOR = "rapidminer.gui.plotter.legend.mincolor";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MAXCOLOR = "rapidminer.gui.plotter.legend.maxcolor";
    public static final String PROPERTY_RAPIDMINER_GUI_PLOTTER_COLORS_CLASSLIMIT = "rapidminer.gui.plotter.colors.classlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_UNDOLIST_SIZE = "rapidminer.gui.undolist.size";
    public static final String PROPERTY_RAPIDMINER_GUI_ATTRIBUTEEDITOR_ROWLIMIT = "rapidminer.gui.attributeeditor.rowlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_BEEP_SUCCESS = "rapidminer.gui.beep.success";
    public static final String PROPERTY_RAPIDMINER_GUI_BEEP_ERROR = "rapidminer.gui.beep.error";
    public static final String PROPERTY_RAPIDMINER_GUI_BEEP_BREAKPOINT = "rapidminer.gui.beep.breakpoint";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_ROWLIMIT = "rapidminer.gui.messageviewer.rowlimit";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_NOTES = "rapidminer.gui.messageviewer.highlight.notes";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_WARNINGS = "rapidminer.gui.messageviewer.highlight.warnings";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_ERRORS = "rapidminer.gui.messageviewer.highlight.errors";
    public static final String PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_LOGSERVICE = "rapidminer.gui.messageviewer.highlight.logservice";
    public static final String PROPERTY_RAPIDMINER_GUI_PROCESSINFO_SHOW = "rapidminer.gui.processinfo.show";
    public static final String PROPERTY_RAPIDMINER_GUI_SAVE_BEFORE_RUN = "rapidminer.gui.save_before_run";
    public static final String PROPERTY_RAPIDMINER_GUI_SAVE_ON_PROCESS_CREATION = "rapidminer.gui.save_on_process_creation";
    public static final String PROPERTY_RAPIDMINER_GUI_AUTO_SWITCH_TO_RESULTVIEW = "rapidminer.gui.auto_switch_to_resultview";
    public static final String PROPERTY_RAPIDMINER_GUI_RESULT_DISPLAY_TYPE = "rapidminer.gui.result_display_type";
    public static final String PROPERTY_RAPIDMINER_GUI_LOG_LEVEL = "rapidminer.gui.log_level";
    private static final long serialVersionUID = -1602076945350148969L;
    public static final String TITLE = "RapidMiner";
    public static final int EDIT_MODE = 0;
    public static final int RESULTS_MODE = 1;
    public static final int WELCOME_MODE = 2;
    public final transient Action AUTO_WIRE = new AutoWireAction(this, "wire", CompatibilityLevel.PRE_VERSION_5, false, true);
    public final transient Action AUTO_WIRE_RECURSIVELY = new AutoWireAction(this, "wire_recursive", CompatibilityLevel.PRE_VERSION_5, true, true);
    public final transient Action REWIRE = new AutoWireAction(this, "rewire", CompatibilityLevel.PRE_VERSION_5, false, false);
    public final transient Action REWIRE_RECURSIVELY = new AutoWireAction(this, "rewire_recursive", CompatibilityLevel.PRE_VERSION_5, true, false);
    public final transient Action NEW_ACTION = new NewAction(this);
    public final transient Action OPEN_ACTION = new OpenAction();
    public final transient SaveAction SAVE_ACTION = new SaveAction();
    public final transient Action SAVE_AS_ACTION = new SaveAsAction();
    public final transient Action SAVE_AS_TEMPLATE_ACTION = new SaveAsTemplateAction(this);
    public final transient Action MANAGE_TEMPLATES_ACTION = new ManageTemplatesAction();
    public final transient Action MANAGE_BUILDING_BLOCKS_ACTION = new ManageBuildingBlocksAction(this);
    public final transient Action PRINT_ACTION = new PrintAction(this, "all");
    public final transient Action PRINT_PREVIEW_ACTION = new PrintPreviewAction(this, "all");
    public final transient Action PAGE_SETUP_ACTION = new PageSetupAction();
    public final transient Action IMPORT_CSV_FILE_ACTION = new ResourceAction("import_csv_file", new Object[0]){
        private static final long serialVersionUID = 4632580631996166900L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                CSVImportWizard wizard = new CSVImportWizard();
                wizard.setVisible(true);
            }
            catch (OperatorException e1) {
                throw new RuntimeException("Failed to create wizard.", e1);
            }
        }
    };
    public final transient Action IMPORT_EXCEL_FILE_ACTION = new ResourceAction("import_excel_sheet", new Object[0]){
        private static final long serialVersionUID = 975782163819088729L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ExcelImportWizard wizard = new ExcelImportWizard();
                wizard.setVisible(true);
            }
            catch (OperatorException e1) {
                throw new RuntimeException("Failed to create wizard.", e1);
            }
        }
    };
    public final transient Action IMPORT_ACCESS_FILE_ACTION = new ResourceAction("import_access_table", new Object[0]){
        private static final long serialVersionUID = 3725652002686421768L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AccessImportWizard wizard = new AccessImportWizard("import_access_table", new Object[0]);
                wizard.setVisible(true);
            }
            catch (SQLException e1) {
                SwingTools.showSimpleErrorMessage("db_connection_failed_simple", (Throwable)e1, e1.getMessage());
            }
        }
    };
    public final transient Action IMPORT_DATABASE_TABLE_ACTION = new ResourceAction("import_database_table", new Object[0]){
        private static final long serialVersionUID = 3725652002686421768L;

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DatabaseImportWizard wizard = new DatabaseImportWizard("import_database_table", new Object[0]);
                wizard.setVisible(true);
            }
            catch (SQLException e1) {
                SwingTools.showSimpleErrorMessage("db_connection_failed_simple", (Throwable)e1, e1.getMessage());
            }
        }
    };
    public final transient Action IMPORT_PROCESS_ACTION = new ImportProcessAction();
    public final transient Action EXPORT_PROCESS_ACTION = new ExportProcessAction();
    public final transient Action EXPORT_ACTION = new ExportViewAction(this, "all");
    public final transient Action EXIT_ACTION = new ExitAction(this);
    public final transient RunAction RUN_ACTION = new RunAction(this);
    public final transient Action PAUSE_ACTION = new PauseAction(this);
    public final transient Action STOP_ACTION = new StopAction(this);
    public final transient Action RUN_REMOTE_ACTION = new RunRemoteAction();
    public final transient Action VALIDATE_ACTION = new ValidateProcessAction(this);
    public final transient ToggleAction VALIDATE_AUTOMATICALLY_ACTION = new ValidateAutomaticallyAction();
    public final transient Action OPEN_TEMPLATE_ACTION = new WizardAction(this);
    public final transient Action NEW_PERSPECTIVE_ACTION = new NewPerspectiveAction(this);
    public final transient Action SETTINGS_ACTION = new SettingsAction();
    public final transient ToggleAction TOGGLE_EXPERT_MODE_ACTION = new ToggleExpertModeAction(this);
    public final transient Action TUTORIAL_ACTION = new TutorialAction(this);
    public final transient Action UNDO_ACTION = new UndoAction(this);
    public final transient Action REDO_ACTION = new RedoAction(this);
    public final transient Action ANOVA_CALCULATOR_ACTION = new AnovaCalculatorAction();
    public final transient Action CHECK_FOR_JDBC_DRIVERS_ACTION = new CheckForJDBCDriversAction();
    public final transient Action MANAGE_DB_CONNECTIONS_ACTION = new ResourceAction(true, "manage_db_connections", new Object[0]){
        private static final long serialVersionUID = 2457587046500212869L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ManageDatabaseConnectionsDialog dialog = new ManageDatabaseConnectionsDialog();
            dialog.setVisible(true);
        }
    };
    public static final DockGroup DOCK_GROUP_ROOT;
    public static final DockGroup DOCK_GROUP_RESULTS;
    private final DockingContext dockingContext = new DockingContext();
    private final DockingDesktop dockingDesktop = new DockingDesktop("mainDesktop", this.dockingContext);
    private final Actions actions = new Actions(this);
    private final WelcomeScreen welcomeScreen = new WelcomeScreen(this);
    private final ResultDisplay resultDisplay = ResultDisplayTools.makeResultDisplay();
    private final LoggingViewer messageViewer = new LoggingViewer();
    private final SystemMonitor systemMonitor = new SystemMonitor();
    private final OperatorDocViewer operatorDocViewer = OperatorDocViewer.instantiate();
    private final OperatorTreePanel operatorTree = new OperatorTreePanel(this);
    private final ErrorTable errorTable = new ErrorTable(this);
    private final OperatorPropertyPanel propertyPanel = new OperatorPropertyPanel(this);
    private final XMLEditor xmlEditor = new XMLEditor(this);
    private final CommentEditor commentEditor = new CommentEditor();
    private final ProcessContextProcessEditor processContextEditor = new ProcessContextProcessEditor();
    private final NewOperatorEditor newOperatorEditor = new NewOperatorEditor();
    private final ProcessPanel processPanel = new ProcessPanel(this);
    private final RepositoryBrowser repositoryBrowser = new RepositoryBrowser();
    private final RemoteProcessViewer remoteProcessViewer = new RemoteProcessViewer();
    private final ProfilingListener profilingListener = new ProfilingListener();
    private final ProfilingViewer profilingViewer = new ProfilingViewer(this.profilingListener);
    private final Perspectives perspectives = new Perspectives(this.dockingContext);
    private final EventListenerList processEditors = new EventListenerList();
    private List<Operator> selectedOperators = Collections.emptyList();
    private boolean changed = false;
    private boolean tutorialMode = false;
    private int undoIndex;
    private final JMenuBar menuBar;
    private final JMenu fileMenu;
    private final JMenu editMenu;
    private final JMenu processMenu;
    private final JMenu toolsMenu;
    private final JMenu viewMenu;
    private final JMenu helpMenu;
    private final JMenu recentFilesMenu = new ResourceMenu("recent_files");
    private final LinkedList<String> undoList = new LinkedList();
    private String lastProcessXML;
    private String hostname = null;
    private transient Process process = null;
    private transient ProcessThread processThread;
    private final MetaDataUpdateQueue metaDataUpdateQueue = new MetaDataUpdateQueue(this);
    private long lastUpdate = 0L;
    private final Timer updateTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.updateProcessNow();
        }
    }){
        private static final long serialVersionUID = 1L;
        {
            this.setRepeats(false);
        }
    };
    private final transient Observer<Process> processObserver = new Observer<Process>(){

        @Override
        public void update(Observable<Process> observable, Process arg) {
            if (System.currentTimeMillis() - MainFrame.this.lastUpdate > 500L) {
                MainFrame.this.updateProcessNow();
            } else if (MainFrame.this.process.getProcessState() == 2) {
                if (!MainFrame.this.updateTimer.isRunning()) {
                    MainFrame.this.updateTimer.start();
                }
            } else {
                MainFrame.this.updateProcessNow();
            }
        }
    };
    private final transient BreakpointListener breakpointListener = new BreakpointListener(){

        @Override
        public void breakpointReached(Process process, Operator operator, IOContainer ioContainer, int location) {
            if (process.equals(MainFrame.this.process)) {
                MainFrame.this.RUN_ACTION.setState(process.getProcessState());
                ProcessThread.beep("breakpoint");
                MainFrame.this.toFront();
                MainFrame.this.resultDisplay.showData(ioContainer, "Breakpoint in " + operator.getName() + ", application " + operator.getApplyCount());
            }
        }

        @Override
        public void resume() {
            MainFrame.this.RUN_ACTION.setState(MainFrame.this.process.getProcessState());
        }
    };

    private void updateProcessNow() {
        this.lastUpdate = System.currentTimeMillis();
        this.addToUndoList();
        String xmlWithoutGUIInformation = this.process.getRootOperator().getXML(true, false);
        if (!xmlWithoutGUIInformation.equals(this.lastProcessXML)) {
            this.validateProcess(false);
        } else {
            this.processPanel.getProcessRenderer().repaint();
        }
        this.lastProcessXML = xmlWithoutGUIInformation;
    }

    public void validateProcess(boolean force) {
        if (force || this.process.getProcessState() != 2) {
            this.metaDataUpdateQueue.validate(this.process, force);
        }
        this.fireProcessUpdated();
    }

    public MainFrame() {
        this("welcome");
    }

    public MainFrame(String initialPerspective) {
        super(TITLE);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addProcessEditor(this.actions);
        this.addProcessEditor(this.xmlEditor);
        this.addProcessEditor(this.commentEditor);
        this.addProcessEditor(this.propertyPanel);
        this.addProcessEditor(this.operatorTree);
        this.addProcessEditor(this.operatorDocViewer);
        this.addProcessEditor(this.processPanel);
        this.addProcessEditor(this.errorTable);
        this.addProcessEditor(this.processContextEditor);
        this.addProcessEditor(this.getStatusBar());
        this.addProcessEditor(this.resultDisplay);
        this.addProcessEditor(this.profilingListener);
        SwingTools.setFrameIcon(this);
        this.dockingContext.addDesktop(this.dockingDesktop);
        this.dockingDesktop.registerDockable((Dockable)this.welcomeScreen);
        this.dockingDesktop.registerDockable((Dockable)this.repositoryBrowser);
        this.dockingDesktop.registerDockable((Dockable)this.operatorTree);
        this.dockingDesktop.registerDockable((Dockable)this.propertyPanel);
        this.dockingDesktop.registerDockable((Dockable)this.processPanel);
        this.dockingDesktop.registerDockable((Dockable)this.commentEditor);
        this.dockingDesktop.registerDockable((Dockable)this.xmlEditor);
        this.dockingDesktop.registerDockable((Dockable)this.newOperatorEditor);
        this.dockingDesktop.registerDockable((Dockable)this.errorTable);
        this.dockingDesktop.registerDockable((Dockable)this.resultDisplay);
        this.dockingDesktop.registerDockable((Dockable)this.messageViewer);
        this.dockingDesktop.registerDockable((Dockable)this.systemMonitor);
        this.dockingDesktop.registerDockable((Dockable)this.operatorDocViewer);
        this.dockingDesktop.registerDockable((Dockable)this.processContextEditor);
        this.dockingDesktop.registerDockable((Dockable)this.remoteProcessViewer);
        this.dockingDesktop.registerDockable((Dockable)this.processPanel.getProcessRenderer().getOverviewPanel());
        this.dockingDesktop.registerDockable((Dockable)this.profilingViewer);
        ToolBarContainer toolBarContainer = ToolBarContainer.createDefaultContainer((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.getContentPane().add((Component)toolBarContainer, "Center");
        toolBarContainer.add((Component)this.dockingDesktop, (Object)"Center");
        this.systemMonitor.startMonitorThread();
        this.resultDisplay.init(this);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new ResourceMenu("file");
        this.fileMenu.add(this.NEW_ACTION);
        this.fileMenu.add(this.OPEN_ACTION);
        this.fileMenu.add(this.OPEN_TEMPLATE_ACTION);
        this.updateRecentFileList();
        this.fileMenu.add(this.recentFilesMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.SAVE_ACTION);
        this.fileMenu.add(this.SAVE_AS_ACTION);
        this.fileMenu.add(this.SAVE_AS_TEMPLATE_ACTION);
        this.fileMenu.addSeparator();
        ResourceMenu importMenu = new ResourceMenu("file.import");
        importMenu.add(this.IMPORT_CSV_FILE_ACTION);
        importMenu.add(this.IMPORT_EXCEL_FILE_ACTION);
        importMenu.add(this.IMPORT_ACCESS_FILE_ACTION);
        importMenu.add(this.IMPORT_DATABASE_TABLE_ACTION);
        importMenu.add(BlobImportWizard.IMPORT_BLOB_ACTION);
        this.fileMenu.add(importMenu);
        this.fileMenu.add(this.IMPORT_PROCESS_ACTION);
        this.fileMenu.add(this.EXPORT_PROCESS_ACTION);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.PRINT_ACTION);
        this.fileMenu.add(this.PRINT_PREVIEW_ACTION);
        this.fileMenu.add(this.PAGE_SETUP_ACTION);
        this.fileMenu.add(this.EXPORT_ACTION);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.EXIT_ACTION);
        this.menuBar.add(this.fileMenu);
        this.editMenu = new ResourceMenu("edit");
        this.editMenu.add(this.UNDO_ACTION);
        this.editMenu.add(this.REDO_ACTION);
        this.editMenu.addSeparator();
        this.editMenu.add(this.actions.INFO_OPERATOR_ACTION);
        this.editMenu.add(this.actions.TOGGLE_ACTIVATION_ITEM.createMenuItem());
        this.editMenu.add(this.actions.RENAME_OPERATOR_ACTION);
        this.editMenu.addSeparator();
        this.editMenu.add(this.actions.NEW_OPERATOR_ACTION);
        this.editMenu.add(this.actions.NEW_BUILDING_BLOCK_ACTION);
        this.editMenu.add(this.actions.SAVE_BUILDING_BLOCK_ACTION);
        this.editMenu.addSeparator();
        this.editMenu.add(CutCopyPasteAction.CUT_ACTION);
        this.editMenu.add(CutCopyPasteAction.COPY_ACTION);
        this.editMenu.add(CutCopyPasteAction.PASTE_ACTION);
        this.editMenu.add(this.actions.DELETE_OPERATOR_ACTION);
        this.editMenu.addSeparator();
        for (ToggleBreakpointItem item : this.actions.TOGGLE_BREAKPOINT) {
            this.editMenu.add(item.createMenuItem());
        }
        this.editMenu.add(this.actions.TOGGLE_ALL_BREAKPOINTS.createMenuItem());
        this.menuBar.add(this.editMenu);
        this.processMenu = new ResourceMenu("process");
        this.processMenu.add(this.RUN_ACTION);
        this.processMenu.add(this.PAUSE_ACTION);
        this.processMenu.add(this.STOP_ACTION);
        this.processMenu.addSeparator();
        this.processMenu.add(this.VALIDATE_ACTION);
        this.processMenu.add(this.VALIDATE_AUTOMATICALLY_ACTION.createMenuItem());
        JCheckBoxMenuItem debugmodeMenu = new JCheckBoxMenuItem(new ResourceAction(true, "process_debug_mode", new Object[0]){
            private static final long serialVersionUID = 2158722678316407076L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                    MainFrame.this.getProcess().setDebugMode(DebugMode.COLLECT_METADATA_AFTER_EXECUTION);
                } else {
                    MainFrame.this.getProcess().setDebugMode(DebugMode.DEBUG_OFF);
                }
            }
        });
        this.processMenu.add(debugmodeMenu);
        this.processMenu.addSeparator();
        ResourceMenu wiringMenu = new ResourceMenu("wiring");
        wiringMenu.add(this.AUTO_WIRE);
        wiringMenu.add(this.AUTO_WIRE_RECURSIVELY);
        wiringMenu.add(this.REWIRE);
        wiringMenu.add(this.REWIRE_RECURSIVELY);
        this.processMenu.add(wiringMenu);
        ResourceMenu orderMenu = new ResourceMenu("execution_order");
        orderMenu.add(this.processPanel.getProcessRenderer().getFlowVisualizer().ALTER_EXECUTION_ORDER.createMenuItem());
        orderMenu.add(this.processPanel.getProcessRenderer().getFlowVisualizer().SHOW_EXECUTION_ORDER);
        this.processMenu.add(orderMenu);
        ResourceMenu layoutMenu = new ResourceMenu("process_layout");
        layoutMenu.add(this.processPanel.getProcessRenderer().ARRANGE_OPERATORS_ACTION);
        layoutMenu.add(this.processPanel.getProcessRenderer().AUTO_FIT_ACTION);
        layoutMenu.add(this.processPanel.getProcessRenderer().INCREASE_PROCESS_LAYOUT_WIDTH_ACTION);
        layoutMenu.add(this.processPanel.getProcessRenderer().DECREASE_PROCESS_LAYOUT_WIDTH_ACTION);
        layoutMenu.add(this.processPanel.getProcessRenderer().INCREASE_PROCESS_LAYOUT_HEIGHT_ACTION);
        layoutMenu.add(this.processPanel.getProcessRenderer().DECREASE_PROCESS_LAYOUT_HEIGHT_ACTION);
        this.processMenu.add(layoutMenu);
        this.processMenu.addSeparator();
        this.processMenu.add(this.RUN_REMOTE_ACTION);
        this.menuBar.add(this.processMenu);
        this.toolsMenu = new ResourceMenu("tools");
        this.toolsMenu.add(this.MANAGE_BUILDING_BLOCKS_ACTION);
        this.toolsMenu.add(this.MANAGE_TEMPLATES_ACTION);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(this.ANOVA_CALCULATOR_ACTION);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(this.CHECK_FOR_JDBC_DRIVERS_ACTION);
        this.toolsMenu.add(this.MANAGE_DB_CONNECTIONS_ACTION);
        this.toolsMenu.add(ManageDatabaseDriversDialog.SHOW_DIALOG_ACTION);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(UsageStatsTransmissionDialog.SHOW_STATISTICS_ACTION);
        this.toolsMenu.add(this.SETTINGS_ACTION);
        this.menuBar.add(this.toolsMenu);
        this.viewMenu = new ResourceMenu("view");
        this.viewMenu.add(this.perspectives.getWorkspaceMenu());
        this.viewMenu.add(this.NEW_PERSPECTIVE_ACTION);
        this.viewMenu.add(new DockableMenu(this.dockingContext));
        this.viewMenu.add(this.perspectives.RESTORE_DEFAULT_ACTION);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.TOGGLE_EXPERT_MODE_ACTION.createMenuItem());
        this.menuBar.add(this.viewMenu);
        this.helpMenu = new ResourceMenu("help");
        this.helpMenu.add(this.TUTORIAL_ACTION);
        this.helpMenu.add(new BrowseAction("help_support", URI.create("http://rapid-i.com/content/view/60/89/lang,en/")));
        this.helpMenu.add(new BrowseAction("help_videotutorials", URI.create("http://rapid-i.com/content/view/189/198/")));
        this.helpMenu.add(new BrowseAction("help_forum", URI.create("http://forum.rapid-i.com")));
        this.helpMenu.add(new BrowseAction("help_wiki", URI.create("http://wiki.rapid-i.com")));
        this.helpMenu.addSeparator();
        this.helpMenu.add(ExtensionDialog.MANAGE_EXTENSIONS);
        List<Plugin> allPlugins = Plugin.getAllPlugins();
        if (allPlugins.size() > 0) {
            ResourceMenu extensionsMenu = new ResourceMenu("about_extensions");
            for (final Plugin plugin : allPlugins) {
                if (!plugin.showAboutBox()) continue;
                extensionsMenu.add(new ResourceAction("about_extension", new Object[]{plugin.getName()}){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        plugin.createAboutBox(MainFrame.this).setVisible(true);
                    }
                });
            }
            this.helpMenu.add(extensionsMenu);
        }
        this.helpMenu.addSeparator();
        this.helpMenu.add(UpdateDialog.UPDATE_ACTION);
        this.helpMenu.add(new AboutAction(this));
        this.menuBar.add(this.helpMenu);
        RapidDockingToolbar fileToolBar = new RapidDockingToolbar("file");
        fileToolBar.add(this.makeToolbarButton(this.NEW_ACTION));
        fileToolBar.add(this.makeToolbarButton(this.OPEN_ACTION));
        fileToolBar.add(this.makeToolbarButton(this.SAVE_ACTION));
        fileToolBar.add(this.makeToolbarButton(this.SAVE_AS_ACTION));
        fileToolBar.add(this.makeToolbarButton(this.PRINT_ACTION));
        RapidDockingToolbar editToolBar = new RapidDockingToolbar("edit");
        editToolBar.add(this.makeToolbarButton(this.UNDO_ACTION));
        editToolBar.add(this.makeToolbarButton(this.REDO_ACTION));
        RapidDockingToolbar runToolBar = new RapidDockingToolbar("run");
        runToolBar.add(this.makeToolbarButton(this.RUN_ACTION));
        runToolBar.add(this.makeToolbarButton(this.PAUSE_ACTION));
        runToolBar.add(this.makeToolbarButton(this.STOP_ACTION));
        if ("true".equals(System.getProperty("rapidminer.developermode"))) {
            runToolBar.addSeparator();
            runToolBar.add(this.makeToolbarButton(this.VALIDATE_ACTION));
        }
        RapidDockingToolbar viewToolBar = this.perspectives.getWorkspaceToolBar();
        ToolBarPanel toolBarPanel = toolBarContainer.getToolBarPanelAt((Object)"North");
        toolBarPanel.add((VLToolBar)fileToolBar, new ToolBarConstraints(0, 0));
        toolBarPanel.add((VLToolBar)editToolBar, new ToolBarConstraints(0, 1));
        toolBarPanel.add((VLToolBar)runToolBar, new ToolBarConstraints(0, 2));
        toolBarPanel.add((VLToolBar)viewToolBar, new ToolBarConstraints(0, 3));
        this.getContentPane().add((Component)this.getStatusBar(), "South");
        this.getStatusBar().startClockThread();
        this.setProcess(new Process(), true);
        this.selectOperator(this.process.getRootOperator());
        this.addToUndoList();
        this.perspectives.showPerspective(initialPerspective);
        this.pack();
        this.metaDataUpdateQueue.start();
    }

    private JButton makeToolbarButton(Action action) {
        JButton button = new JButton(action);
        if (button.getIcon() != null) {
            button.setText(null);
        }
        return button;
    }

    @Deprecated
    public void changeMode(int mode) {
    }

    public void startTutorial() {
        if (this.close()) {
            new Tutorial(this).setVisible(true);
        }
    }

    public void setTutorialMode(boolean mode) {
        this.tutorialMode = mode;
        if (this.tutorialMode) {
            this.SAVE_ACTION.setEnabled(false);
            this.SAVE_AS_ACTION.setEnabled(false);
        } else {
            this.SAVE_ACTION.setEnabled(false);
            this.SAVE_AS_ACTION.setEnabled(true);
        }
    }

    public boolean isTutorialMode() {
        return this.tutorialMode;
    }

    public void setExpertMode(boolean expert) {
        this.TOGGLE_EXPERT_MODE_ACTION.setSelected(expert);
        this.TOGGLE_EXPERT_MODE_ACTION.actionToggled(null);
    }

    public OperatorPropertyPanel getPropertyPanel() {
        return this.propertyPanel;
    }

    public LoggingViewer getMessageViewer() {
        return this.messageViewer;
    }

    public NewOperatorEditor getNewOperatorEditor() {
        return this.newOperatorEditor;
    }

    public OperatorTree getOperatorTree() {
        return this.operatorTree.getOperatorTree();
    }

    public Actions getActions() {
        return this.actions;
    }

    public ResultDisplay getResultDisplay() {
        return this.resultDisplay;
    }

    public int getProcessState() {
        if (this.process == null) {
            return -1;
        }
        return this.process.getProcessState();
    }

    @Deprecated
    public final Process getExperiment() {
        return this.getProcess();
    }

    public final Process getProcess() {
        return this.process;
    }

    public void newProcess() {
        if (this.close()) {
            this.stopProcess();
            this.setProcess(new Process(), true);
            this.addToUndoList();
            if (!"false".equals(System.getProperty(PROPERTY_RAPIDMINER_GUI_SAVE_ON_PROCESS_CREATION))) {
                SaveAction.save(this.getProcess());
            }
        }
    }

    public void runProcess() {
        if (this.getProcessState() == 0) {
            if ((this.isChanged() || this.getProcess().getProcessLocation() == null) && !this.isTutorialMode() && DecisionRememberingConfirmDialog.confirmAction("save_before_run", PROPERTY_RAPIDMINER_GUI_SAVE_BEFORE_RUN)) {
                SaveAction.save(this.getProcess());
            }
            this.processThread = new ProcessThread(this.process);
            try {
                this.processThread.start();
            }
            catch (Exception t) {
                SwingTools.showSimpleErrorMessage("cannot_start_process", (Throwable)t, new Object[0]);
            }
        } else {
            this.process.resume();
        }
    }

    public void stopProcess() {
        if (this.getProcessState() != 0) {
            this.getProcess().getLogger().info("Process stopped. Completing current operator.");
            this.getStatusBar().setSpecialText("Process stopped. Completing current operator.");
            if (this.processThread != null && this.processThread.isAlive()) {
                this.processThread.setPriority(1);
                this.processThread.stopProcess();
            }
        }
    }

    public void pauseProcess() {
        if (this.getProcessState() == 2) {
            this.getProcess().getLogger().info("Process paused. Completing current operator.");
            this.getStatusBar().setSpecialText("Process paused. Completing current operator.");
            if (this.processThread != null) {
                this.processThread.pauseProcess();
            }
        }
    }

    void processEnded(Process process, IOContainer results) {
        if (process.equals(this.process) && results != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.toFront();
                }
            });
        }
        if (process.equals(this.process) && results != null) {
            this.resultDisplay.showData(results, "Process results");
            ProcessLocation location = this.process.getProcessLocation();
            String resultName = location != null ? location.getShortName() : "unnamed";
            RapidMinerGUI.getResultHistory().addResults(resultName, this.process.getRootOperator(), results);
        }
    }

    @Deprecated
    public void setExperiment(Process process) {
        this.setProcess(process, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcess(Process process, boolean newProcess) {
        boolean firstProcess;
        boolean bl = firstProcess = this.process == null;
        if (this.process != null) {
            this.process.removeObserver(this.processObserver);
        }
        if (this.getProcessState() != 0 && this.processThread != null) {
            this.processThread.stopProcess();
        }
        if (process != null) {
            process.addObserver(this.processObserver, true);
        }
        Process process2 = process;
        synchronized (process2) {
            this.process = process;
            this.processThread = new ProcessThread(this.process);
            this.process.addBreakpointListener(this.breakpointListener);
            this.fireProcessChanged();
            this.selectOperator(this.process.getRootOperator());
            if (this.VALIDATE_AUTOMATICALLY_ACTION.isSelected()) {
                this.validateProcess(false);
            }
        }
        if (newProcess && !firstProcess) {
            this.perspectives.showPerspective("design");
        }
        this.setTitle();
    }

    @Deprecated
    public void processChanged() {
    }

    public boolean isChanged() {
        return this.changed;
    }

    private boolean addToUndoList() {
        String lastStateXML = this.undoList.size() != 0 ? this.undoList.get(this.undoList.size() - 1) : null;
        String currentStateXML = null;
        currentStateXML = this.process.getRootOperator().getXML(true);
        if (currentStateXML != null) {
            if (lastStateXML == null || !lastStateXML.equals(currentStateXML)) {
                if (this.undoIndex < this.undoList.size() - 1) {
                    while (this.undoList.size() > this.undoIndex + 1) {
                        this.undoList.removeLast();
                    }
                }
                this.undoList.add(currentStateXML);
                String maxSizeProperty = System.getProperty(PROPERTY_RAPIDMINER_GUI_UNDOLIST_SIZE);
                int maxSize = 20;
                try {
                    if (maxSizeProperty != null) {
                        maxSize = Integer.parseInt(maxSizeProperty);
                    }
                }
                catch (NumberFormatException e) {
                    LogService.getRoot().warning("Bad integer format for property 'rapidminer.gui.undolist.size', using default size of 20.");
                }
                while (this.undoList.size() > maxSize) {
                    this.undoList.removeFirst();
                }
                this.undoIndex = this.undoList.size() - 1;
                this.enableUndoAction();
                boolean oldValue = this.changed;
                boolean bl = this.changed = lastStateXML != null;
                if (!oldValue) {
                    this.setTitle();
                }
                if (this.process.getProcessLocation() != null && !this.tutorialMode) {
                    this.SAVE_ACTION.setEnabled(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void undo() {
        if (this.undoIndex > 0) {
            --this.undoIndex;
            this.setProcessIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    public void redo() {
        if (this.undoIndex < this.undoList.size()) {
            ++this.undoIndex;
            this.setProcessIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    private void enableUndoAction() {
        if (this.undoIndex > 0) {
            this.UNDO_ACTION.setEnabled(true);
        } else {
            this.UNDO_ACTION.setEnabled(false);
        }
        if (this.undoIndex < this.undoList.size() - 1) {
            this.REDO_ACTION.setEnabled(true);
        } else {
            this.REDO_ACTION.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProcessIntoStateAt(int undoIndex) {
        String stateXML = this.undoList.get(undoIndex);
        try {
            Process process = this.process;
            synchronized (process) {
                Process process2 = new Process(stateXML, this.process);
                this.setProcess(process2, false);
                this.changed = true;
                this.setTitle();
                if (this.process.getProcessLocation() != null && !this.tutorialMode) {
                    this.SAVE_ACTION.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("while_changing_process", (Throwable)e, new Object[0]);
        }
    }

    private void setTitle() {
        if (this.hostname == null) {
            try {
                this.hostname = "@" + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.hostname = "";
            }
        }
        if (this.process != null) {
            ProcessLocation loc = this.process.getProcessLocation();
            if (loc != null) {
                this.setTitle(loc.getShortName() + (this.changed ? "*" : "") + " \u2013 " + TITLE + this.hostname);
            } else {
                this.setTitle(TITLE + this.hostname);
            }
        } else {
            this.setTitle(TITLE + this.hostname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        if (this.changed) {
            ProcessLocation loc = this.process.getProcessLocation();
            String locName = loc != null ? loc.getShortName() : "unnamed";
            switch (SwingTools.showConfirmDialog("save", 1, locName)) {
                case 0: {
                    SaveAction.save(this.getProcess());
                    return true;
                }
                case 1: {
                    if (this.getProcessState() != 0) {
                        ProcessThread processThread = this.processThread;
                        synchronized (processThread) {
                            this.processThread.stopProcess();
                        }
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpenedProcess(Process process, boolean showInfo, final String sourceName) {
        this.setProcess(process, true);
        if (process.getImportMessage() != null) {
            SwingTools.showLongMessage("import_message", process.getImportMessage());
        }
        this.SAVE_ACTION.setEnabled(false);
        Process process2 = process;
        synchronized (process2) {
            String text;
            RapidMinerGUI.useProcessFile(this.process);
            this.updateRecentFileList();
            this.addToUndoList();
            this.changed = false;
            this.setTitle();
            List<UnknownParameterInformation> unknownParameters = process.getUnknownParameters();
            if (unknownParameters.size() > 0) {
                new UnknownParametersInfoDialog((Frame)this, unknownParameters).setVisible(true);
            } else if (showInfo && Tools.booleanValue(System.getProperty(PROPERTY_RAPIDMINER_GUI_PROCESSINFO_SHOW), true) && (text = this.process.getRootOperator().getUserDescription()) != null && text.length() != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProcessInfoScreen infoScreen = new ProcessInfoScreen(sourceName, text);
                        infoScreen.setVisible(true);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsTemplate() {
        Process process = this.process;
        synchronized (process) {
            SaveAsTemplateDialog dialog = new SaveAsTemplateDialog(this.process);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                try {
                    dialog.getTemplate().saveAsUserTemplate(this.process);
                }
                catch (Exception ioe) {
                    SwingTools.showSimpleErrorMessage("cannot_write_template_file", (Throwable)ioe, new Object[0]);
                }
            }
        }
    }

    public void exit(boolean relaunch) {
        block7: {
            int answer;
            block6: {
                if (!this.changed) break block6;
                ProcessLocation loc = this.process.getProcessLocation();
                String locName = loc != null ? loc.getShortName() : "unnamed";
                switch (SwingTools.showConfirmDialog("save", 1, locName)) {
                    case 0: {
                        SaveAction.save(this.process);
                        if (this.changed) {
                            return;
                        }
                        break block7;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                break block7;
            }
            if (!relaunch && (answer = ConfirmDialog.showConfirmDialog("exit", 0, "rapidminer.gui.confirm_exit", 0, new Object[0])) != 0) {
                return;
            }
        }
        this.stopProcess();
        this.dispose();
        RapidMinerGUI.quit(relaunch ? RapidMiner.ExitMode.RELAUNCH : RapidMiner.ExitMode.NORMAL);
    }

    public void updateRecentFileList() {
        this.recentFilesMenu.removeAll();
        List<ProcessLocation> recentFiles = RapidMinerGUI.getRecentFiles();
        int j = 1;
        for (final ProcessLocation recentLocation : recentFiles) {
            JMenuItem menuItem = new JMenuItem(j + " " + recentLocation.toMenuString());
            menuItem.setMnemonic(48 + j);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenAction.open(recentLocation, true);
                }
            });
            this.recentFilesMenu.add(menuItem);
            ++j;
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.exit(false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void removeMenu(int index) {
        this.menuBar.remove(this.menuBar.getMenu(index));
    }

    public void removeMenuItem(int menuIndex, int itemIndex) {
        this.menuBar.getMenu(menuIndex).remove(itemIndex);
    }

    public void addMenuItem(int menuIndex, int itemIndex, JMenuItem item) {
        this.menuBar.getMenu(menuIndex).add((Component)item, itemIndex);
    }

    public void addMenu(int menuIndex, JMenu menu) {
        this.menuBar.add((Component)menu, menuIndex);
    }

    public void addMenuSeparator(int menuIndex) {
        this.menuBar.getMenu(menuIndex).addSeparator();
    }

    public List<Operator> getSelectedOperators() {
        return this.selectedOperators;
    }

    public Operator getFirstSelectedOperator() {
        return this.selectedOperators.isEmpty() ? null : this.selectedOperators.get(0);
    }

    void addProcessEditor(ProcessEditor p) {
        this.processEditors.add(ProcessEditor.class, p);
    }

    public void selectOperator(Operator currentlySelected) {
        if (currentlySelected == null) {
            currentlySelected = this.process.getRootOperator();
        }
        this.selectOperators(Collections.singletonList(currentlySelected));
    }

    public void selectOperators(List<Operator> currentlySelected) {
        if (currentlySelected == null) {
            currentlySelected = Collections.singletonList(this.process.getRootOperator());
        }
        for (Operator op : currentlySelected) {
            Process selectedProcess = op.getProcess();
            if (selectedProcess != null && selectedProcess == this.process) continue;
            SwingTools.showVerySimpleErrorMessage("op_deleted", op.getName());
            return;
        }
        this.selectedOperators = currentlySelected;
        this.fireSelectedOperatorChanged(this.selectedOperators);
    }

    private void fireSelectedOperatorChanged(List<Operator> currentlySelected) {
        for (ProcessEditor editor : (ProcessEditor[])this.processEditors.getListeners(ProcessEditor.class)) {
            editor.setSelection(currentlySelected);
        }
    }

    public void fireProcessUpdated() {
        for (ProcessEditor editor : (ProcessEditor[])this.processEditors.getListeners(ProcessEditor.class)) {
            editor.processUpdated(this.process);
        }
    }

    private void fireProcessChanged() {
        for (ProcessEditor editor : (ProcessEditor[])this.processEditors.getListeners(ProcessEditor.class)) {
            editor.processChanged(this.process);
        }
    }

    public DockingDesktop getDockingDesktop() {
        return this.dockingDesktop;
    }

    public Perspectives getPerspectives() {
        return this.perspectives;
    }

    public void handleBrokenProxessXML(ProcessLocation location, String xml, Exception e) {
        SwingTools.showSimpleErrorMessage("while_loading", (Throwable)e, ((Object)location).toString(), e.getMessage());
        Process process = new Process();
        process.setProcessLocation(location);
        this.setProcess(process, true);
        this.perspectives.showPerspective("design");
        this.xmlEditor.setText(xml);
    }

    public OperatorDocViewer getOperatorDocViewer() {
        return this.operatorDocViewer;
    }

    public ProcessPanel getProcessPanel() {
        return this.processPanel;
    }

    public void registerDockable(Dockable dockable) {
        this.dockingDesktop.registerDockable(dockable);
    }

    public void processHasBeenSaved() {
        this.SAVE_ACTION.setEnabled(false);
        this.changed = false;
        this.setTitle();
        this.updateRecentFileList();
    }

    public ProcessContextProcessEditor getProcessContextEditor() {
        return this.processContextEditor;
    }

    public Component getXMLEditor() {
        return this.xmlEditor;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    public JMenuBar getMainMenuBar() {
        return this.menuBar;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getProcessMenu() {
        return this.processMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    static {
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_MATRIXPLOT_SIZE, "The pixel size of each plot in matrix plots.", 1, Integer.MAX_VALUE, 200));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_ROWS_MAXIMUM, "The maximum number of rows used for a plotter, using only a sample of this size if more rows are available.", 1, Integer.MAX_VALUE, 5000));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_CLASSLIMIT, "Limit number of displayed classes plotter legends. -1 for no limit.", -1, Integer.MAX_VALUE, 10));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MINCOLOR, "The color for minimum values of the plotter legend.", Color.blue));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_PLOTTER_LEGEND_MAXCOLOR, "The color for maximum values of the plotter legend.", Color.red));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_PLOTTER_COLORS_CLASSLIMIT, "Limit number of displayed classes for colorized plots. -1 for no limit.", -1, Integer.MAX_VALUE, 10));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_UNDOLIST_SIZE, "Maximum number of states in the undo list.", 1, Integer.MAX_VALUE, 10));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_ATTRIBUTEEDITOR_ROWLIMIT, "Maximum number of examples to use for the attribute editor. -1 for no limit.", -1, Integer.MAX_VALUE, 50));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_BEEP_SUCCESS, "Beep on process success?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_BEEP_ERROR, "Beep on error?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_BEEP_BREAKPOINT, "Beep when breakpoint reached?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_ROWLIMIT, "Limit number of displayed rows in the message viewer. -1 for no limit.", -1, Integer.MAX_VALUE, 1000));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_NOTES, "The color for notes in the message viewer.", new Color(51, 151, 51)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_WARNINGS, "The color for warnings in the message viewer.", new Color(51, 51, 255)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_ERRORS, "The color for errors in the message viewer.", new Color(255, 51, 204)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeColor(PROPERTY_RAPIDMINER_GUI_MESSAGEVIEWER_HIGHLIGHT_LOGSERVICE, "The color for the logging service indicator in the message viewer.", new Color(184, 184, 184)));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_PROCESSINFO_SHOW, "Shows process info screen after loading?", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_GUI_SAVE_BEFORE_RUN, "Save process before running process?", DecisionRememberingConfirmDialog.PROPERTY_VALUES, 2));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GUI_SAVE_ON_PROCESS_CREATION, "Save process when creating them?", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_GUI_AUTO_SWITCH_TO_RESULTVIEW, "Automatically switch to results perspective when results are created?", DecisionRememberingConfirmDialog.PROPERTY_VALUES, 2));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_GUI_RESULT_DISPLAY_TYPE, "Determines the result display style.", ResultDisplayTools.TYPE_NAMES, 0));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_GUI_LOG_LEVEL, "Minimum level of messages that are logged in the GUIs log view.", LoggingViewer.SELECTABLE_LEVEL_NAMES, 4));
        DOCK_GROUP_ROOT = new DockGroup("root");
        DOCK_GROUP_RESULTS = new DockGroup("results");
    }
}

