/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.Dimension;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ExampleVisualizer
implements ObjectVisualizer {
    private final ExampleSet exampleSet;
    private final Attribute idAttribute;
    private boolean isExampleSetRemapped = false;

    public ExampleVisualizer(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.idAttribute = exampleSet.getAttributes().getId();
    }

    @Override
    public void startVisualization(final Object objId) {
        this.remapIds();
        ButtonDialog dialog = new ButtonDialog("example_visualizer_dialog", false, new Object[]{objId}){
            private static final long serialVersionUID = 1L;
            {
                super(x0, x1, x2);
                double idValue = Double.NaN;
                idValue = ExampleVisualizer.this.idAttribute.isNominal() ? (objId instanceof String ? (double)ExampleVisualizer.this.idAttribute.getMapping().mapString((String)objId) : (Double)objId) : (objId instanceof String ? Double.parseDouble((String)objId) : (Double)objId);
                Example example = ExampleVisualizer.this.exampleSet.getExampleFromId(idValue);
                JComponent main = example != null ? ExampleVisualizer.this.makeMainVisualizationComponent(example) : new JLabel("No information available for object '" + objId + "'.");
                this.layoutDefault(main, 2, this.makeCloseButton());
            }
        };
        dialog.setVisible(true);
    }

    private String getFormattedValue(Example example, Attribute attribute) {
        double value = example.getValue(attribute);
        if (Double.isNaN(value)) {
            return "?";
        }
        if (attribute.isNominal()) {
            return attribute.getMapping().mapIndex((int)value);
        }
        switch (attribute.getValueType()) {
            case 3: {
                return com.rapidminer.tools.Tools.formatIntegerIfPossible(value);
            }
            case 4: {
                return com.rapidminer.tools.Tools.formatNumber(value);
            }
            case 2: {
                return com.rapidminer.tools.Tools.formatNumber(value);
            }
            case 10: {
                return com.rapidminer.tools.Tools.formatDate(new Date((long)value));
            }
            case 11: {
                return com.rapidminer.tools.Tools.formatTime(new Date((long)value));
            }
            case 9: {
                return com.rapidminer.tools.Tools.formatDateTime(new Date((long)value));
            }
        }
        return "";
    }

    protected JComponent makeMainVisualizationComponent(Example example) {
        Object[] columnNames = new String[]{"Attribute", "Value"};
        Object[][] data = new String[this.exampleSet.getAttributes().allSize()][2];
        Iterator<Attribute> a = this.exampleSet.getAttributes().allAttributes();
        int counter = 0;
        while (a.hasNext()) {
            Attribute attribute = a.next();
            data[counter][0] = attribute.getName();
            data[counter][1] = this.getFormattedValue(example, attribute);
            ++counter;
        }
        ExtendedJTable table = new ExtendedJTable();
        table.setDefaultEditor(Object.class, null);
        DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
        ((JTable)table).setModel(tableModel);
        ExtendedJScrollPane main = new ExtendedJScrollPane(table);
        main.setBorder(ButtonDialog.createBorder());
        int tableHeight = (int)(table.getPreferredSize().getHeight() + table.getTableHeader().getPreferredSize().getHeight() + 5.0);
        if ((double)tableHeight < main.getPreferredSize().getHeight()) {
            main.setPreferredSize(new Dimension((int)main.getPreferredSize().getWidth(), tableHeight));
        }
        return main;
    }

    @Override
    public String getDetailData(Object objId, String fieldName) {
        this.remapIds();
        double idValue = Double.NaN;
        idValue = this.idAttribute.isNominal() ? (objId instanceof String ? (double)this.idAttribute.getMapping().mapString((String)objId) : (Double)objId) : (objId instanceof String ? Double.parseDouble((String)objId) : (Double)objId);
        Example example = this.exampleSet.getExampleFromId(idValue);
        Attribute attribute = this.exampleSet.getAttributes().get(fieldName);
        if (attribute != null) {
            return example.getValueAsString(attribute);
        }
        return null;
    }

    @Override
    public String[] getFieldNames(Object id) {
        return Tools.getAllAttributeNames(this.exampleSet);
    }

    @Override
    public void stopVisualization(Object objId) {
    }

    @Override
    public String getTitle(Object objId) {
        return objId instanceof String ? (String)objId : ((Double)objId).toString();
    }

    @Override
    public boolean isCapableToVisualize(Object id) {
        this.remapIds();
        if (this.idAttribute.isNominal()) {
            double idValue = id instanceof String ? (double)this.idAttribute.getMapping().mapString((String)id) : (Double)id;
            return this.exampleSet.getExampleFromId(idValue) != null;
        }
        double idValue = id instanceof String ? Double.parseDouble((String)id) : (Double)id;
        return this.exampleSet.getExampleFromId(idValue) != null;
    }

    private void remapIds() {
        if (!this.isExampleSetRemapped) {
            this.exampleSet.remapIds();
            this.isExampleSetRemapped = true;
        }
    }
}

