/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.gui.tools.ResourceMenu;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DockableMenu
extends ResourceMenu {
    private static final long serialVersionUID = -5602297374075268751L;
    private final DockingContext dockingContext;

    public DockableMenu(DockingContext dockingContext) {
        super("show_view");
        this.dockingContext = dockingContext;
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                DockableMenu.this.fill();
            }
        });
    }

    private void fill() {
        this.removeAll();
        DockableState[] dockables = ((DockingDesktop)this.dockingContext.getDesktopList().get(0)).getDockables();
        LinkedList<DockableState> sorted = new LinkedList<DockableState>();
        sorted.addAll(Arrays.asList(dockables));
        Collections.sort(sorted, new Comparator<DockableState>(){

            @Override
            public int compare(DockableState o1, DockableState o2) {
                return o1.getDockable().getDockKey().getName().compareTo(o2.getDockable().getDockKey().getName());
            }
        });
        for (final DockableState state : sorted) {
            String key = state.getDockable().getDockKey().getKey();
            if (key.startsWith("result_") || key.startsWith("datatable_")) continue;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(state.getDockable().getDockKey().getName(), state.getDockable().getDockKey().getIcon());
            item.setSelected(!state.isClosed());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (state.isClosed()) {
                        ((DockingDesktop)DockableMenu.this.dockingContext.getDesktopList().get(0)).addDockable(state.getDockable());
                    } else {
                        ((DockingDesktop)DockableMenu.this.dockingContext.getDesktopList().get(0)).close(state.getDockable());
                    }
                }
            });
            this.add(item);
        }
    }
}

