/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class ConditionalAction
extends AbstractAction {
    private static final long serialVersionUID = -3581066203343247846L;
    private static final List<WeakReference<ConditionalAction>> ALL_ACTIONS = new LinkedList<WeakReference<ConditionalAction>>();
    public static final int DISALLOWED = -1;
    public static final int DONT_CARE = 0;
    public static final int MANDATORY = 1;
    public static final int OPERATOR_SELECTED = 0;
    public static final int OPERATOR_CHAIN_SELECTED = 1;
    public static final int ROOT_SELECTED = 2;
    public static final int SIBLINGS_EXIST = 3;
    public static final int PROCESS_STOPPED = 4;
    public static final int PROCESS_PAUSED = 5;
    public static final int PROCESS_RUNNING = 6;
    public static final int PARENT_ENABLED = 7;
    public static final int EXECUTION_UNIT_SELECTED = 8;
    public static final int EDIT_IN_PROGRESS = 9;
    public static final int NUMBER_OF_CONDITIONS = 10;
    private final int[] conditions = new int[10];

    public ConditionalAction(String name) {
        this(name, null);
    }

    public ConditionalAction(String name, Icon icon) {
        super(name, icon);
        this.conditions[9] = -1;
        if (SwingUtilities.isEventDispatchThread()) {
            ALL_ACTIONS.add(new WeakReference<ConditionalAction>(this));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ALL_ACTIONS.add(new WeakReference<ConditionalAction>(ConditionalAction.this));
                }
            });
        }
    }

    public void setCondition(int index, int condition) {
        this.conditions[index] = condition;
    }

    public static void updateAll(boolean[] states) {
        Iterator<WeakReference<ConditionalAction>> i = ALL_ACTIONS.iterator();
        while (i.hasNext()) {
            WeakReference<ConditionalAction> ref = i.next();
            ConditionalAction c = (ConditionalAction)ref.get();
            if (c == null) {
                i.remove();
                continue;
            }
            c.update(states);
        }
    }

    protected void update(boolean[] state) {
        boolean ok = true;
        boolean ignore = true;
        for (int i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i] == 0) continue;
            ignore = false;
            if ((this.conditions[i] != 1 || state[i]) && (this.conditions[i] != -1 || !state[i])) continue;
            ok = false;
            break;
        }
        if (!ignore) {
            this.setEnabled(ok);
        }
    }
}

