/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.gui.Perspective;
import com.rapidminer.gui.actions.WorkspaceAction;
import com.rapidminer.gui.docking.RapidDockingToolbar;
import com.rapidminer.gui.processeditor.ProcessLogTab;
import com.rapidminer.gui.processeditor.results.ResultTab;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableResolver;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.ws.WSDockKey;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;

public abstract class ApplicationPerspectives {
    public final Action RESTORE_DEFAULT_ACTION = new ResourceAction("restore_predefined_perspective_default", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ApplicationPerspectives.this.current.isUserDefined()) {
                ApplicationPerspectives.this.restoreDefault(ApplicationPerspectives.this.current.getName());
                ApplicationPerspectives.this.current.apply(ApplicationPerspectives.this.context);
            }
        }
    };
    private final ButtonGroup workspaceButtonGroup = new ButtonGroup();
    private final JMenu workspaceMenu = new ResourceMenu("perspectives");
    private final ButtonGroup workspaceMenuGroup = new ButtonGroup();
    private Perspective current;
    private final DockingContext context;
    private final Map<String, Perspective> perspectives = new LinkedHashMap<String, Perspective>();
    private RapidDockingToolbar workspaceToolBar;

    public ApplicationPerspectives(DockingContext context) {
        this.context = context;
        context.setDockableResolver(new DockableResolver(){

            public Dockable resolveDockable(String key) {
                if (key.startsWith("result_")) {
                    ResultTab tab = new ResultTab(key);
                    tab.showResult(null);
                    return tab;
                }
                if (key.startsWith("datatable_")) {
                    ProcessLogTab tab = new ProcessLogTab(key);
                    tab.setDataTableViewer(null);
                    return tab;
                }
                return null;
            }
        });
        this.makePredefined();
    }

    public void showPerspective(Perspective perspective) {
        if (this.current == perspective) {
            return;
        }
        if (this.current != null) {
            this.current.store(this.context);
        }
        perspective.apply(this.context);
        this.current = perspective;
        this.RESTORE_DEFAULT_ACTION.setEnabled(!this.current.isUserDefined());
    }

    public JMenu getWorkspaceMenu() {
        return this.workspaceMenu;
    }

    public RapidDockingToolbar getWorkspaceToolBar() {
        if (this.workspaceToolBar == null) {
            this.workspaceToolBar = new RapidDockingToolbar("perspectives");
            Enumeration<AbstractButton> e = this.workspaceButtonGroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton b = e.nextElement();
                this.workspaceToolBar.add(b);
            }
        }
        return this.workspaceToolBar;
    }

    public boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("")) {
            return false;
        }
        for (Perspective perspective : this.perspectives.values()) {
            if (!perspective.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public Perspective addPerspective(String name, boolean userDefined) {
        final Perspective p = new Perspective(this, name);
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Duplicate perspective name: " + name);
        }
        p.setUserDefined(userDefined);
        this.perspectives.put(name, p);
        WorkspaceAction action = new WorkspaceAction(this, p, name);
        if (p.isUserDefined()) {
            action.putValue("Name", name);
            action.putValue("SwingLargeIconKey", SwingTools.createIcon("24/" + I18N.getMessage(I18N.getGUIBundle(), "gui.action.workspace_user.icon", new Object[0])));
            action.putValue("SmallIcon", SwingTools.createIcon("16/" + I18N.getMessage(I18N.getGUIBundle(), "gui.action.workspace_user.icon", new Object[0])));
            action.putValue("ShortDescription", I18N.getMessage(I18N.getGUIBundle(), "gui.action.workspace_user.tip", name));
        }
        final JToggleButton button = new JToggleButton(action);
        if (p.isUserDefined()) {
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.evaluatePopup(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.evaluatePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.evaluatePopup(e);
                }

                private void evaluatePopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu menu = new JPopupMenu();
                        menu.add(new ResourceAction("delete_perspective", new Object[0]){
                            private static final long serialVersionUID = -1068519938053845994L;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ApplicationPerspectives.this.deletePerspective(p);
                            }
                        });
                        menu.show(button, e.getX(), e.getY());
                    }
                }
            });
        } else {
            button.setText("");
        }
        this.workspaceButtonGroup.add(button);
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(action);
        this.workspaceMenuGroup.add(menuItem);
        this.workspaceMenu.add(menuItem);
        if (this.workspaceToolBar != null) {
            this.workspaceToolBar.add(button);
        }
        return p;
    }

    public void saveAll() {
        LogService.getRoot().config("Saving perspectives.");
        if (this.current != null) {
            this.current.store(this.context);
        }
        for (Perspective perspective : this.perspectives.values()) {
            perspective.save();
        }
    }

    public void loadAll() {
        File[] userPerspectiveFiles;
        LogService.getRoot().config("Loading perspectives.");
        for (Perspective perspective : this.perspectives.values()) {
            perspective.load();
        }
        for (File file : userPerspectiveFiles = ParameterService.getUserRapidMinerDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("vlperspective-user-");
            }
        })) {
            String name = file.getName();
            name = name.substring("vlperspective-user-".length());
            name = name.substring(0, name.length() - ".xml".length());
            Perspective perspective = this.createUserPerspective(name, false);
            perspective.load();
        }
    }

    public Perspective getCurrentPerspective() {
        return this.current;
    }

    public void showPerspective(String name) {
        Enumeration<AbstractButton> e = this.workspaceButtonGroup.getElements();
        Enumeration<AbstractButton> i = this.workspaceMenuGroup.getElements();
        for (Perspective perspective : this.perspectives.values()) {
            AbstractButton b = e.nextElement();
            AbstractButton m = i.nextElement();
            if (!perspective.getName().equals(name)) continue;
            this.showPerspective(perspective);
            b.setSelected(true);
            m.setSelected(true);
        }
    }

    public Perspective createUserPerspective(String name, boolean show) {
        Perspective perspective = this.addPerspective(name, true);
        perspective.store(this.context);
        if (show) {
            this.showPerspective(name);
        }
        return perspective;
    }

    private void deletePerspective(Perspective p) {
        for (int i = 0; i < this.workspaceMenu.getMenuComponentCount(); ++i) {
            Component c = this.workspaceMenu.getMenuComponent(i);
            if (!(c instanceof JMenuItem) || !((JMenuItem)c).getText().equals(p.getName())) continue;
            this.workspaceMenu.remove((JMenuItem)c);
        }
        Enumeration<AbstractButton> e = this.workspaceButtonGroup.getElements();
        AbstractButton found = null;
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.getText().equals(p.getName())) continue;
            found = b;
            break;
        }
        if (found != null) {
            this.workspaceButtonGroup.remove(found);
            this.workspaceMenuGroup.remove(found);
            if (this.workspaceToolBar != null) {
                this.workspaceToolBar.remove(found);
                this.workspaceToolBar.revalidate();
            }
        }
        this.perspectives.remove(p.getName());
        p.delete();
        if (this.current == p && !this.perspectives.isEmpty()) {
            this.showPerspective(this.perspectives.values().iterator().next().getName());
        }
    }

    public void showTabInAllPerspectives(Dockable dockable, Dockable parent) {
        DockableState[] states;
        DockableState dstate = this.context.getDockableState(dockable);
        if (dstate != null && !dstate.isClosed()) {
            return;
        }
        DockingDesktop dockingDesktop = (DockingDesktop)this.context.getDesktopList().get(0);
        this.context.registerDockable(dockable);
        WSDockKey parentKey = new WSDockKey(parent.getDockKey().getKey());
        WSDockKey key = new WSDockKey(dockable.getDockKey().getKey());
        for (Perspective persp : this.perspectives.values()) {
            if (persp == this.current) continue;
            boolean containsParent = persp.getWorkspace().getDesktop(0).containsNode(parentKey);
            boolean containsChild = persp.getWorkspace().getDesktop(0).containsNode(key);
            if (!containsParent || containsChild) continue;
            persp.getWorkspace().getDesktop(0).createTab(parentKey, key, 1);
        }
        for (DockableState state : states = dockingDesktop.getDockables()) {
            if (state.getDockable() != parent || state.isClosed()) continue;
            dockingDesktop.createTab(state.getDockable(), dockable, 1, true);
            break;
        }
    }

    public void removeFromAllPerspectives(Dockable dockable) {
        this.context.unregisterDockable(dockable);
        WSDockKey key = new WSDockKey(dockable.getDockKey().getKey());
        for (Perspective persp : this.perspectives.values()) {
            if (persp == this.current) continue;
            persp.getWorkspace().getDesktop(0).removeNode(key);
        }
    }

    protected abstract void makePredefined();

    protected abstract void restoreDefault(String var1);

    protected Perspective getPerspective(String name) {
        Perspective result = this.perspectives.get(name);
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException("No such perspective: " + name);
    }
}

