/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.List;

public abstract class SingularNumericalGenerator
extends FeatureGenerator {
    private static final Attribute[] INPUT_ATTR = new Attribute[]{AttributeFactory.createAttribute(2)};

    public abstract double calculateValue(double var1);

    @Override
    public Attribute[] getInputAttributes() {
        return INPUT_ATTR;
    }

    @Override
    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute a1 = this.getArgument(0);
        Attribute ao = AttributeFactory.createAttribute(2, 1, this.getFunction() + "(" + a1.getConstruction() + ")");
        return new Attribute[]{ao};
    }

    @Override
    public List<Attribute[]> getInputCandidates(ExampleSet exampleSet, String[] functions) {
        ArrayList<Attribute[]> result = new ArrayList<Attribute[]>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!this.checkCompatibility(attribute, INPUT_ATTR[0], functions)) continue;
            result.add(new Attribute[]{attribute});
        }
        return result;
    }

    @Override
    public void generate(DataRow data) throws GenerationException {
        try {
            Attribute a = this.getArgument(0);
            double value = data.get(a);
            double r = this.calculateValue(value);
            if (Double.isInfinite(r)) {
                LogService.getGlobal().log(this.getFunction() + ": Infinite value generated, replaced by NaN.", 5);
                r = Double.NaN;
            }
            if (Double.isNaN(r)) {
                LogService.getGlobal().log(this.getFunction() + ": NaN generated.", 5);
            }
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], r);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a:" + this.getArgument(0), ex);
        }
    }

    @Override
    public String toString() {
        String s = "singular function ";
        if (this.resultAttributes != null && this.resultAttributes.length > 0 && this.resultAttributes[0] != null) {
            s = s + this.resultAttributes[0].getName() + ":=";
        }
        s = s + this.getFunction() + "(";
        if (this.argumentsSet()) {
            s = s + this.getArgument(0).getName();
        }
        s = s + ")";
        return s;
    }
}

