/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.AbsoluteValueGenerator;
import com.rapidminer.generator.BasicArithmeticOperationGenerator;
import com.rapidminer.generator.ConstantGenerator;
import com.rapidminer.generator.ExponentialFunctionGenerator;
import com.rapidminer.generator.FloorCeilGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.generator.MinMaxGenerator;
import com.rapidminer.generator.PowerGenerator;
import com.rapidminer.generator.ReciprocalValueGenerator;
import com.rapidminer.generator.SignumGenerator;
import com.rapidminer.generator.SquareRootGenerator;
import com.rapidminer.generator.TrigonometricFunctionGenerator;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class FeatureGenerator {
    private static final String[] FUNCTION_NAMES = new String[]{"+", "-", "*", "/", "1/", "sin", "cos", "tan", "atan", "exp", "log", "min", "max", "floor", "ceil", "round", "sqrt", "abs", "sgn", "pow"};
    private static final Class[] GENERATOR_CLASSES = new Class[]{BasicArithmeticOperationGenerator.class, BasicArithmeticOperationGenerator.class, BasicArithmeticOperationGenerator.class, BasicArithmeticOperationGenerator.class, ReciprocalValueGenerator.class, TrigonometricFunctionGenerator.class, TrigonometricFunctionGenerator.class, TrigonometricFunctionGenerator.class, TrigonometricFunctionGenerator.class, ExponentialFunctionGenerator.class, ExponentialFunctionGenerator.class, MinMaxGenerator.class, MinMaxGenerator.class, FloorCeilGenerator.class, FloorCeilGenerator.class, FloorCeilGenerator.class, SquareRootGenerator.class, AbsoluteValueGenerator.class, SignumGenerator.class, PowerGenerator.class};
    private static Map<String, Class> generatorMap = new HashMap<String, Class>();
    public static final int SELECTION_MODE_ALL = 0;
    public static final int SELECTION_MODE_RESTRICTIVE = 1;
    private static int selectionMode;
    protected Attribute[] resultAttributes;
    private Attribute[] arguments = null;
    private ExampleTable exampleTable;

    public abstract void generate(DataRow var1) throws GenerationException;

    public abstract Attribute[] getInputAttributes();

    public abstract Attribute[] getOutputAttributes(ExampleTable var1);

    public abstract FeatureGenerator newInstance();

    public abstract void setFunction(String var1);

    public abstract String getFunction();

    public abstract List<Attribute[]> getInputCandidates(ExampleSet var1, String[] var2);

    protected boolean checkCompatibility(Attribute attribute, Attribute compatible, String[] functions) {
        if (Tools.compatible(attribute, compatible)) {
            for (int f = 0; f < functions.length; ++f) {
                if (attribute.getConstruction().indexOf(functions[f]) == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setExampleTable(ExampleTable et) {
        this.exampleTable = et;
    }

    protected ExampleTable getExampleTable() {
        return this.exampleTable;
    }

    public void setArguments(Attribute[] args) {
        this.arguments = args;
    }

    public boolean argumentsSet() {
        return this.getInputAttributes().length == 0 || this.arguments != null;
    }

    public Attribute getArgument(int i) {
        return this.arguments[i];
    }

    private boolean argumentsOk(ExampleTable input) {
        Attribute[] inputA = this.getInputAttributes();
        for (int i = 0; i < inputA.length; ++i) {
            if (Tools.compatible(this.arguments[i], inputA[i])) continue;
            return false;
        }
        return true;
    }

    public static FeatureGenerator createGeneratorForFunction(String functionName) {
        if (functionName == null) {
            return null;
        }
        Class genClass = generatorMap.get(functionName);
        if (genClass == null) {
            if (functionName.startsWith("const")) {
                ConstantGenerator gen = new ConstantGenerator();
                ((FeatureGenerator)gen).setFunction(functionName);
                return gen;
            }
            return null;
        }
        try {
            FeatureGenerator gen = (FeatureGenerator)genClass.newInstance();
            gen.setFunction(functionName);
            return gen;
        }
        catch (Exception e) {
            LogService.getGlobal().log("Cannot instantiate '" + genClass.getName() + "'", 6);
            return null;
        }
    }

    public static FeatureGenerator selectGenerator(ExampleSet exampleSet, List generators, String[] functions, RandomGenerator random) {
        int combinationSum = 0;
        Iterator i = generators.iterator();
        double[] probs = new double[generators.size()];
        int k = 0;
        while (i.hasNext()) {
            FeatureGenerator generator = (FeatureGenerator)i.next();
            probs[k] = generator.getInputCandidates(exampleSet, functions).size();
            combinationSum = (int)((double)combinationSum + probs[k]);
            ++k;
        }
        if (combinationSum == 0) {
            return null;
        }
        k = 0;
        while (k < probs.length) {
            int n = k++;
            probs[n] = probs[n] / (double)combinationSum;
        }
        int index = random.randomIndex(probs);
        FeatureGenerator selected = (FeatureGenerator)generators.get(index);
        return selected;
    }

    public static List<Attribute> generateAll(ExampleTable exampleTable, Collection<FeatureGenerator> generatorList) throws GenerationException {
        LogService.getGlobal().log("Starting feature generation with " + generatorList.size() + " generators.", 2);
        Iterator<FeatureGenerator> gi = generatorList.iterator();
        while (gi.hasNext()) {
            gi.next().setExampleTable(exampleTable);
        }
        FeatureGenerator[] generators = new FeatureGenerator[generatorList.size()];
        generatorList.toArray(generators);
        List<Attribute> newAttributeList = FeatureGenerator.newAttributes(generators, exampleTable);
        exampleTable.addAttributes(newAttributeList);
        LogService.getGlobal().log("Generator list: " + generatorList, 2);
        LogService.getGlobal().log("Input set has " + exampleTable.getAttributeCount() + " features, " + exampleTable.size() + " examples.", 2);
        DataRowReader reader = exampleTable.getDataRowReader();
        while (reader.hasNext()) {
            DataRow dataRow = (DataRow)reader.next();
            for (int j = 0; j < generators.length; ++j) {
                generators[j].generate(dataRow);
            }
        }
        LogService.getGlobal().log("Finished feature generation.", 2);
        LogService.getGlobal().log("Generated set has " + exampleTable.getAttributeCount() + " features, " + exampleTable.size() + " examples.", 2);
        return newAttributeList;
    }

    private static List<Attribute> newAttributes(FeatureGenerator[] generators, ExampleTable exampleTable) {
        LinkedList<Attribute> newAttributeList = new LinkedList<Attribute>();
        for (int i = 0; i < generators.length; ++i) {
            Attribute[] outputAttribute = generators[i].getOutputAttributes(exampleTable);
            generators[i].resultAttributes = new Attribute[outputAttribute.length];
            for (int j = 0; j < outputAttribute.length; ++j) {
                newAttributeList.add(outputAttribute[j]);
                generators[i].resultAttributes[j] = outputAttribute[j];
            }
            if (!generators[i].argumentsSet()) {
                throw new RuntimeException("Catastrophic error: arguments not set for " + generators[i] + "!");
            }
            if (generators[i].argumentsOk(exampleTable)) continue;
            LogService.getGlobal().log("Wrong argument types for " + generators[i] + ".", 5);
        }
        return newAttributeList;
    }

    public static int getSelectionMode() {
        return selectionMode;
    }

    public static void setSelectionMode(int mode) {
        selectionMode = mode;
    }

    public String toString() {
        return "FeatureGenerator (" + this.getClass().getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        FeatureGenerator fg = (FeatureGenerator)o;
        if (!this.getFunction().equals(fg.getFunction())) {
            return false;
        }
        if (this.arguments.length != fg.arguments.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            if (((Object)this.arguments[i]).equals(fg.arguments[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.getFunction().hashCode();
        if (this.arguments != null) {
            hashCode ^= Arrays.hashCode(this.arguments);
        }
        return hashCode;
    }

    static {
        for (int i = 0; i < FUNCTION_NAMES.length; ++i) {
            generatorMap.put(FUNCTION_NAMES[i], GENERATOR_CLASSES[i]);
        }
        selectionMode = 0;
    }
}

