/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.SingularNumericalGenerator;
import com.rapidminer.tools.LogService;

public class ExponentialFunctionGenerator
extends SingularNumericalGenerator {
    public static final int EXP = 0;
    public static final int LOG = 1;
    private static final String[] FUNCTION_NAMES = new String[]{"exp", "log"};
    private int mode;

    public ExponentialFunctionGenerator(int mode) {
        this.mode = mode;
    }

    public ExponentialFunctionGenerator() {
    }

    @Override
    public FeatureGenerator newInstance() {
        return new ExponentialFunctionGenerator(this.mode);
    }

    @Override
    public double calculateValue(double value) {
        double r = 0.0;
        switch (this.mode) {
            case 0: {
                r = Math.exp(value);
                break;
            }
            case 1: {
                r = Math.log(value);
            }
        }
        return r;
    }

    @Override
    public void setFunction(String name) {
        for (int i = 0; i < FUNCTION_NAMES.length; ++i) {
            if (!FUNCTION_NAMES[i].equals(name)) continue;
            this.mode = i;
            return;
        }
        LogService.getGlobal().log("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
    }

    @Override
    public String getFunction() {
        return FUNCTION_NAMES[this.mode];
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.mode == ((ExponentialFunctionGenerator)o).mode;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Integer.valueOf(this.mode).hashCode();
    }
}

